/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.physics_assembler;

import com.deltasf.createpropulsion.network.PropulsionPackets;
import com.deltasf.createpropulsion.physics_assembler.AssemblyUtility;
import com.deltasf.createpropulsion.physics_assembler.packets.GaugeUsedPacket;
import com.deltasf.createpropulsion.physics_assembler.packets.ResetGaugePacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class AssemblyGaugeItem
extends Item {
    private static final String NBT_KEY_POS1 = "posA";
    private static final String NBT_KEY_POS2 = "posB";

    public AssemblyGaugeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_6777_(@Nonnull BlockState pState, @Nonnull Level pLevel, @Nonnull BlockPos pPos, @Nonnull Player pPlayer) {
        return false;
    }

    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos targetedPos = AssemblyUtility.getTargetedPosition(context.m_8083_(), context.m_43719_(), player);
        CompoundTag nbt = stack.m_41784_();
        boolean hasPosA = nbt.m_128441_(NBT_KEY_POS1);
        boolean hasPosB = nbt.m_128441_(NBT_KEY_POS2);
        if (hasPosA && hasPosB) {
            AssemblyGaugeItem.resetPositions(stack, null);
        }
        if (!nbt.m_128441_(NBT_KEY_POS1)) {
            nbt.m_128365_(NBT_KEY_POS1, (Tag)NbtUtils.m_129224_((BlockPos)targetedPos));
        } else {
            BlockPos posA = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(NBT_KEY_POS1));
            if (Math.abs(posA.m_123341_() - targetedPos.m_123341_()) > 32 || Math.abs(posA.m_123342_() - targetedPos.m_123342_()) > 32 || Math.abs(posA.m_123343_() - targetedPos.m_123343_()) > 32) {
                return InteractionResult.FAIL;
            }
            nbt.m_128365_(NBT_KEY_POS2, (Tag)NbtUtils.m_129224_((BlockPos)targetedPos));
            AABB selection = AssemblyUtility.fromBlockVolumes(posA, targetedPos);
            PropulsionPackets.sendToAll(new GaugeUsedPacket(selection));
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public static BlockPos getPosA(ItemStack stack) {
        return AssemblyGaugeItem.getPos(stack, NBT_KEY_POS1);
    }

    @Nullable
    public static BlockPos getPosB(ItemStack stack) {
        return AssemblyGaugeItem.getPos(stack, NBT_KEY_POS2);
    }

    @Nullable
    private static BlockPos getPos(ItemStack stack, String key) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_(key)) {
            return null;
        }
        return NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(key));
    }

    public static void resetPositions(ItemStack stack, @Nullable Player player) {
        if (!(stack.m_41720_() instanceof AssemblyGaugeItem) || !stack.m_41782_()) {
            return;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return;
        }
        nbt.m_128473_(NBT_KEY_POS1);
        nbt.m_128473_(NBT_KEY_POS2);
    }

    public static boolean handleLeftClick(Player player) {
        AABB selectionBox;
        ItemStack stack = player.m_21205_();
        if (!AssemblyUtility.isAssemblyGauge(stack)) {
            return false;
        }
        BlockPos posA = AssemblyGaugeItem.getPosA(stack);
        BlockPos posB = AssemblyGaugeItem.getPosB(stack);
        boolean shouldReset = false;
        if (posA != null && posB == null) {
            shouldReset = true;
        } else if (posA != null && posB != null && AssemblyUtility.isPlayerLookingAtAABB(player, selectionBox = AssemblyUtility.fromBlockVolumes(posA, posB), 1.0f, 0.0, 0.05)) {
            shouldReset = true;
        }
        if (shouldReset) {
            PropulsionPackets.sendToServer(new ResetGaugePacket());
            return true;
        }
        return false;
    }
}

