/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.physics_assembler;

import com.deltasf.createpropulsion.physics_assembler.AssemblyGaugeItem;
import com.simibubi.create.AllSpecialTextures;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class AssemblyUtility {
    public static final int PASSIVE_COLOR = 11495621;
    public static final int HIGHLIGHT_COLOR = 14325744;
    public static final int CANCEL_COLOR = 0xFF5555;
    public static final int MAX_ASSEMBLY_SIZE = 32;
    public static final int MAX_RENDERED_OUTLINE_SIZE = 1024;

    public static void renderOutline(String key, AABB boundingBox, int color, float lineWidth, boolean showFace) {
        if (AssemblyUtility.isAABBLarger(boundingBox, 1024)) {
            return;
        }
        Outline.OutlineParams outline = Outliner.getInstance().showAABB((Object)key, boundingBox).colored(color).lineWidth(lineWidth).disableLineNormals();
        if (showFace) {
            outline.withFaceTexture((BindableTexture)AllSpecialTextures.SELECTION);
        }
    }

    public static int lerpColor(float progress, int color1, int color2) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)Mth.m_14179_((float)progress, (float)r1, (float)r2);
        int g = (int)Mth.m_14179_((float)progress, (float)g1, (float)g2);
        int b = (int)Mth.m_14179_((float)progress, (float)b1, (float)b2);
        return r << 16 | g << 8 | b;
    }

    public static boolean isAssemblyGauge(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof AssemblyGaugeItem;
    }

    public static BlockPos getTargetedPosition(BlockPos pos, Direction face, Player player) {
        if (player.m_6144_()) {
            return pos;
        }
        return pos.m_121945_(face);
    }

    public static AABB fromBlockVolumes(BlockPos posA, BlockPos posB) {
        return new AABB(posA).m_82367_(new AABB(posB));
    }

    public static boolean isPlayerLookingAtAABB(Player player, AABB box, float partialTicks, double reachBonus, double inflation) {
        Level level = player.m_9236_();
        if (level == null) {
            return false;
        }
        Vec3 boxCenter = box.m_82399_();
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (double)boxCenter.f_82479_, (double)boxCenter.f_82480_, (double)boxCenter.f_82481_);
        Vec3 eyePos = player.m_20299_(partialTicks);
        Attribute reachAttr = (Attribute)ForgeMod.BLOCK_REACH.get();
        if (reachAttr == null) {
            return false;
        }
        double reach = player.m_21051_(reachAttr).m_22135_() + reachBonus;
        Vec3 lookVec = player.m_20252_(partialTicks);
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(reach));
        AABB inflatedBox = box.m_82400_(inflation);
        if (ship == null) {
            return inflatedBox.m_82390_(eyePos) || inflatedBox.m_82371_(eyePos, endPos).isPresent();
        }
        Matrix4dc worldToShip = ship.getTransform().getWorldToShip();
        Vector3d worldEyePos = new Vector3d(eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_);
        Vector3d worldEndPos = new Vector3d(endPos.f_82479_, endPos.f_82480_, endPos.f_82481_);
        Vector3d shipEyePos = worldToShip.transformPosition((Vector3dc)worldEyePos, new Vector3d());
        Vector3d shipEndPos = worldToShip.transformPosition((Vector3dc)worldEndPos, new Vector3d());
        Vec3 shipRayStart = new Vec3(shipEyePos.x, shipEyePos.y, shipEyePos.z);
        Vec3 shipRayEnd = new Vec3(shipEndPos.x, shipEndPos.y, shipEndPos.z);
        return inflatedBox.m_82390_(shipRayStart) || inflatedBox.m_82371_(shipRayStart, shipRayEnd).isPresent();
    }

    public static boolean isAABBLarger(AABB aabb, int maxSize) {
        return aabb.m_82362_() > (double)maxSize || aabb.m_82376_() > (double)maxSize || aabb.m_82385_() > (double)maxSize;
    }
}

