/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.physics_assembler;

import com.deltasf.createpropulsion.physics_assembler.AssemblyGaugeItem;
import com.deltasf.createpropulsion.physics_assembler.AssemblyUtility;
import com.deltasf.createpropulsion.physics_assembler.PhysicsAssemblerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class PhysicsAssemblerRenderer
extends SafeBlockEntityRenderer<PhysicsAssemblerBlockEntity> {
    public PhysicsAssemblerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(PhysicsAssemblerBlockEntity assembler, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        BlockHitResult blockHitResult;
        ItemStack gaugeStack = assembler.getGaugeStack();
        if (gaugeStack.m_41619_()) {
            return;
        }
        this.renderItem(poseStack, gaugeStack, assembler, bufferSource, light, overlay);
        Minecraft mc = Minecraft.m_91087_();
        HitResult hitResult = mc.f_91077_;
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK && (blockHitResult = (BlockHitResult)hitResult).m_82425_().equals((Object)assembler.m_58899_())) {
            this.renderSelectionOutline(assembler);
        }
    }

    private void renderItem(PoseStack poseStack, ItemStack gaugeStack, PhysicsAssemblerBlockEntity assembler, MultiBufferSource bufferSource, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel bakedModel = itemRenderer.m_174264_(gaugeStack, assembler.m_58904_(), null, 0);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.1625, 0.5);
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        float rotation = assembler.getGaugeRotation();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        itemRenderer.m_115143_(gaugeStack, ItemDisplayContext.FIXED, false, poseStack, bufferSource, light, overlay, bakedModel);
        poseStack.m_85849_();
    }

    private void renderSelectionOutline(PhysicsAssemblerBlockEntity assembler) {
        ItemStack gaugeStack = assembler.getGaugeStack();
        if (gaugeStack.m_41619_()) {
            return;
        }
        BlockPos posA = AssemblyGaugeItem.getPosA(gaugeStack);
        BlockPos posB = AssemblyGaugeItem.getPosB(gaugeStack);
        if (posA == null || posB == null) {
            return;
        }
        AABB selectionBox = new AABB(posA).m_82367_(new AABB(posB));
        AssemblyUtility.renderOutline("assembler_selection", selectionBox, 11495621, 0.0625f, true);
    }
}

