/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.registries.PropulsionShapes;
import com.deltasf.createpropulsion.thruster.AbstractThrusterBlockEntity;
import com.deltasf.createpropulsion.thruster.ThrusterForceAttachment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractThrusterBlock
extends DirectionalBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"redstone_power", (int)0, (int)15);

    protected AbstractThrusterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(@Nullable BlockState pState, @Nullable BlockGetter pLevel, @Nullable BlockPos pPos, @Nullable CollisionContext pContext) {
        if (pState == null) {
            return PropulsionShapes.THRUSTER.get(Direction.NORTH);
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            direction = direction.m_122424_();
        }
        return PropulsionShapes.THRUSTER.get(direction);
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Direction baseDirection = context.m_7820_();
        Player player = context.m_43723_();
        Direction placeDirection = player != null ? (!player.m_6144_() ? baseDirection : baseDirection.m_122424_()) : baseDirection.m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeDirection);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER});
    }

    @Nullable
    public abstract BlockEntity m_142194_(@Nonnull BlockPos var1, @Nonnull BlockState var2);

    @Nullable
    public abstract <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level var1, @Nonnull BlockState var2, @Nonnull BlockEntityType<T> var3);

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.m_5776_()) {
            this.doRedstoneCheck(level, state, pos);
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        ThrusterForceAttachment ship;
        if (!state.m_60713_(newState.m_60734_()) && !level.m_5776_() && (ship = ThrusterForceAttachment.get(level, pos)) != null) {
            ship.removeApplier((ServerLevel)level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        this.doRedstoneCheck(level, state, pos);
    }

    public void doRedstoneCheck(Level level, BlockState state, BlockPos pos) {
        int oldRedstonePower;
        int newRedstonePower = level.m_277086_(pos);
        if (newRedstonePower == (oldRedstonePower = ((Integer)state.m_61143_((Property)POWER)).intValue())) {
            return;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newRedstonePower));
        level.m_7731_(pos, newState, 3);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractThrusterBlockEntity) {
            AbstractThrusterBlockEntity thrusterBlockEntity = (AbstractThrusterBlockEntity)blockEntity;
            thrusterBlockEntity.calculateObstruction(level, pos, (Direction)state.m_61143_((Property)FACING));
            thrusterBlockEntity.updateThrust(newState);
            thrusterBlockEntity.m_6596_();
        }
    }

    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(@Nonnull BlockState state, @Nonnull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

