/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.compat.PropulsionCompatibility;
import com.deltasf.createpropulsion.compat.computercraft.ComputerBehaviour;
import com.deltasf.createpropulsion.particles.ParticleTypes;
import com.deltasf.createpropulsion.particles.PlumeParticleData;
import com.deltasf.createpropulsion.thruster.AbstractThrusterBlock;
import com.deltasf.createpropulsion.thruster.ThrusterDamager;
import com.deltasf.createpropulsion.thruster.ThrusterData;
import com.deltasf.createpropulsion.thruster.ThrusterForceApplier;
import com.deltasf.createpropulsion.thruster.ThrusterForceAttachment;
import com.deltasf.createpropulsion.utility.GoggleUtils;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Math;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public abstract class AbstractThrusterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected static final int OBSTRUCTION_LENGTH = 10;
    protected static final int TICKS_PER_ENTITY_CHECK = 5;
    protected static final int LOWEST_POWER_THRSHOLD = 5;
    private static final float PARTICLE_VELOCITY = 4.0f;
    private static final double NOZZLE_OFFSET_FROM_CENTER = 0.9;
    private static final double SHIP_VELOCITY_INHERITANCE = 0.5;
    protected ThrusterData thrusterData = new ThrusterData();
    protected int emptyBlocks;
    protected boolean isThrustDirty = false;
    private final ThrusterDamager damager;
    private int currentTick = 0;
    private int clientTick = 0;
    private float particleSpawnAccumulator = 0.0f;
    protected ParticleType<PlumeParticleData> particleType = ParticleTypes.getPlumeType();
    public AbstractComputerBehaviour computerBehaviour;
    public boolean overridePower = false;
    public int overridenPower;

    public AbstractThrusterBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.damager = new ThrusterDamager(this);
    }

    public void initialize() {
        super.initialize();
        if (!this.f_58857_.f_46443_) {
            Block block;
            BlockState state = this.m_58900_();
            this.calculateObstruction(this.f_58857_, this.f_58858_, (Direction)state.m_61143_((Property)AbstractThrusterBlock.FACING));
            ThrusterForceAttachment ship = ThrusterForceAttachment.get(this.f_58857_, this.f_58858_);
            if (ship != null) {
                ThrusterData data = this.getThrusterData();
                data.setDirection(VectorConversionsMCKt.toJOMLD((Vec3i)((Direction)state.m_61143_((Property)AbstractThrusterBlock.FACING)).m_122436_()));
                data.setThrust(0.0f);
                ThrusterForceApplier applier = new ThrusterForceApplier(data);
                ship.addApplier(this.f_58858_, applier);
            }
            if ((block = this.m_58900_().m_60734_()) instanceof AbstractThrusterBlock) {
                ((AbstractThrusterBlock)block).doRedstoneCheck(this.f_58857_, this.m_58900_(), this.f_58858_);
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (PropulsionCompatibility.CC_ACTIVE) {
            this.computerBehaviour = new ComputerBehaviour(this);
            behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        }
    }

    public void tick() {
        if (this.m_58901_()) {
            return;
        }
        if (this.f_58857_.m_8055_(this.f_58858_).m_60734_() != this.m_58900_().m_60734_()) {
            this.m_7651_();
            return;
        }
        super.tick();
        BlockState currentBlockState = this.m_58900_();
        if (this.f_58857_.f_46443_) {
            if (this.shouldEmitParticles()) {
                this.emitParticles(this.f_58857_, this.f_58858_, currentBlockState);
            }
            return;
        }
        ++this.currentTick;
        this.damager.tick(this.currentTick);
        int tick_rate = (Integer)PropulsionConfig.THRUSTER_TICKS_PER_UPDATE.get();
        if (this.currentTick % (tick_rate * 2) == 0) {
            int previousEmptyBlocks = this.emptyBlocks;
            this.calculateObstruction(this.f_58857_, this.f_58858_, (Direction)currentBlockState.m_61143_((Property)AbstractThrusterBlock.FACING));
            if (previousEmptyBlocks != this.emptyBlocks) {
                this.isThrustDirty = true;
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, currentBlockState, currentBlockState, 2);
            }
        }
        if (this.isThrustDirty || this.currentTick % tick_rate == 0) {
            this.updateThrust(currentBlockState);
        }
    }

    public abstract void updateThrust(BlockState var1);

    protected abstract boolean isWorking();

    protected abstract LangBuilder getGoggleStatus();

    @Nullable
    protected abstract Direction getFluidCapSide();

    public ThrusterData getThrusterData() {
        return this.thrusterData;
    }

    public int getEmptyBlocks() {
        return this.emptyBlocks;
    }

    public void dirtyThrust() {
        this.isThrustDirty = true;
    }

    protected boolean shouldEmitParticles() {
        return this.isPowered() && this.isWorking();
    }

    protected boolean shouldDamageEntities() {
        return (Boolean)PropulsionConfig.THRUSTER_DAMAGE_ENTITIES.get() != false && this.isPowered() && this.isWorking();
    }

    protected void addSpecificGoggleInfo(List<Component> tooltip, boolean isPlayerSneaking) {
    }

    protected boolean isPowered() {
        return this.getOverriddenPowerOrState(this.m_58900_()) > 0;
    }

    protected float calculateObstructionEffect() {
        return (float)this.emptyBlocks / 10.0f;
    }

    protected int getOverriddenPowerOrState(BlockState currentBlockState) {
        if (PropulsionCompatibility.CC_ACTIVE && this.overridePower) {
            return this.overridenPower;
        }
        return (Integer)currentBlockState.m_61143_((Property)AbstractThrusterBlock.POWER);
    }

    public void emitParticles(Level level, BlockPos pos, BlockState state) {
        if (this.emptyBlocks == 0) {
            return;
        }
        int power = this.getOverriddenPowerOrState(state);
        double particleCountMultiplier = Math.clamp((double)0.0, (double)2.0, (double)((Double)PropulsionConfig.THRUSTER_PARTICLE_COUNT_MULTIPLIER.get()));
        if (particleCountMultiplier <= 0.0) {
            return;
        }
        ++this.clientTick;
        if (power < 5 && this.clientTick % 2 == 0) {
            this.clientTick = 0;
            return;
        }
        this.particleSpawnAccumulator = (float)((double)this.particleSpawnAccumulator + particleCountMultiplier);
        int particlesToSpawn = (int)this.particleSpawnAccumulator;
        if (particlesToSpawn == 0) {
            return;
        }
        this.particleSpawnAccumulator -= (float)particlesToSpawn;
        float powerPercentage = (float)Math.max((int)power, (int)5) / 15.0f;
        Direction direction = (Direction)state.m_61143_((Property)AbstractThrusterBlock.FACING);
        Direction oppositeDirection = direction.m_122424_();
        double currentNozzleOffset = 0.9;
        Vector3d additionalVel = new Vector3d();
        ClientShip ship = VSGameUtilsKt.getShipObjectManagingPos((ClientLevel)((ClientLevel)level), (Vec3i)pos);
        if (ship != null) {
            Vector3dc shipWorldVelocityJOML = ship.getVelocity();
            Matrix4dc transform = ship.getRenderTransform().getShipToWorld();
            Matrix4dc invTransform = ship.getRenderTransform().getWorldToShip();
            Vector3d shipVelocity = invTransform.transformDirection(new Vector3d(shipWorldVelocityJOML));
            Vector3d particleEjectionUnitVecJOML = transform.transformDirection(VectorConversionsMCKt.toJOMLD((Vec3i)oppositeDirection.m_122436_()));
            double shipVelComponentAlongRotatedEjection = shipWorldVelocityJOML.dot((Vector3dc)particleEjectionUnitVecJOML);
            if (shipVelComponentAlongRotatedEjection > 0.0) {
                Vector3d normalizedVelocity = new Vector3d();
                shipWorldVelocityJOML.normalize(normalizedVelocity);
                double shipVelComponentAlongRotatedEjectionNormalized = normalizedVelocity.dot((Vector3dc)particleEjectionUnitVecJOML);
                double effect = Math.clamp((double)0.0, (double)1.0, (double)shipVelComponentAlongRotatedEjectionNormalized);
                double additionalOffset = shipVelComponentAlongRotatedEjection * (Double)PropulsionConfig.THRUSTER_PARTICLE_OFFSET_INCOMING_VEL_MODIFIER.get();
                currentNozzleOffset += additionalOffset * effect;
                additionalVel = new Vector3d((Vector3dc)shipVelocity).mul(0.5 * effect);
            }
        }
        double particleX = (double)pos.m_123341_() + 0.5 + (double)oppositeDirection.m_122429_() * currentNozzleOffset;
        double particleY = (double)pos.m_123342_() + 0.5 + (double)oppositeDirection.m_122430_() * currentNozzleOffset;
        double particleZ = (double)pos.m_123343_() + 0.5 + (double)oppositeDirection.m_122431_() * currentNozzleOffset;
        Vector3d particleVelocity = new Vector3d((double)oppositeDirection.m_122429_(), (double)oppositeDirection.m_122430_(), (double)oppositeDirection.m_122431_()).mul((double)(4.0f * powerPercentage)).add((Vector3dc)additionalVel);
        for (int i = 0; i < particlesToSpawn; ++i) {
            level.m_6493_((ParticleOptions)new PlumeParticleData(this.particleType), true, particleX, particleY, particleZ, particleVelocity.x, particleVelocity.y, particleVelocity.z);
        }
    }

    public void calculateObstruction(Level level, BlockPos pos, Direction forwardDirection) {
        BlockPos checkPos;
        BlockState state;
        int oldEmptyBlocks = this.emptyBlocks;
        this.emptyBlocks = 0;
        while (this.emptyBlocks < 10 && ((state = level.m_8055_(checkPos = pos.m_5484_(forwardDirection.m_122424_(), this.emptyBlocks + 1))).m_60795_() || !state.m_280296_())) {
            ++this.emptyBlocks;
        }
        if (oldEmptyBlocks != this.emptyBlocks) {
            this.isThrustDirty = true;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean wasThrustDirty = this.isThrustDirty;
        this.calculateObstruction(this.m_58904_(), this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)AbstractThrusterBlock.FACING));
        this.isThrustDirty = wasThrustDirty;
        CreateLang.translate((String)"gui.goggles.thruster.status", (Object[])new Object[0]).text(":").space().add(this.getGoggleStatus()).forGoggles(tooltip);
        float efficiency = 100.0f;
        ChatFormatting tooltipColor = ChatFormatting.GREEN;
        if (this.emptyBlocks < 10) {
            efficiency = this.calculateObstructionEffect() * 100.0f;
            tooltipColor = GoggleUtils.efficiencyColor(efficiency);
            CreateLang.builder().add(CreateLang.translate((String)"gui.goggles.thruster.obstructed", (Object[])new Object[0])).space().add(CreateLang.text((String)GoggleUtils.makeObstructionBar(this.emptyBlocks, 10))).style(tooltipColor).forGoggles(tooltip);
        }
        CreateLang.builder().add(CreateLang.translate((String)"gui.goggles.thruster.efficiency", (Object[])new Object[0])).space().add(CreateLang.number((double)efficiency)).add(CreateLang.text((String)"%")).style(tooltipColor).forGoggles(tooltip);
        this.addSpecificGoggleInfo(tooltip, isPlayerSneaking);
        return true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("emptyBlocks", this.emptyBlocks);
        compound.m_128405_("currentTick", this.currentTick);
        if (PropulsionCompatibility.CC_ACTIVE) {
            compound.m_128405_("overridenPower", this.overridenPower);
            compound.m_128379_("overridePower", this.overridePower);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.emptyBlocks = compound.m_128451_("emptyBlocks");
        this.currentTick = compound.m_128451_("currentTick");
        if (PropulsionCompatibility.CC_ACTIVE) {
            this.overridenPower = compound.m_128451_("overridenPower");
            this.overridePower = compound.m_128471_("overridePower");
        }
    }
}

