/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.thruster.ThrusterForceApplier;
import com.deltasf.createpropulsion.utility.AttachmentUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

public class ThrusterForceAttachment
implements ShipForcesInducer {
    public Map<BlockPos, ThrusterForceApplier> appliersMapping = new ConcurrentHashMap<BlockPos, ThrusterForceApplier>();

    public void applyForces(@NotNull PhysShip physicShip) {
        PhysShipImpl ship = (PhysShipImpl)physicShip;
        this.appliersMapping.forEach((pos, applier) -> applier.applyForces((BlockPos)pos, ship));
    }

    public void addApplier(BlockPos pos, ThrusterForceApplier applier) {
        this.appliersMapping.put(pos, applier);
    }

    public void removeApplier(ServerLevel level, BlockPos pos) {
        ServerShip ship;
        this.appliersMapping.remove(pos);
        if (this.appliersMapping.isEmpty() && (ship = AttachmentUtils.getShipAt(level, pos)) != null) {
            ship.saveAttachment(ThrusterForceAttachment.class, null);
        }
    }

    public static ThrusterForceAttachment getOrCreateAsAttachment(ServerShip ship) {
        return AttachmentUtils.getOrCreate(ship, ThrusterForceAttachment.class, ThrusterForceAttachment::new);
    }

    public static ThrusterForceAttachment get(Level level, BlockPos pos) {
        return AttachmentUtils.get(level, pos, ThrusterForceAttachment.class, ThrusterForceAttachment::new);
    }
}

