/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster.thruster;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.compat.PropulsionCompatibility;
import com.deltasf.createpropulsion.thruster.AbstractThrusterBlockEntity;
import com.deltasf.createpropulsion.thruster.FluidThrusterProperties;
import com.deltasf.createpropulsion.thruster.ThrusterFuelManager;
import com.deltasf.createpropulsion.thruster.thruster.ThrusterBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ThrusterBlockEntity
extends AbstractThrusterBlockEntity {
    public static final float BASE_FUEL_CONSUMPTION = 2.0f;
    public static final int BASE_MAX_THRUST = 400000;
    public SmartFluidTankBehaviour tank;

    public ThrusterBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)200);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == this.getFluidCapSide()) {
            return this.tank.getCapability().cast();
        }
        if (PropulsionCompatibility.CC_ACTIVE && this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void updateThrust(BlockState currentBlockState) {
        float thrust = 0.0f;
        int power = this.getOverriddenPowerOrState(currentBlockState);
        if (this.isWorking() && power > 0) {
            FluidThrusterProperties properties = this.getFuelProperties(this.fluidStack().getRawFluid());
            float powerPercentage = (float)power / 15.0f;
            float obstructionEffect = this.calculateObstructionEffect();
            float thrustPercentage = Math.min(powerPercentage, obstructionEffect);
            if (thrustPercentage > 0.0f && properties != null) {
                int tick_rate = (Integer)PropulsionConfig.THRUSTER_TICKS_PER_UPDATE.get();
                int consumption = this.calculateFuelConsumption(powerPercentage, properties.consumptionMultiplier, tick_rate);
                FluidStack drainedStack = this.tank.getPrimaryHandler().drain(consumption, IFluidHandler.FluidAction.EXECUTE);
                int fuelConsumed = drainedStack.getAmount();
                if (fuelConsumed > 0) {
                    float consumptionRatio = (float)fuelConsumed / (float)consumption;
                    float thrustMultiplier = (float)((Double)PropulsionConfig.THRUSTER_THRUST_MULTIPLIER.get()).doubleValue();
                    thrust = 400000.0f * thrustMultiplier * thrustPercentage * properties.thrustMultiplier * consumptionRatio;
                }
            }
        }
        this.thrusterData.setThrust(thrust);
        this.isThrustDirty = false;
    }

    @Override
    protected boolean isWorking() {
        return this.validFluid();
    }

    @Override
    protected Direction getFluidCapSide() {
        return (Direction)this.m_58900_().m_61143_((Property)ThrusterBlock.FACING);
    }

    @Override
    protected LangBuilder getGoggleStatus() {
        if (this.fluidStack().isEmpty()) {
            return CreateLang.translate((String)"gui.goggles.thruster.status.no_fuel", (Object[])new Object[0]).style(ChatFormatting.RED);
        }
        if (!this.validFluid()) {
            return CreateLang.translate((String)"gui.goggles.thruster.status.wrong_fuel", (Object[])new Object[0]).style(ChatFormatting.RED);
        }
        if (!this.isPowered()) {
            return CreateLang.translate((String)"gui.goggles.thruster.status.not_powered", (Object[])new Object[0]).style(ChatFormatting.GOLD);
        }
        if (this.emptyBlocks == 0) {
            return CreateLang.translate((String)"gui.goggles.thruster.obstructed", (Object[])new Object[0]).style(ChatFormatting.RED);
        }
        return CreateLang.translate((String)"gui.goggles.thruster.status.working", (Object[])new Object[0]).style(ChatFormatting.GREEN);
    }

    @Override
    protected void addSpecificGoggleInfo(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
    }

    public FluidStack fluidStack() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    public boolean validFluid() {
        if (this.fluidStack().isEmpty()) {
            return false;
        }
        return this.getFuelProperties(this.fluidStack().getRawFluid()) != null;
    }

    public FluidThrusterProperties getFuelProperties(Fluid fluid) {
        return ThrusterFuelManager.getProperties(fluid);
    }

    private int calculateFuelConsumption(float powerPercentage, float fluidPropertiesConsumptionMultiplier, int tick_rate) {
        float base_consumption = 2.0f * (float)((Double)PropulsionConfig.THRUSTER_CONSUMPTION_MULTIPLIER.get()).doubleValue();
        return (int)Math.ceil(base_consumption * powerPercentage * fluidPropertiesConsumptionMultiplier * (float)tick_rate);
    }
}

