/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.utility;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class AttachmentUtils {
    private AttachmentUtils() {
    }

    @Nullable
    public static ServerShip getShipAt(ServerLevel serverLevel, BlockPos pos) {
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos);
        if (ship == null) {
            ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)pos);
        }
        return ship;
    }

    public static <T> T getOrCreate(ServerShip ship, Class<T> attachmentClass, Supplier<T> factory) {
        Object attachment = ship.getAttachment(attachmentClass);
        if (attachment == null) {
            attachment = factory.get();
            ship.saveAttachment(attachmentClass, attachment);
        }
        return (T)attachment;
    }

    @Nullable
    public static <T> T get(Level level, BlockPos pos, Class<T> attachmentClass, Supplier<T> factory) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ServerShip ship = AttachmentUtils.getShipAt(serverLevel, pos);
        return ship != null ? (T)AttachmentUtils.getOrCreate(ship, attachmentClass, factory) : null;
    }
}

