/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.utility;

import com.simibubi.create.foundation.collision.Matrix3d;
import net.minecraft.core.Vec3i;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class MathUtility {
    public static Matrix3d createMatrixFromQuaternion(Quaterniond quaternion) {
        double yaw;
        double roll;
        double pitch;
        double x;
        double z;
        double y;
        double qw = quaternion.w;
        double qx = quaternion.x;
        double qy = quaternion.y;
        double qz = quaternion.z;
        double lengthSq = qx * qx + qy * qy + qz * qz + qw * qw;
        double invLength = 1.0 / Math.sqrt(lengthSq);
        double w = qw * invLength;
        double sinp = 2.0 * (w * (y = qy * invLength) - (z = qz * invLength) * (x = qx * invLength));
        if (Math.abs(sinp) > 0.999999) {
            pitch = 1.5707963267948966 * Math.signum(sinp);
            roll = Math.atan2(2.0 * (x * y + w * z), 1.0 - 2.0 * (y * y + z * z));
            yaw = 0.0;
        } else {
            roll = Math.atan2(2.0 * (w * x + y * z), 1.0 - 2.0 * (x * x + y * y));
            pitch = Math.asin(sinp);
            yaw = Math.atan2(2.0 * (w * z + x * y), 1.0 - 2.0 * (y * y + z * z));
        }
        Matrix3d resultMatrix = new Matrix3d();
        Matrix3d tempY = new Matrix3d();
        Matrix3d tempX = new Matrix3d();
        resultMatrix.asZRotation((float)yaw);
        tempY.asYRotation((float)pitch);
        resultMatrix.multiply(tempY);
        tempX.asXRotation((float)roll);
        resultMatrix.multiply(tempX);
        return resultMatrix;
    }

    public static Vector2f toHorizontalCoordinateSystem(Quaterniondc shipRotation) {
        Vector3d worldForwardDirection = new Vector3d();
        Vector3d LOCAL_SHIP_FORWARD_NEGATIVE_Z = new Vector3d(0.0, 0.0, -1.0);
        shipRotation.transform((Vector3dc)LOCAL_SHIP_FORWARD_NEGATIVE_Z, worldForwardDirection);
        if (worldForwardDirection.lengthSquared() < 1.0E-12) {
            return new Vector2f(0.0f, 0.0f);
        }
        double horizontalDistance = Math.sqrt(worldForwardDirection.x * worldForwardDirection.x + worldForwardDirection.z * worldForwardDirection.z);
        float yaw = horizontalDistance < 1.0E-9 ? 0.0f : (float)Math.toDegrees(Math.atan2(worldForwardDirection.x, -worldForwardDirection.z));
        float pitch = horizontalDistance < 1.0E-9 ? (worldForwardDirection.y > 0.0 ? 90.0f : (worldForwardDirection.y < 0.0 ? -90.0f : 0.0f)) : (float)Math.toDegrees(Math.atan2(worldForwardDirection.y, horizontalDistance));
        return new Vector2f(yaw, pitch);
    }

    public static Vec3i AbsComponents(Vec3i value) {
        return new Vec3i(Math.abs(value.m_123341_()), Math.abs(value.m_123342_()), Math.abs(value.m_123343_()));
    }
}

