/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.utility;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.registries.PropulsionBlocks;
import com.deltasf.createpropulsion.thruster.FluidThrusterProperties;
import com.deltasf.createpropulsion.thruster.ThrusterFuelManager;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="createpropulsion", value={Dist.CLIENT})
public class TooltipHandler {
    private static HashMap<Item, Function<SummaryPayload, String>> tooltipModificationLookup = new HashMap();

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        String path = "createpropulsion." + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        if (tooltipModificationLookup.isEmpty()) {
            TooltipHandler.populateModifiables();
        }
        List tooltip = event.getToolTip();
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        if (ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals("createpropulsion") && I18n.m_118936_((String)(path + ".tooltip.summary"))) {
            TooltipHandler.handleI18nTooltip(tooltipList, item, path);
        }
        ItemStack stack = event.getItemStack();
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (fluidStack == null || fluidStack.isEmpty()) {
                return;
            }
            Fluid fluid = fluidStack.getFluid();
            FluidThrusterProperties properties = ThrusterFuelManager.getProperties(fluid);
            if (properties == null) {
                return;
            }
            TooltipHandler.handleThrusterFuelTooltip(tooltipList, properties);
        });
        tooltip.addAll(1, tooltipList);
    }

    private static void handleI18nTooltip(List<Component> tooltipList, Item item, String path) {
        TooltipHandler.wrapShiftHoldText(tooltipList, "create.tooltip.holdForDescription", () -> {
            Function<SummaryPayload, String> tooltipModifier = tooltipModificationLookup.get(item);
            if (tooltipModifier != null) {
                String summary = tooltipModifier.apply(new SummaryPayload(item, path));
                tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)summary, (FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE));
            } else {
                tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)Component.m_237115_((String)(path + ".tooltip.summary")).getString(), (FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE));
            }
            if (!Component.m_237115_((String)(path + ".tooltip.condition1")).getString().equals(path + ".tooltip.condition1")) {
                tooltipList.add((Component)Component.m_237119_());
                tooltipList.add((Component)Component.m_237115_((String)(path + ".tooltip.condition1")).m_130940_(ChatFormatting.GRAY));
                tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)Component.m_237115_((String)(path + ".tooltip.behaviour1")).getString(), (Style)FontHelper.Palette.STANDARD_CREATE.primary(), (Style)FontHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
                if (!Component.m_237115_((String)(path + ".tooltip.condition2")).getString().equals(path + ".tooltip.condition2")) {
                    tooltipList.add((Component)Component.m_237115_((String)(path + ".tooltip.condition2")).m_130940_(ChatFormatting.GRAY));
                    tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)Component.m_237115_((String)(path + ".tooltip.behaviour2")).getString(), (Style)FontHelper.Palette.STANDARD_CREATE.primary(), (Style)FontHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
                }
            }
        });
    }

    private static void handleThrusterFuelTooltip(List<Component> tooltipList, FluidThrusterProperties properties) {
        TooltipHandler.wrapShiftHoldText(tooltipList, "createpropulsion.tooltip.holdForRocketFuelSummary", () -> {
            int thrustPercent = Math.round(properties.thrustMultiplier * 100.0f);
            MutableComponent thrustLine = Component.m_237115_((String)"createpropulsion.tooltip.thrust").m_130946_(": ").m_130948_(FontHelper.Palette.STANDARD_CREATE.primary()).m_7220_((Component)Component.m_237113_((String)String.valueOf(thrustPercent)).m_130948_(FontHelper.Palette.STANDARD_CREATE.highlight())).m_7220_((Component)Component.m_237113_((String)"%").m_130948_(FontHelper.Palette.STANDARD_CREATE.primary()));
            tooltipList.add((Component)thrustLine);
            int consumptionPercent = Math.round(properties.consumptionMultiplier * 100.0f);
            MutableComponent consumptionLine = Component.m_237115_((String)"createpropulsion.tooltip.consumption").m_130946_(": ").m_130948_(FontHelper.Palette.STANDARD_CREATE.primary()).m_7220_((Component)Component.m_237113_((String)String.valueOf(consumptionPercent)).m_130948_(FontHelper.Palette.STANDARD_CREATE.highlight())).m_7220_((Component)Component.m_237113_((String)"%").m_130948_(FontHelper.Palette.STANDARD_CREATE.primary()));
            tooltipList.add((Component)consumptionLine);
            tooltipList.add((Component)Component.m_237119_());
        });
    }

    private static void wrapShiftHoldText(List<Component> tooltipList, String langKey, Runnable addDetailedContent) {
        boolean isShiftDown = Screen.m_96638_();
        MutableComponent keyComponent = Component.m_237115_((String)"create.tooltip.keyShift").m_130940_(isShiftDown ? ChatFormatting.WHITE : ChatFormatting.GRAY);
        tooltipList.add((Component)Component.m_237110_((String)langKey, (Object[])new Object[]{keyComponent}).m_130940_(ChatFormatting.DARK_GRAY));
        if (isShiftDown) {
            tooltipList.add((Component)Component.m_237119_());
            addDetailedContent.run();
        }
    }

    private static void populateModifiables() {
        tooltipModificationLookup.put(PropulsionBlocks.THRUSTER_BLOCK.m_5456_(), payload -> {
            float thrustMultiplier = (float)((Double)PropulsionConfig.THRUSTER_THRUST_MULTIPLIER.get()).doubleValue();
            int thrusterStrength = Math.round(400.0f * thrustMultiplier);
            return Component.m_237115_((String)(payload.path + ".tooltip.summary")).getString().replace("{}", String.valueOf(thrusterStrength));
        });
        tooltipModificationLookup.put(PropulsionBlocks.INLINE_OPTICAL_SENSOR_BLOCK.m_5456_(), payload -> {
            int raycastDistance = (Integer)PropulsionConfig.INLINE_OPTICAL_SENSOR_MAX_DISTANCE.get();
            return Component.m_237115_((String)(payload.path + ".tooltip.summary")).getString().replace("{}", String.valueOf(raycastDistance));
        });
    }

    private static class SummaryPayload {
        public Item item;
        public String path;

        public SummaryPayload(Item item, String path) {
            this.item = item;
            this.path = path;
        }
    }
}

