/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.wing;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.registries.PropulsionBlocks;
import com.deltasf.createpropulsion.registries.PropulsionShapes;
import com.deltasf.createpropulsion.utility.MathUtility;
import com.deltasf.createpropulsion.wing.CopycatWingProperties;
import com.deltasf.createpropulsion.wing.WingPlacementHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VoxelShaper;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.mod.common.block.WingBlock;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class CopycatWingBlock
extends CopycatBlock
implements WingBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private final int width;
    private final Supplier<Item> baseItemSupplier;
    private static final List<BlockEntry<?>> entires = List.of(PropulsionBlocks.COPYCAT_WING, PropulsionBlocks.COPYCAT_WING_8, PropulsionBlocks.COPYCAT_WING_12, PropulsionBlocks.WING_BLOCK, PropulsionBlocks.TEMPERED_WING_BLOCK);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new WingPlacementHelper(entires));
    private static final Map<Integer, VoxelShaper> wingShapers = Map.of(4, PropulsionShapes.WING, 8, PropulsionShapes.WING_8, 12, PropulsionShapes.WING_12);

    public CopycatWingBlock(BlockBehaviour.Properties properties, int width, Supplier<Item> baseItemSupplier) {
        super(properties);
        this.width = width;
        this.baseItemSupplier = baseItemSupplier;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public int getWidth() {
        return this.width;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING}));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return wingShapers.get(this.width).get((Direction)state.m_61143_((Property)FACING));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        IPlacementHelper placementHelper;
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_6144_() && player.m_36326_() && (placementHelper = PlacementHelpers.get((int)placementHelperId)).matchesItem(heldItem)) {
            placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    public Wing getWing(@Nullable Level level, @Nullable BlockPos pos, @NotNull BlockState state) {
        Vec3i normal = ((Direction)state.m_61143_((Property)FACING)).m_122436_();
        CopycatWingProperties properties = CopycatWingProperties.PROPERTIES_BY_WIDTH.getOrDefault(this.width, new CopycatWingProperties(0.0, 0.0));
        return new Wing((Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)MathUtility.AbsComponents(normal)), (Double)PropulsionConfig.BASE_WING_LIFT.get() + properties.lift(), (Double)PropulsionConfig.BASE_WING_DRAG.get() + properties.drag(), null, 0.0);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockState material = CopycatWingBlock.getMaterial((BlockGetter)level, (BlockPos)pos);
        if (AllBlocks.COPYCAT_BASE.has(material) || player != null && player.m_6144_()) {
            return new ItemStack((ItemLike)this.baseItemSupplier.get());
        }
        return material.getCloneItemStack(target, level, pos, player);
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        return state.m_61143_((Property)FACING) == toState.m_61143_((Property)FACING);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, @Nullable BlockPos fromPos, @Nullable BlockPos toPos) {
        if (fromPos == null || toPos == null) {
            return true;
        }
        BlockState toState = reader.m_8055_(toPos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!toState.m_60713_((Block)this)) {
            return facing != face.m_122424_();
        }
        Direction toFacing = (Direction)toState.m_61143_((Property)FACING);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.m_123341_() == 0 && diff.m_123343_() == 0 && diff.m_123342_() != 0 && facing.m_122434_() == Direction.Axis.Y && toFacing.m_122434_() == Direction.Axis.Y) {
            return true;
        }
        if (diff.m_123342_() == 0 && diff.m_123343_() == 0 && diff.m_123341_() != 0 && facing.m_122434_() == Direction.Axis.X && toFacing.m_122434_() == Direction.Axis.X) {
            return true;
        }
        return diff.m_123341_() == 0 && diff.m_123342_() == 0 && diff.m_123343_() != 0 && facing.m_122434_() == Direction.Axis.Z && toFacing.m_122434_() == Direction.Axis.Z;
    }

    public List<ItemStack> m_49635_(@Nonnull BlockState state, @Nonnull LootParams.Builder builder) {
        int dropCount = this.width / 4;
        if (dropCount < 1) {
            return Collections.emptyList();
        }
        return List.of(new ItemStack((ItemLike)PropulsionBlocks.COPYCAT_WING.get(), dropCount));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() instanceof CopycatWingBlock) {
            if (state.m_155947_() && state.m_60734_() != newState.m_60734_()) {
                level.m_46747_(pos);
            }
            return;
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

