/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.wing;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.registries.PropulsionBlocks;
import com.deltasf.createpropulsion.registries.PropulsionShapes;
import com.deltasf.createpropulsion.utility.MathUtility;
import com.deltasf.createpropulsion.wing.WingPlacementHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class WingBlock
extends DirectionalBlock
implements org.valkyrienskies.mod.common.block.WingBlock {
    private static final List<BlockEntry<?>> entires = List.of(PropulsionBlocks.COPYCAT_WING, PropulsionBlocks.COPYCAT_WING_8, PropulsionBlocks.COPYCAT_WING_12, PropulsionBlocks.WING_BLOCK, PropulsionBlocks.TEMPERED_WING_BLOCK);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new WingPlacementHelper(entires));

    public WingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_7820_().m_122424_());
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult ray) {
        IPlacementHelper placementHelper;
        ItemStack heldItem = player.m_21120_(hand);
        if (!player.m_6144_() && player.m_36326_() && (placementHelper = PlacementHelpers.get((int)placementHelperId)).matchesItem(heldItem)) {
            placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
    }

    public Wing getWing(@Nullable Level level, @Nullable BlockPos pos, @NotNull BlockState state) {
        Vector3d normal = VectorConversionsMCKt.toJOMLD((Vec3i)MathUtility.AbsComponents(((Direction)state.m_61143_((Property)f_52588_)).m_122436_()));
        return new Wing((Vector3dc)normal, ((Double)PropulsionConfig.BASE_WING_LIFT.get()).doubleValue(), ((Double)PropulsionConfig.BASE_WING_DRAG.get()).doubleValue(), null, 0.0);
    }

    public VoxelShape m_5940_(@Nullable BlockState pState, @Nullable BlockGetter pLevel, @Nullable BlockPos pPos, @Nullable CollisionContext pContext) {
        if (pState == null) {
            return PropulsionShapes.WING.get(Direction.UP);
        }
        return PropulsionShapes.WING.get((Direction)pState.m_61143_((Property)f_52588_));
    }
}

