/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.debug;

import com.deltasf.createpropulsion.debug.DebugLineRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mod.EventBusSubscriber(modid="createpropulsion", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DebugRenderer {
    private static final Map<String, TimedBoxData> timedBoxes = new ConcurrentHashMap<String, TimedBoxData>();

    public static void drawBox(String identifier, Vec3 center, Vec3 size, Quaternionf rotation, Color color, boolean onlyInDebugMode, int ticksToRender) {
        if (identifier == null || identifier.isEmpty()) {
            System.err.println("[DebugRenderer] Error: Null or empty identifier provided for drawBox.");
            return;
        }
        if (ticksToRender <= 0) {
            timedBoxes.remove(identifier);
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        TimedBoxData data = new TimedBoxData((Level)level, center, size, rotation, color, onlyInDebugMode, ticksToRender);
        timedBoxes.put(identifier, data);
    }

    public static void drawBox(String identifier, Vec3 center, Vec3 size, int ticksToRender) {
        DebugRenderer.drawBox(identifier, center, size, new Quaternionf(), Color.WHITE, false, ticksToRender);
    }

    public static void drawBox(String identifier, Vec3 center, Vec3 size, Color color, int ticksToRender) {
        DebugRenderer.drawBox(identifier, center, size, new Quaternionf(), color, false, ticksToRender);
    }

    public static void drawBox(String identifier, AABB aabb, int ticksToRender) {
        DebugRenderer.drawBox(identifier, aabb, Color.WHITE, ticksToRender);
    }

    public static void drawBox(String identifier, AABB aabb, Color color, int ticksToRender) {
        if (aabb == null) {
            System.err.println("[DebugRenderer] Error: Null AABB provided for drawBox with identifier: " + identifier);
            DebugRenderer.removeBox(identifier);
            return;
        }
        Vec3 center = aabb.m_82399_();
        Vec3 size = new Vec3(aabb.m_82362_(), aabb.m_82376_(), aabb.m_82385_());
        DebugRenderer.drawBox(identifier, center, size, new Quaternionf(), color, false, ticksToRender);
    }

    public static void drawBox(String identifier, BlockPos blockPos, int ticksToRender) {
        DebugRenderer.drawBox(identifier, blockPos, Color.WHITE, ticksToRender);
    }

    public static void drawBox(String identifier, BlockPos blockPos, Color color, int ticksToRender) {
        if (blockPos == null) {
            System.err.println("[DebugRenderer] Error: Null BlockPos provided for drawBox with identifier: " + identifier);
            DebugRenderer.removeBox(identifier);
            return;
        }
        Vec3 center = blockPos.m_252807_();
        Vec3 size = new Vec3(1.0, 1.0, 1.0);
        DebugRenderer.drawBox(identifier, center, size, new Quaternionf(), color, false, ticksToRender);
    }

    public static void drawElongatedBox(String identifier, Vec3 posA, Vec3 posB, float thickness, Color color, boolean onlyInDebugMode, int ticksToRender) {
        Vec3 center = posA.m_82549_(posB).m_82490_(0.5);
        Vec3 direction = posB.m_82546_(posA);
        double length = direction.m_82553_();
        Vec3 size = new Vec3((double)thickness, (double)thickness, length);
        Vector3f dir = new Vector3f((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_).normalize();
        Quaternionf rotation = DebugRenderer.getRotationFromZ(dir);
        DebugRenderer.drawBox(identifier, center, size, rotation, color, onlyInDebugMode, ticksToRender);
    }

    public static void removeBox(String identifier) {
        if (identifier != null) {
            timedBoxes.remove(identifier);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (timedBoxes.isEmpty()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null && !mc.m_91104_()) {
                timedBoxes.entrySet().removeIf(entry -> {
                    TimedBoxData data = (TimedBoxData)entry.getValue();
                    --data.remainingTicks;
                    return data.remainingTicks <= 0;
                });
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || timedBoxes.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.f_91063_ == null || mc.m_91269_() == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(DebugLineRenderType.DEBUG_LINE);
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        boolean isDebugMode = mc.f_91066_.f_92063_;
        for (TimedBoxData boxData : timedBoxes.values()) {
            if (boxData.onlyInDebugMode && !isDebugMode) continue;
            DebugRenderer.renderWireBox(poseStack, vertexConsumer, boxData);
        }
        poseStack.m_85849_();
    }

    private static void renderWireBox(PoseStack poseStack, VertexConsumer vertexConsumer, TimedBoxData data) {
        poseStack.m_85836_();
        poseStack.m_85837_(data.position.f_82479_, data.position.f_82480_, data.position.f_82481_);
        poseStack.m_252781_(data.rotation);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float halfW = (float)data.size.f_82479_ / 2.0f;
        float halfH = (float)data.size.f_82480_ / 2.0f;
        float halfD = (float)data.size.f_82481_ / 2.0f;
        Vector3f p0 = new Vector3f(-halfW, -halfH, -halfD);
        Vector3f p1 = new Vector3f(halfW, -halfH, -halfD);
        Vector3f p2 = new Vector3f(halfW, -halfH, halfD);
        Vector3f p3 = new Vector3f(-halfW, -halfH, halfD);
        Vector3f p4 = new Vector3f(-halfW, halfH, -halfD);
        Vector3f p5 = new Vector3f(halfW, halfH, -halfD);
        Vector3f p6 = new Vector3f(halfW, halfH, halfD);
        Vector3f p7 = new Vector3f(-halfW, halfH, halfD);
        float r = (float)data.color.getRed() / 255.0f;
        float g = (float)data.color.getGreen() / 255.0f;
        float b = (float)data.color.getBlue() / 255.0f;
        float a = (float)data.color.getAlpha() / 255.0f;
        DebugRenderer.drawLine(vertexConsumer, matrix, p0, p1, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p1, p2, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p2, p3, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p3, p0, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p4, p5, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p5, p6, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p6, p7, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p7, p4, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p0, p4, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p1, p5, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p2, p6, r, g, b, a);
        DebugRenderer.drawLine(vertexConsumer, matrix, p3, p7, r, g, b, a);
        poseStack.m_85849_();
    }

    private static void drawLine(VertexConsumer consumer, Matrix4f matrix, Vector3f pos1, Vector3f pos2, float r, float g, float b, float a) {
        consumer.m_252986_(matrix, pos1.x(), pos1.y(), pos1.z()).m_85950_(r, g, b, a).m_5752_();
        consumer.m_252986_(matrix, pos2.x(), pos2.y(), pos2.z()).m_85950_(r, g, b, a).m_5752_();
    }

    private static Quaternionf getRotationFromZ(Vector3f direction) {
        Vector3f zAxis = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f axis = new Vector3f();
        zAxis.cross((Vector3fc)direction, axis);
        float dot = zAxis.dot((Vector3fc)direction);
        float angle = (float)Math.acos(dot);
        if ((double)axis.lengthSquared() < 1.0E-6) {
            if (dot > 0.9999f) {
                return new Quaternionf();
            }
            return new Quaternionf().rotateXYZ((float)Math.PI, 0.0f, 0.0f);
        }
        axis.normalize();
        return new Quaternionf().rotateAxis(angle, axis.x, axis.y, axis.z);
    }

    private static class TimedBoxData {
        Vec3 position;
        Vec3 size;
        Quaternionf rotation;
        final Color color;
        final boolean onlyInDebugMode;
        int remainingTicks;

        TimedBoxData(Level level, Vec3 position, Vec3 size, Quaternionf rotation, Color color, boolean onlyInDebugMode, int initialTicks) {
            Ship ship;
            boolean inShipyard = VSGameUtilsKt.isBlockInShipyard((Level)level, (Vec3)position);
            boolean def = true;
            if (inShipyard && (ship = VSGameUtilsKt.getShipManagingPos((Level)level, (double)position.f_82479_, (double)position.f_82480_, (double)position.f_82481_)) != null) {
                def = false;
                Matrix4dc shipToWorldMatrix = ship.getShipToWorld();
                Quaterniondc shipRotation = ship.getTransform().getShipToWorldRotation();
                Vector3d posInShip = VectorConversionsMCKt.toJOML((Vec3)position);
                Vector3d posInWorld = shipToWorldMatrix.transformPosition((Vector3dc)posInShip, new Vector3d());
                Quaterniond rotInShip = new Quaterniond((double)rotation.x, (double)rotation.y, (double)rotation.z, (double)rotation.w);
                Quaterniond rotInWorld = shipRotation.mul((Quaterniondc)rotInShip, new Quaterniond());
                this.position = VectorConversionsMCKt.toMinecraft((Vector3dc)posInWorld);
                this.size = size;
                this.rotation = new Quaternionf((float)rotInWorld.x, (float)rotInWorld.y, (float)rotInWorld.z, (float)rotInWorld.w);
            }
            if (def) {
                this.position = position;
                this.size = size;
                this.rotation = rotation;
            }
            this.color = color;
            this.onlyInDebugMode = onlyInDebugMode;
            this.remainingTicks = initialTicks;
        }
    }
}

