/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.events;

import com.deltasf.createpropulsion.magnet.MagnetForceAttachment;
import com.deltasf.createpropulsion.magnet.MagnetRegistry;
import com.deltasf.createpropulsion.network.PropulsionPackets;
import com.deltasf.createpropulsion.network.SyncThrusterFuelsPacket;
import com.deltasf.createpropulsion.registries.PropulsionCommands;
import com.deltasf.createpropulsion.registries.PropulsionFluids;
import com.deltasf.createpropulsion.thruster.ThrusterFuelManager;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mod.EventBusSubscriber(modid="createpropulsion", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ThrusterFuelManager());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PropulsionPackets.sendToPlayer(SyncThrusterFuelsPacket.create(ThrusterFuelManager.getFuelPropertiesMap()), player2);
        }
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        PropulsionCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MagnetRegistry.get().reset();
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        HashMap<ResourceLocation, ServerLevel> levelLookup = new HashMap<ResourceLocation, ServerLevel>();
        for (ServerLevel level : event.getServer().m_129785_()) {
            levelLookup.put(level.m_46472_().m_135782_(), level);
        }
        ServerLevel overworld = event.getServer().m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        String PREFIX = "minecraft:dimension:";
        QueryableShipData allShips = VSGameUtilsKt.getAllShips((Level)overworld);
        for (Ship ship : allShips) {
            String resourceLocationString;
            ResourceLocation dimensionKey;
            ServerLevel level;
            String shipDimensionId;
            ServerShip sShip;
            MagnetForceAttachment attachment;
            if (!(ship instanceof ServerShip) || (attachment = (MagnetForceAttachment)(sShip = (ServerShip)ship).getAttachment(MagnetForceAttachment.class)) == null || (shipDimensionId = sShip.getChunkClaimDimension()) == null || !shipDimensionId.startsWith("minecraft:dimension:") || (level = (ServerLevel)levelLookup.get(dimensionKey = new ResourceLocation(resourceLocationString = shipDimensionId.substring("minecraft:dimension:".length())))) == null) continue;
            attachment.level = level;
        }
    }

    @SubscribeEvent
    public static void onNeighborBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        boolean isLava;
        BlockPos pos;
        LevelAccessor level = event.getLevel();
        BlockState state = level.m_8055_(pos = event.getPos());
        if (state.m_60819_().m_76178_()) {
            return;
        }
        boolean isTurpentine = state.m_60819_().m_192917_((Fluid)PropulsionFluids.TURPENTINE.get());
        boolean bl = isLava = state.m_60819_().m_192917_((Fluid)Fluids.f_76195_) || state.m_60819_().m_192917_((Fluid)Fluids.f_76194_);
        if (!isTurpentine && !isLava) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(dir);
            FluidState neighborFluid = level.m_6425_(neighborPos);
            if (isTurpentine && (neighborFluid.m_192917_((Fluid)Fluids.f_76195_) || neighborFluid.m_192917_((Fluid)Fluids.f_76194_))) {
                level.m_7731_(pos, Blocks.f_50069_.m_49966_(), 3);
                return;
            }
            if (!isLava || !neighborFluid.m_192917_((Fluid)PropulsionFluids.TURPENTINE.get())) continue;
            level.m_7731_(neighborPos, Blocks.f_50069_.m_49966_(), 3);
            return;
        }
    }
}

