/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.lodestone_tracker;

import com.deltasf.createpropulsion.compat.PropulsionCompatibility;
import com.deltasf.createpropulsion.compat.computercraft.ComputerBehaviour;
import com.deltasf.createpropulsion.utility.MathUtility;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniondc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4i;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class LodestoneTrackerBlockEntity
extends SmartBlockEntity {
    private static final float ANGLE_TOLERANCE = 5.625f;
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    private int POWER_NORTH = 0;
    private int POWER_EAST = 0;
    private int POWER_SOUTH = 0;
    private int POWER_WEST = 0;
    private boolean isInverted = false;
    private int currentTick = 0;
    private float targetAngle;
    private float previousAngle;
    private Vector4i redstoneOutputs = new Vector4i();
    public boolean isOutputDirty = false;
    private Direction compassFacing = Direction.NORTH;
    public AbstractComputerBehaviour computerBehaviour;

    public int powerNorth() {
        return this.POWER_NORTH;
    }

    public int powerEast() {
        return this.POWER_EAST;
    }

    public int powerSouth() {
        return this.POWER_SOUTH;
    }

    public int powerWest() {
        return this.POWER_WEST;
    }

    public boolean IsInverted() {
        return this.isInverted;
    }

    public LodestoneTrackerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public float getAngle() {
        return this.targetAngle;
    }

    public Direction getCompassFacing() {
        return this.compassFacing;
    }

    public void tick() {
        super.tick();
        ++this.currentTick;
        if (!this.getCompass().m_41619_()) {
            this.targetAngle = this.getAngleFromCompass(this.getCompass());
        }
        this.updateRedstoneOutput(this.targetAngle);
    }

    public float getAngleFromCompass(ItemStack compass) {
        GlobalPos targetBlockPosition;
        boolean targetLodestone = CompassItem.m_40736_((ItemStack)compass);
        if (targetLodestone) {
            targetBlockPosition = CompassItem.m_220021_((CompoundTag)compass.getShareTag());
            if (targetBlockPosition == null) {
                return this.getConfusedAngle();
            }
        } else {
            targetBlockPosition = CompassItem.m_220019_((Level)this.m_58904_());
        }
        if (targetBlockPosition == null) {
            return this.getConfusedAngle();
        }
        BlockPos targetBlock = targetBlockPosition.m_122646_();
        Vector3d targetPosition = this.getWorldSpacePosition(targetBlock);
        Vector3d trackerPosition = this.getWorldSpacePosition(this.f_58858_);
        if (targetPosition == null || trackerPosition == null) {
            return 0.0f;
        }
        float angle = LodestoneTrackerBlockEntity.getHorizontalAndVerticalAngles((Vector3d)targetPosition, (Vector3d)trackerPosition).x;
        boolean trackerInShipyard = VSGameUtilsKt.isBlockInShipyard((Level)this.f_58857_, (BlockPos)this.f_58858_);
        if (trackerInShipyard) {
            Ship targetShip = VSGameUtilsKt.getShipManagingPos((Level)this.f_58857_, (BlockPos)this.f_58858_);
            Quaterniondc rotation = targetShip.getTransform().getShipToWorldRotation();
            Vector2f rotationHCS = MathUtility.toHorizontalCoordinateSystem(rotation);
            angle -= rotationHCS.x;
            if ((angle %= 360.0f) < 0.0f) {
                angle += 360.0f;
            }
        }
        return angle;
    }

    private float getConfusedAngle() {
        float angle = (float)this.currentTick * 10.0f % 360.0f;
        return angle;
    }

    private void updateRedstoneOutput(float angle) {
        boolean changed;
        if (!this.isOutputDirty && this.isAngleWithinTolerance(this.previousAngle, angle, 5.625f)) {
            return;
        }
        this.isOutputDirty = false;
        this.previousAngle = this.targetAngle;
        if (this.getCompass().m_41619_()) {
            this.redstoneOutputs.set(0, 0, 0, 0);
        } else {
            this.calculateRedstoneOutput(angle);
        }
        int oldNorth = this.POWER_NORTH;
        int oldEast = this.POWER_EAST;
        int oldSouth = this.POWER_SOUTH;
        int oldWest = this.POWER_WEST;
        this.POWER_NORTH = this.redstoneOutputs.x;
        this.POWER_EAST = this.redstoneOutputs.y;
        this.POWER_SOUTH = this.redstoneOutputs.z;
        this.POWER_WEST = this.redstoneOutputs.w;
        boolean bl = changed = oldNorth != this.POWER_NORTH || oldEast != this.POWER_EAST || oldSouth != this.POWER_SOUTH || oldWest != this.POWER_WEST;
        if (changed) {
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private boolean isAngleWithinTolerance(float value, float target, float tolerance) {
        return target > value - tolerance && target < value + tolerance;
    }

    public void calculateRedstoneOutput(float angle) {
        float fPowerW;
        int intPowerW;
        float fPowerS;
        int intPowerS;
        float fPowerE;
        int intPowerE;
        float weightW;
        float weightS;
        float weightE;
        float sumWeights;
        float angleRad = (float)Math.toRadians(angle);
        float cosA = (float)Math.cos(angleRad);
        float sinA = (float)Math.sin(angleRad);
        float weightN = Math.max(0.0f, cosA);
        float fPowerN = weightN / (sumWeights = weightN + (weightE = Math.max(0.0f, sinA)) + (weightS = Math.max(0.0f, -cosA)) + (weightW = Math.max(0.0f, -sinA))) * 15.0f;
        int intPowerN = (int)fPowerN;
        int currentSumInt = intPowerN + (intPowerE = (int)(fPowerE = weightE / sumWeights * 15.0f)) + (intPowerS = (int)(fPowerS = weightS / sumWeights * 15.0f)) + (intPowerW = (int)(fPowerW = weightW / sumWeights * 15.0f));
        int remainderToDistribute = 15 - currentSumInt;
        if (remainderToDistribute > 0) {
            float fracN = fPowerN - (float)intPowerN;
            float fracE = fPowerE - (float)intPowerE;
            float fracS = fPowerS - (float)intPowerS;
            float fracW = fPowerW - (float)intPowerW;
            for (int k = 0; k < remainderToDistribute; ++k) {
                float maxFrac = -1.0f;
                int bestDir = -1;
                if (fracN > maxFrac) {
                    maxFrac = fracN;
                    bestDir = 0;
                }
                if (fracE > maxFrac) {
                    maxFrac = fracE;
                    bestDir = 1;
                }
                if (fracS > maxFrac) {
                    maxFrac = fracS;
                    bestDir = 2;
                }
                if (fracW > maxFrac) {
                    maxFrac = fracW;
                    bestDir = 3;
                }
                if (bestDir == 0) {
                    ++intPowerN;
                    fracN = -2.0f;
                    continue;
                }
                if (bestDir == 1) {
                    ++intPowerE;
                    fracE = -2.0f;
                    continue;
                }
                if (bestDir == 2) {
                    ++intPowerS;
                    fracS = -2.0f;
                    continue;
                }
                if (bestDir != 3) break;
                ++intPowerW;
                fracW = -2.0f;
            }
        }
        this.redstoneOutputs.set(intPowerN, intPowerE, intPowerS, intPowerW);
    }

    public void toggleInverted() {
        boolean bl = this.isInverted = !this.isInverted;
        if (this.f_58857_ != null) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        this.notifyUpdate();
    }

    private static Vector2f getHorizontalAndVerticalAngles(Vector3d targetPosition, Vector3d trackerPosition) {
        Vector3d direction = new Vector3d();
        targetPosition.sub((Vector3dc)trackerPosition, direction);
        if (direction.lengthSquared() == 0.0) {
            return new Vector2f(0.0f, 0.0f);
        }
        double horizontalDistance = Math.sqrt(direction.x * direction.x + direction.z * direction.z);
        float horizontalAngle = horizontalDistance == 0.0 ? 0.0f : (float)Math.toDegrees(Math.atan2(direction.x, -direction.z));
        float verticalAngle = (float)Math.toDegrees(Math.atan2(direction.y, horizontalDistance));
        return new Vector2f(horizontalAngle, verticalAngle);
    }

    private Vector3d getWorldSpacePosition(BlockPos pos) {
        Vector3d position;
        boolean blockInShipyard = VSGameUtilsKt.isBlockInShipyard((Level)this.f_58857_, (BlockPos)pos);
        if (blockInShipyard) {
            Ship targetShip = VSGameUtilsKt.getShipManagingPos((Level)this.f_58857_, (BlockPos)pos);
            Vec3 blockCenter = pos.m_252807_();
            if (targetShip == null) {
                return null;
            }
            position = VSGameUtilsKt.toWorldCoordinates((Ship)targetShip, (double)blockCenter.f_82479_, (double)blockCenter.f_82480_, (double)blockCenter.f_82481_);
        } else {
            Vec3 blockCenter = pos.m_252807_();
            position = new Vector3d(blockCenter.f_82479_, blockCenter.f_82480_, blockCenter.f_82481_);
        }
        return position;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (PropulsionCompatibility.CC_ACTIVE) {
            this.computerBehaviour = new ComputerBehaviour(this);
            behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        }
    }

    public ItemStack getCompass() {
        return this.itemHandler.getStackInSlot(0);
    }

    public boolean hasCompass() {
        return !this.getCompass().m_41619_();
    }

    public void setCompass(ItemStack item, Direction compassDirection) {
        this.itemHandler.setStackInSlot(0, item);
        this.compassFacing = !item.m_41619_() ? compassDirection : Direction.NORTH;
        this.notifyUpdate();
    }

    public ItemStack removeCompass() {
        ItemStack extracted = this.getCompass().m_41777_();
        this.setCompass(ItemStack.f_41583_, Direction.NORTH);
        return extracted;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerCap.cast();
        }
        if (PropulsionCompatibility.CC_ACTIVE && this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCap.invalidate();
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("currentTick", this.currentTick);
        tag.m_128379_("isInverted", this.isInverted);
        tag.m_128359_("compassFacing", this.compassFacing.m_122433_());
        tag.m_128405_("powerNorth", this.POWER_NORTH);
        tag.m_128405_("powerEast", this.POWER_EAST);
        tag.m_128405_("powerSouth", this.POWER_SOUTH);
        tag.m_128405_("powerWest", this.POWER_WEST);
    }

    public void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("CompassItem") && !tag.m_128425_("inventory", 10)) {
            ItemStack oldCompass = ItemStack.m_41712_((CompoundTag)tag.m_128469_("CompassItem"));
            this.itemHandler.setStackInSlot(0, oldCompass);
            this.compassFacing = Direction.NORTH;
        } else {
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
            this.compassFacing = Direction.m_122402_((String)tag.m_128461_("compassFacing"));
        }
        this.currentTick = tag.m_128451_("currentTick");
        this.isInverted = tag.m_128471_("isInverted");
        this.POWER_NORTH = tag.m_128451_("powerNorth");
        this.POWER_EAST = tag.m_128451_("powerEast");
        this.POWER_SOUTH = tag.m_128451_("powerSouth");
        this.POWER_WEST = tag.m_128451_("powerWest");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void notifyUpdate() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() == Items.f_42522_ && super.isItemValid(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                LodestoneTrackerBlockEntity.this.isOutputDirty = true;
                LodestoneTrackerBlockEntity.this.notifyUpdate();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

