/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.magnet;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class MagnetData {
    public final UUID id;
    private boolean pendingRemoval = false;
    private BlockPos pos;
    public long shipId = -1L;
    private Vector3d worldPosition;
    private final Vector3i blockDipoleDir;
    private int power;

    public MagnetData(UUID id, BlockPos pos, long shipId, Vector3i blockDipoleDir, int power) {
        this.id = id;
        this.pos = pos;
        this.shipId = shipId;
        this.blockDipoleDir = blockDipoleDir;
        this.power = power;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public Vector3d getPosition() {
        return this.worldPosition;
    }

    public Vector3i getBlockDipoleDir() {
        return this.blockDipoleDir;
    }

    public int getPower() {
        return this.power;
    }

    public void update(BlockPos newPos, long newShipId, Vector3i newBlockDipoleDir, int newPower) {
        this.pos = newPos;
        this.shipId = newShipId;
        this.blockDipoleDir.set((Vector3ic)newBlockDipoleDir);
        this.power = newPower;
    }

    public void updateWorldPosition(Level level) {
        if (this.shipId == -1L) {
            this.worldPosition = VectorConversionsMCKt.toJOML((Vec3)this.pos.m_252807_());
        } else {
            Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)this.pos);
            if (ship == null) {
                return;
            }
            this.worldPosition = VectorConversionsMCKt.toJOML((Vec3)VSGameUtilsKt.toWorldCoordinates((Ship)ship, (Vec3)this.pos.m_252807_()));
        }
    }

    public void scheduleForRemoval() {
        this.pendingRemoval = true;
    }

    public void cancelRemoval() {
        this.pendingRemoval = false;
    }

    public boolean isPendingRemoval() {
        return this.pendingRemoval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MagnetData that = (MagnetData)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

