/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.magnet;

import com.deltasf.createpropulsion.CreatePropulsion;
import com.deltasf.createpropulsion.debug.DebugRenderer;
import com.deltasf.createpropulsion.magnet.MagnetData;
import com.deltasf.createpropulsion.magnet.MagnetPair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class MagnetLevelRegistry {
    private final ConcurrentHashMap<UUID, MagnetData> magnets = new ConcurrentHashMap();
    private final Long2ObjectOpenHashMap<List<UUID>> spatial = new Long2ObjectOpenHashMap();
    private final Map<UUID, Long> lastChunkKey = new ConcurrentHashMap<UUID, Long>();
    private volatile Map<Long, List<MagnetPair>> shipToPairs = new ConcurrentHashMap<Long, List<MagnetPair>>();
    private final ConcurrentHashMap<Long, List<UUID>> shipMagnets = new ConcurrentHashMap();
    private Level level;

    public MagnetLevelRegistry(Level level) {
        this.level = level;
    }

    public MagnetData getMagnet(UUID id) {
        return this.magnets.get(id);
    }

    public MagnetData getOrCreateMagnet(UUID id, BlockPos pos, long shipId, Vector3i dir, int power) {
        MagnetData data = this.magnets.computeIfAbsent(id, k -> {
            MagnetData newData = new MagnetData(id, pos, shipId, dir, power);
            this.shipMagnets.computeIfAbsent(shipId, sId -> new CopyOnWriteArrayList()).add(id);
            return newData;
        });
        return data;
    }

    public void scheduleRemoval(UUID id) {
        MagnetData data = this.magnets.get(id);
        if (data != null) {
            data.scheduleForRemoval();
        }
    }

    public void updateMagnetPosition(MagnetData data) {
        List oldList;
        data.updateWorldPosition(this.level);
        long newChunkKey = this.positionToPackedChunkPos(data.getPosition());
        Long oldChunkKey = this.lastChunkKey.get(data.id);
        if (oldChunkKey != null && oldChunkKey == newChunkKey) {
            return;
        }
        if (oldChunkKey != null && (oldList = (List)this.spatial.get((Object)oldChunkKey)) != null) {
            oldList.remove(data.id);
        }
        ((List)this.spatial.computeIfAbsent(newChunkKey, k -> new CopyOnWriteArrayList())).add(data.id);
        this.lastChunkKey.put(data.id, newChunkKey);
    }

    public void computePairs() {
        int i;
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (MagnetData data : this.magnets.values()) {
            if (!data.isPendingRemoval()) continue;
            toRemove.add(data.id);
        }
        for (UUID id : toRemove) {
            List<UUID> shipList;
            List list;
            MagnetData removedData = this.magnets.remove(id);
            if (removedData == null) continue;
            Long chunkKey = this.lastChunkKey.remove(id);
            if (chunkKey != null && (list = (List)this.spatial.get((Object)chunkKey)) != null) {
                list.remove(id);
            }
            if (removedData.shipId == -1L || (shipList = this.shipMagnets.get(removedData.shipId)) == null) continue;
            shipList.remove(id);
            if (!shipList.isEmpty()) continue;
            this.shipMagnets.remove(removedData.shipId);
        }
        ArrayList<MagnetData> active = new ArrayList<MagnetData>(this.magnets.values());
        int n = active.size();
        if (CreatePropulsion.debug) {
            for (int i2 = 0; i2 < n; ++i2) {
                MagnetData data = (MagnetData)active.get(i2);
                String identifier = i2 + "_active";
                DebugRenderer.drawBox(identifier, data.getBlockPos().m_252807_(), new Vec3(1.5, 1.5, 1.5), Color.red, 2);
            }
        }
        if (n <= 1) {
            if (!this.shipToPairs.isEmpty()) {
                this.shipToPairs = new ConcurrentHashMap<Long, List<MagnetPair>>();
            }
            return;
        }
        ArrayList<int[]> edges = new ArrayList<int[]>();
        HashMap<MagnetData, Integer> indexMap = new HashMap<MagnetData, Integer>();
        for (i = 0; i < n; ++i) {
            indexMap.put((MagnetData)active.get(i), i);
        }
        for (i = 0; i < n; ++i) {
            MagnetData A = (MagnetData)active.get(i);
            Vector3d posA = A.getPosition();
            for (UUID BUUID : this.retrieveNeighbours(this.level, A)) {
                Vector3d posB;
                int j;
                MagnetData B = this.magnets.get(BUUID);
                Integer jObj = (Integer)indexMap.get(B);
                if (jObj == null || (j = jObj.intValue()) <= i || this.shouldSkip(A, B) || !(posA.distanceSquared((Vector3dc)(posB = B.getPosition())) <= 1024.0)) continue;
                edges.add(new int[]{i, j});
            }
        }
        ConcurrentHashMap<Long, List<MagnetPair>> newShipToPairs = new ConcurrentHashMap<Long, List<MagnetPair>>();
        for (int[] edge : edges) {
            MagnetPair pair;
            MagnetData A = (MagnetData)active.get(edge[0]);
            MagnetData B = (MagnetData)active.get(edge[1]);
            if (A.shipId != -1L) {
                pair = new MagnetPair(A.getBlockPos(), A.getBlockDipoleDir(), A.getPower(), B.shipId, B.getBlockPos(), B.getBlockDipoleDir(), B.getPower());
                newShipToPairs.computeIfAbsent(A.shipId, k -> new CopyOnWriteArrayList()).add(pair);
            }
            if (B.shipId == -1L) continue;
            pair = new MagnetPair(B.getBlockPos(), B.getBlockDipoleDir(), B.getPower(), A.shipId, A.getBlockPos(), A.getBlockDipoleDir(), A.getPower());
            newShipToPairs.computeIfAbsent(B.shipId, k -> new CopyOnWriteArrayList()).add(pair);
        }
        this.shipToPairs = newShipToPairs;
        if (CreatePropulsion.debug) {
            int i3 = 0;
            for (int[] edge : edges) {
                String identifier = ++i3 + "_edge";
                MagnetData A = (MagnetData)active.get(edge[0]);
                MagnetData B = (MagnetData)active.get(edge[1]);
                DebugRenderer.drawElongatedBox(identifier, VectorConversionsMCKt.toMinecraft((Vector3dc)A.getPosition()), VectorConversionsMCKt.toMinecraft((Vector3dc)B.getPosition()), 0.25f, Color.blue, false, 2);
            }
        }
    }

    public List<UUID> retrieveNeighbours(Level level, MagnetData data) {
        Vector3d position = data.getPosition();
        int cx = Mth.m_14107_((double)position.x) >> 4;
        int cz = Mth.m_14107_((double)position.z) >> 4;
        ArrayList<UUID> neighbours = new ArrayList<UUID>(64);
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                long key = this.packChunkPos(cx + dx, cz + dz);
                List list = (List)this.spatial.getOrDefault(key, Collections.emptyList());
                neighbours.addAll(list);
            }
        }
        return neighbours;
    }

    public List<MagnetPair> getPairsForShip(long shipId) {
        List<MagnetPair> internal = this.shipToPairs.get(shipId);
        if (internal == null || internal.isEmpty()) {
            return Collections.emptyList();
        }
        return internal;
    }

    public void removeAllMagnetsForShip(long shipId) {
        List<UUID> magnetsToRemove = this.shipMagnets.get(shipId);
        if (magnetsToRemove != null && !magnetsToRemove.isEmpty()) {
            for (UUID magnetId : new ArrayList<UUID>(magnetsToRemove)) {
                this.scheduleRemoval(magnetId);
            }
            this.shipMagnets.remove(shipId);
        }
    }

    private boolean shouldSkip(MagnetData A, MagnetData B) {
        if (A.shipId == -1L && B.shipId == -1L) {
            return true;
        }
        return A.shipId != -1L && A.shipId == B.shipId;
    }

    public long positionToPackedChunkPos(Vector3d position) {
        return this.packChunkPos(Mth.m_14107_((double)position.x) >> 4, Mth.m_14107_((double)position.z) >> 4);
    }

    public long packChunkPos(int chunkX, int chunkZ) {
        return ((long)chunkX & 0xFFFFFFFFL) << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }
}

