/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.network;

import com.deltasf.createpropulsion.thruster.FluidThrusterProperties;
import com.deltasf.createpropulsion.thruster.ThrusterFuelManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncThrusterFuelsPacket {
    private final Map<ResourceLocation, FluidThrusterProperties> fuelMap;

    public static SyncThrusterFuelsPacket create(Map<Fluid, FluidThrusterProperties> mapToSync) {
        HashMap<ResourceLocation, FluidThrusterProperties> networkSafeMap = new HashMap<ResourceLocation, FluidThrusterProperties>();
        mapToSync.forEach((fluid, props) -> {
            ResourceLocation key = ForgeRegistries.FLUIDS.getKey(fluid);
            if (key != null) {
                networkSafeMap.put(key, (FluidThrusterProperties)props);
            }
        });
        return new SyncThrusterFuelsPacket(networkSafeMap);
    }

    private SyncThrusterFuelsPacket(Map<ResourceLocation, FluidThrusterProperties> fuelMap) {
        this.fuelMap = fuelMap;
    }

    public static SyncThrusterFuelsPacket decode(FriendlyByteBuf buf) {
        Map map = buf.m_236847_(FriendlyByteBuf::m_130281_, FluidThrusterProperties::decode);
        return new SyncThrusterFuelsPacket(map);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236831_(this.fuelMap, FriendlyByteBuf::m_130085_, (b, props) -> props.encode((FriendlyByteBuf)b));
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ThrusterFuelManager.updateClient(this.fuelMap));
        context.setPacketHandled(true);
    }
}

