/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlockEntity;
import com.deltasf.createpropulsion.registries.PropulsionItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntityTicker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractOpticalSensorBlock
extends DirectionalBlock
implements EntityBlock,
IWrenchable,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"redstone_power", (int)0, (int)15);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    protected AbstractOpticalSensorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{POWER});
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{WATERLOGGED});
        super.m_7926_(builder);
    }

    public FluidState m_5888_(@Nonnull BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return (Integer)state.m_61143_((Property)POWER) > 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return new SmartBlockEntityTicker();
        }
        return new SmartBlockEntityTicker();
    }

    protected abstract boolean isInteractionFace(BlockState var1, BlockHitResult var2);

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!this.isInteractionFace(state, hit)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AbstractOpticalSensorBlockEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        AbstractOpticalSensorBlockEntity sensorBE = (AbstractOpticalSensorBlockEntity)be;
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_ && (heldStack.m_204117_(PropulsionItems.OPTICAL_LENS_TAG) || heldStack.m_41619_())) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (heldStack.m_204117_(PropulsionItems.OPTICAL_LENS_TAG)) {
            if (sensorBE.insertLens(heldStack)) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (heldStack.m_41619_()) {
            ItemStack extractedLens = sensorBE.extractLastLens();
            if (!extractedLens.m_41619_()) {
                player.m_150109_().m_150079_(extractedLens);
                return InteractionResult.SUCCESS;
            }
        } else {
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(@Nonnull BlockState state, @Nonnull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public abstract BlockEntity m_142194_(@Nonnull BlockPos var1, @Nonnull BlockState var2);

    public abstract BlockState m_5573_(@Nonnull BlockPlaceContext var1);

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof AbstractOpticalSensorBlockEntity) {
                AbstractOpticalSensorBlockEntity sensorBlockEntity = (AbstractOpticalSensorBlockEntity)be;
                for (ItemStack lens : sensorBlockEntity.getLenses()) {
                    if (lens.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)lens);
                }
            }
            level.m_46747_(pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected abstract VoxelShaper getShapeMap();

    public VoxelShape m_5940_(@Nullable BlockState pState, @Nullable BlockGetter pLevel, @Nullable BlockPos pPos, @Nullable CollisionContext pContext) {
        if (pState == null) {
            return this.getShapeMap().get(Direction.NORTH);
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        if (direction == Direction.UP || direction == Direction.DOWN) {
            direction = direction.m_122424_();
        }
        return this.getShapeMap().get(direction);
    }

    public abstract int m_6378_(@Nonnull BlockState var1, @Nonnull BlockGetter var2, @Nonnull BlockPos var3, @Nonnull Direction var4);

    public abstract int m_6376_(@Nonnull BlockState var1, @Nonnull BlockGetter var2, @Nonnull BlockPos var3, @Nonnull Direction var4);

    public abstract boolean canConnectRedstone(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4);
}

