/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.compat.PropulsionCompatibility;
import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlock;
import com.deltasf.createpropulsion.optical_sensors.InlineOpticalSensorBlockEntity;
import com.deltasf.createpropulsion.registries.PropulsionBlockEntities;
import com.deltasf.createpropulsion.registries.PropulsionShapes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class InlineOpticalSensorBlock
extends AbstractOpticalSensorBlock {
    public static final TagKey<Item> CBC_PROJECTILE_ITEM_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("createbigcannons", "big_cannon_projectiles"));
    private static Set<Block> validCbcSupportBlocks = null;
    private static final Object initLock = new Object();

    public InlineOpticalSensorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new InlineOpticalSensorBlockEntity((BlockEntityType)PropulsionBlockEntities.INLINE_OPTICAL_SENSOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWaterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    @Override
    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            level.m_46672_(pos, state.m_60734_());
            level.m_46672_(pos.m_121945_(facing.m_122424_()), state.m_60734_());
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Override
    protected VoxelShaper getShapeMap() {
        return PropulsionShapes.INLINE_OPTICAL_SENSOR;
    }

    @Override
    protected boolean isInteractionFace(BlockState state, BlockHitResult hit) {
        return hit.m_82434_() != ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    @Override
    public int m_6378_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        int power = (Integer)blockState.m_61143_((Property)POWER);
        return blockState.m_61143_((Property)FACING) == side ? power : 0;
    }

    @Override
    public int m_6376_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        int power = (Integer)blockState.m_61143_((Property)POWER);
        return blockState.m_61143_((Property)FACING) == side ? power : 0;
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side == state.m_61143_((Property)FACING);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (level.f_46443_) {
            return;
        }
        Direction blockFacing = (Direction)state.m_61143_((Property)FACING);
        if (fromPos.equals((Object)pos.m_121945_(blockFacing.m_122424_())) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return;
        }
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        Set<Block> projectileBlocks;
        boolean isOnProjectile;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos supportPos = pos.m_121945_(facing.m_122424_());
        BlockState supportState = level.m_8055_(supportPos);
        boolean faceIsSturdy = supportState.m_60783_((BlockGetter)level, supportPos, facing);
        if (faceIsSturdy) {
            return true;
        }
        if (PropulsionCompatibility.CBC_ACTIVE && (isOnProjectile = (projectileBlocks = InlineOpticalSensorBlock.getOrCreateProjectileBlocks()).contains(supportState.m_60734_())) && supportState.m_61138_((Property)DirectionalBlock.f_52588_)) {
            Direction projectileDirection = (Direction)supportState.m_61143_((Property)DirectionalBlock.f_52588_);
            return projectileDirection == facing || projectileDirection.m_122424_() == facing;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Block> getOrCreateProjectileBlocks() {
        if (validCbcSupportBlocks == null) {
            Object object = initLock;
            synchronized (object) {
                if (validCbcSupportBlocks == null) {
                    if (!PropulsionCompatibility.CBC_ACTIVE) {
                        validCbcSupportBlocks = Collections.emptySet();
                    } else {
                        HashSet<Block> tempSet = new HashSet<Block>();
                        Optional tagOptional = BuiltInRegistries.f_257033_.m_203431_(CBC_PROJECTILE_ITEM_TAG);
                        if (tagOptional.isPresent()) {
                            HolderSet.Named itemHolders = (HolderSet.Named)tagOptional.get();
                            for (Holder itemHolder : itemHolders) {
                                Item item = (Item)itemHolder.m_203334_();
                                Block block = Block.m_49814_((Item)item);
                                if (block == Blocks.f_50016_) continue;
                                tempSet.add(block);
                            }
                        }
                        validCbcSupportBlocks = Collections.unmodifiableSet(tempSet);
                    }
                }
            }
        }
        return validCbcSupportBlocks;
    }
}

