/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.compat.PropulsionCompatibility;
import com.deltasf.createpropulsion.compat.computercraft.ComputerBehaviour;
import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlock;
import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlockEntity;
import com.deltasf.createpropulsion.optical_sensors.optical_sensor.OpticalSensorDistanceScrollBehaviour;
import com.deltasf.createpropulsion.optical_sensors.optical_sensor.OpticalSensorFilterValueBox;
import com.deltasf.createpropulsion.registries.PropulsionItems;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class OpticalSensorBlockEntity
extends AbstractOpticalSensorBlockEntity {
    private static final int LENS_LIMIT = 2;
    private FilteringBehaviour filtering;
    private boolean wasFocused;
    private boolean wasUnfocused;
    public ScrollValueBehaviour targetDistance;
    public AbstractComputerBehaviour computerBehaviour;

    public OpticalSensorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new OpticalSensorFilterValueBox(true));
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.targetDistance = new OpticalSensorDistanceScrollBehaviour(this).between(1, (Integer)PropulsionConfig.OPTICAL_SENSOR_MAX_DISTANCE.get() * 2);
        behaviours.add((BlockEntityBehaviour)this.targetDistance);
        this.targetDistance.setValue(32);
        if (PropulsionCompatibility.CC_ACTIVE) {
            this.computerBehaviour = new ComputerBehaviour(this);
            behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (PropulsionCompatibility.CC_ACTIVE && this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public float getZAxisOffset() {
        return 0.625f;
    }

    @Override
    public int getLensLimit() {
        return 2;
    }

    public void setMaxDistance(int distance) {
        this.targetDistance.setValue(distance);
    }

    public int getMaxPossibleRaycastDistance() {
        boolean isFocused = this.hasLens((Item)PropulsionItems.FOCUS_LENS.get());
        boolean isUnfocused = this.hasLens((Item)PropulsionItems.UNFINISHED_LENS.get());
        int maxDistance = (int)Math.floor((float)((Integer)PropulsionConfig.OPTICAL_SENSOR_MAX_DISTANCE.get() * (isFocused ? 2 : 1)) * (isUnfocused ? 0.5f : 1.0f));
        return maxDistance;
    }

    @Override
    protected float getMaxRaycastDistance() {
        boolean isFocused = this.hasLens((Item)PropulsionItems.FOCUS_LENS.get());
        boolean isUnfocused = this.hasLens((Item)PropulsionItems.UNFINISHED_LENS.get());
        if (isFocused != this.wasFocused || isUnfocused != this.wasUnfocused) {
            if (isFocused != this.wasFocused) {
                this.wasFocused = isFocused;
            }
            if (isUnfocused != this.wasUnfocused) {
                this.wasUnfocused = isUnfocused;
            }
            int maxDistance = (int)Math.floor((float)((Integer)PropulsionConfig.OPTICAL_SENSOR_MAX_DISTANCE.get() * (isFocused ? 2 : 1)) * (isUnfocused ? 0.5f : 1.0f));
            int clampedValue = Math.min(this.targetDistance.value, maxDistance);
            this.targetDistance.setValue(clampedValue);
        }
        return this.targetDistance.getValue();
    }

    @Override
    protected void updateRedstoneSignal(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos, int rawNewPower, @Nullable BlockPos hitBlockPos) {
        int oldPower;
        int finalPower = rawNewPower;
        if (hitBlockPos == null || !this.filterTestBlock(level, hitBlockPos)) {
            finalPower = 0;
        }
        if ((oldPower = ((Integer)state.m_61143_((Property)AbstractOpticalSensorBlock.POWER)).intValue()) != finalPower) {
            BlockState updatedState = (BlockState)((BlockState)state.m_61124_((Property)AbstractOpticalSensorBlock.POWER, (Comparable)Integer.valueOf(finalPower))).m_61124_((Property)AbstractOpticalSensorBlock.POWERED, (Comparable)Boolean.valueOf(finalPower > 0));
            level.m_7731_(pos, updatedState, 3);
            Direction facingDir = (Direction)state.m_61143_((Property)AbstractOpticalSensorBlock.FACING);
            level.m_46672_(pos.m_121945_(facingDir.m_122424_()), state.m_60734_());
            level.m_46672_(pos, state.m_60734_());
        }
    }

    private boolean filterTestBlock(Level level, BlockPos posToTest) {
        ItemStack filterStack = this.filtering.getFilter();
        if (filterStack.m_41619_()) {
            return true;
        }
        Block block = level.m_8055_(posToTest).m_60734_();
        ItemStack blockAsStack = new ItemStack((ItemLike)block.m_5456_());
        if (blockAsStack.m_41619_()) {
            return false;
        }
        return this.filtering.test(blockAsStack);
    }
}

