/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.optical_sensors.rendering;

import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlock;
import com.deltasf.createpropulsion.optical_sensors.AbstractOpticalSensorBlockEntity;
import com.deltasf.createpropulsion.optical_sensors.rendering.BeamRenderData;
import com.deltasf.createpropulsion.optical_sensors.rendering.OpticalSensorBeamRenderType;
import com.deltasf.createpropulsion.registries.PropulsionBlockEntities;
import com.deltasf.createpropulsion.registries.PropulsionItems;
import com.deltasf.createpropulsion.utility.TranslucentBeamRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class OpticalSensorRenderer
extends SafeBlockEntityRenderer<AbstractOpticalSensorBlockEntity> {
    private static final float RAY_THICKNESS = 0.25f;
    private static final float START_ALPHA = 0.3f;
    private static final float END_ALPHA = 0.0f;
    private static final Vector4f RAY_COLOR = new Vector4f(0.8f, 0.1f, 0.1f, 1.0f);
    private static final Vector4f RAY_POWERED_COLOR = new Vector4f(0.1f, 0.8f, 0.1f, 1.0f);
    private static final Vector4f START_COLOR = new Vector4f(RAY_COLOR.x(), RAY_COLOR.y(), RAY_COLOR.z(), RAY_COLOR.w() * 0.3f);
    private static final Vector4f START_POWERED_COLOR = new Vector4f(RAY_POWERED_COLOR.x(), RAY_POWERED_COLOR.y(), RAY_POWERED_COLOR.z(), RAY_POWERED_COLOR.w() * 0.3f);
    private static final Vector4f END_COLOR = new Vector4f(RAY_COLOR.x(), RAY_COLOR.y(), RAY_COLOR.z(), RAY_COLOR.w() * 0.0f);
    private static final Vector4f END_POWERED_COLOR = new Vector4f(RAY_POWERED_COLOR.x(), RAY_POWERED_COLOR.y(), RAY_POWERED_COLOR.z(), RAY_POWERED_COLOR.w() * 0.0f);
    private static final Vector3f MODIFIED_TEMP_COLOR = new Vector3f();
    private static final Vector4f MODIFIED_START_COLOR = new Vector4f();
    private static final Vector4f MODIFIED_END_COLOR = new Vector4f();
    private final Vector3f localStartPos = new Vector3f();
    private final Vector3f directionVec = new Vector3f();
    private final Vector3f localEndPos = new Vector3f();
    private final Vector3f worldUp = new Vector3f();
    private final Vector3f sideVector = new Vector3f();
    private final Vector3f upVector = new Vector3f();
    private final Vector3f offset_BL = new Vector3f();
    private final Vector3f offset_BR = new Vector3f();
    private final Vector3f offset_TR = new Vector3f();
    private final Vector3f offset_TL = new Vector3f();
    private static final float HALF_THICKNESS = 0.125f;
    private final Vector3d worldStart = new Vector3d();
    private final Vector3d worldEnd = new Vector3d();

    public OpticalSensorRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(AbstractOpticalSensorBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        if (blockEntity.m_58903_() == PropulsionBlockEntities.OPTICAL_SENSOR_BLOCK_ENTITY.get()) {
            FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)blockEntity, (float)partialTicks, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)light, (int)overlay);
        }
        if (blockEntity.hasLens((Item)PropulsionItems.INVISIBILITY_LENS.get())) {
            return;
        }
        BeamRenderData beamData = blockEntity.getClientBeamRenderData();
        float distance = blockEntity.getRaycastDistance();
        if (distance <= 1.0E-6f) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        boolean powered = (Boolean)state.m_61143_((Property)AbstractOpticalSensorBlock.POWERED);
        this.directionVec.set((float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_());
        this.localStartPos.set((Vector3fc)this.directionVec);
        this.localStartPos.mul(blockEntity.getZAxisOffset());
        this.localStartPos.add(0.5f, 0.5f, 0.5f);
        this.directionVec.mul(distance, this.localEndPos);
        this.localEndPos.add((Vector3fc)this.localStartPos);
        this.worldUp.set(0.0f, 1.0f, 0.0f);
        if (Math.abs(this.directionVec.dot((Vector3fc)this.worldUp)) > 0.99f) {
            this.worldUp.set(1.0f, 0.0f, 0.0f);
        }
        this.directionVec.cross((Vector3fc)this.worldUp, this.sideVector).normalize();
        this.directionVec.cross((Vector3fc)this.sideVector, this.upVector).normalize();
        this.sideVector.mul(0.125f);
        this.upVector.mul(0.125f);
        this.offset_BL.set((Vector3fc)this.sideVector).negate().sub((Vector3fc)this.upVector);
        this.offset_BR.set((Vector3fc)this.sideVector).sub((Vector3fc)this.upVector);
        this.offset_TR.set((Vector3fc)this.sideVector).add((Vector3fc)this.upVector);
        this.offset_TL.set((Vector3fc)this.sideVector).negate().add((Vector3fc)this.upVector);
        this.localStartPos.add((Vector3fc)this.offset_BL, beamData.sBottomLeft);
        this.localStartPos.add((Vector3fc)this.offset_BR, beamData.sBottomRight);
        this.localStartPos.add((Vector3fc)this.offset_TR, beamData.sTopRight);
        this.localStartPos.add((Vector3fc)this.offset_TL, beamData.sTopLeft);
        this.localEndPos.add((Vector3fc)this.offset_BL, beamData.eBottomLeft);
        this.localEndPos.add((Vector3fc)this.offset_BR, beamData.eBottomRight);
        this.localEndPos.add((Vector3fc)this.offset_TR, beamData.eTopRight);
        this.localEndPos.add((Vector3fc)this.offset_TL, beamData.eTopLeft);
        beamData.normalBottom.set((Vector3fc)this.upVector);
        beamData.normalRight.set((Vector3fc)this.sideVector).negate();
        beamData.normalTop.set((Vector3fc)this.upVector).negate();
        beamData.normalLeft.set((Vector3fc)this.sideVector);
        if (!powered && blockEntity.hasLens((Item)PropulsionItems.OPTICAL_LENS.get())) {
            if (this.calculateFinalColor(blockEntity.getLenses())) {
                MODIFIED_START_COLOR.set((Vector3fc)MODIFIED_TEMP_COLOR, 0.3f);
                MODIFIED_END_COLOR.set((Vector3fc)MODIFIED_TEMP_COLOR, 0.0f);
                this.setBeamColors(beamData, MODIFIED_START_COLOR, MODIFIED_END_COLOR);
            } else {
                this.setBeamColors(beamData, powered);
            }
        } else {
            this.setBeamColors(beamData, powered);
        }
        beamData.worldToLocalTransform.set((Matrix4fc)poseStack.m_85850_().m_252922_()).invert();
        beamData.poseSnapshot = poseStack.m_85850_();
        poseStack.m_85836_();
        VertexConsumer buffer = bufferSource.m_6299_(OpticalSensorBeamRenderType.SOLID_TRANSLUCENT_BEAM);
        TranslucentBeamRenderer.drawBeam(buffer, beamData);
        poseStack.m_85849_();
        TranslucentBeamRenderer.scheduleBeamRender(beamData);
    }

    public boolean shouldRender(@Nonnull AbstractOpticalSensorBlockEntity blockEntity, @Nonnull Vec3 cameraPos) {
        BlockPos pos;
        AABB blockAABB;
        if (!super.m_142756_((BlockEntity)blockEntity, cameraPos)) {
            return false;
        }
        Frustum frustum = Minecraft.m_91087_().f_91060_.getFrustum();
        if (frustum.m_113029_(blockAABB = new AABB(pos = blockEntity.m_58899_()).m_82400_(0.125))) {
            return true;
        }
        AABB beamAABB = this.calculateBeamAABB(blockEntity);
        if (beamAABB == null) {
            return false;
        }
        return frustum == null || frustum.m_113029_(beamAABB);
    }

    public boolean shouldRenderOffScreen(@Nonnull AbstractOpticalSensorBlockEntity pBlockEntity) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }

    private void setBeamColors(BeamRenderData beamData, Vector4f startColor, Vector4f endColor) {
        beamData.startColor.set((Vector4fc)startColor);
        beamData.endColor.set((Vector4fc)endColor);
    }

    private void setBeamColors(BeamRenderData beamData, boolean powered) {
        beamData.startColor.set((Vector4fc)(powered ? START_POWERED_COLOR : START_COLOR));
        beamData.endColor.set((Vector4fc)(powered ? END_POWERED_COLOR : END_COLOR));
    }

    private AABB calculateBeamAABB(AbstractOpticalSensorBlockEntity blockEntity) {
        float distance = blockEntity.getRaycastDistance();
        if (distance <= 1.0E-6f) {
            return null;
        }
        BlockPos blockPos = blockEntity.m_58899_();
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        this.directionVec.set((float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_());
        this.localStartPos.set((Vector3fc)this.directionVec).mul(blockEntity.getZAxisOffset()).add(0.5f, 0.5f, 0.5f);
        this.worldStart.set((double)((float)blockPos.m_123341_() + this.localStartPos.x()), (double)((float)blockPos.m_123342_() + this.localStartPos.y()), (double)((float)blockPos.m_123343_() + this.localStartPos.z()));
        this.worldEnd.set((Vector3dc)this.worldStart).add((double)(this.directionVec.x * distance), (double)(this.directionVec.y * distance), (double)(this.directionVec.z * distance));
        double minX = Math.min(this.worldStart.x, this.worldEnd.x);
        double minY = Math.min(this.worldStart.y, this.worldEnd.y);
        double minZ = Math.min(this.worldStart.z, this.worldEnd.z);
        double maxX = Math.max(this.worldStart.x, this.worldEnd.x);
        double maxY = Math.max(this.worldStart.y, this.worldEnd.y);
        double maxZ = Math.max(this.worldStart.z, this.worldEnd.z);
        double expansion = 0.125;
        return new AABB(minX -= expansion, minY -= expansion, minZ -= expansion, maxX += expansion, maxY += expansion, maxZ += expansion);
    }

    private boolean calculateFinalColor(NonNullList<ItemStack> lenses) {
        float totalRed = 0.0f;
        float totalGreen = 0.0f;
        float totalBlue = 0.0f;
        int dyedLensCount = 0;
        Item opticalLensItem = (Item)PropulsionItems.OPTICAL_LENS.get();
        for (ItemStack stack : lenses) {
            DyeableLeatherItem dyeableItem;
            Item item;
            if (!stack.m_150930_(opticalLensItem) || !((item = stack.m_41720_()) instanceof DyeableLeatherItem) || !(dyeableItem = (DyeableLeatherItem)item).m_41113_(stack)) continue;
            int color = dyeableItem.m_41121_(stack);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            totalRed += (float)r;
            totalGreen += (float)g;
            totalBlue += (float)b;
            ++dyedLensCount;
        }
        if (dyedLensCount == 0) {
            return false;
        }
        float avgRed = totalRed / (float)dyedLensCount;
        float avgGreen = totalGreen / (float)dyedLensCount;
        float avgBlue = totalBlue / (float)dyedLensCount;
        MODIFIED_TEMP_COLOR.set(avgRed / 255.0f, avgGreen / 255.0f, avgBlue / 255.0f);
        return true;
    }
}

