/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.physics_assembler;

import com.deltasf.createpropulsion.physics_assembler.AssemblyGaugeItem;
import com.deltasf.createpropulsion.physics_assembler.AssemblyUtility;
import com.simibubi.create.AllSpecialTextures;
import java.util.Objects;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class AssemblyGaugeOverlayRenderer {
    public static final IGuiOverlay OVERLAY = AssemblyGaugeOverlayRenderer::renderOverlay;
    private static final double FLASH_ANIMATION_DURATION_S = 0.3;
    private static final double FLASH_HOLD_DURATION_S = 2.0;
    private static final double FLASH_TOTAL_DURATION_S = 2.3;
    private static AABB lastSelectionAABB;
    private static BlockPos lastPosA;
    private static double flashStartGameTime;
    private static boolean flashQueued;
    private static Ship lastHoveredShip;

    public static void triggerFlash(AABB selection) {
        flashQueued = true;
        lastSelectionAABB = selection;
    }

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91074_ == null || mc.f_91073_ == null || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        ItemStack stack = player.m_21205_();
        if (!AssemblyUtility.isAssemblyGauge(stack)) {
            flashStartGameTime = 0.0;
            lastHoveredShip = null;
            return;
        }
        double currentTimeInSeconds = (double)((float)mc.f_91073_.m_46467_() + partialTicks) / 20.0;
        if (flashQueued) {
            flashStartGameTime = currentTimeInSeconds;
            flashQueued = false;
        }
        if (flashStartGameTime > 0.0 && currentTimeInSeconds - flashStartGameTime > 2.3) {
            flashStartGameTime = 0.0;
        }
        BlockPos posA = AssemblyGaugeItem.getPosA(stack);
        BlockPos posB = AssemblyGaugeItem.getPosB(stack);
        HitResult result = mc.f_91077_;
        BlockPos lookingAtPos = null;
        if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            lookingAtPos = AssemblyUtility.getTargetedPosition(blockHitResult.m_82425_(), blockHitResult.m_82434_(), (Player)player);
        }
        if (posA == null) {
            if (lookingAtPos == null) {
                lastHoveredShip = null;
                Outliner.getInstance().remove((Object)"gauge_preview");
                return;
            }
            Ship currentShip = VSGameUtilsKt.getShipManagingPos((Level)mc.f_91073_, lookingAtPos);
            boolean gridChanged = !Objects.equals(currentShip, lastHoveredShip);
            lastHoveredShip = currentShip;
            if (gridChanged) {
                Outliner.getInstance().remove((Object)"gauge_preview");
                return;
            }
            AABB previewBox = new AABB(lookingAtPos);
            Outline.OutlineParams parameters = Outliner.getInstance().getOutlines().containsKey("gauge_preview") ? Outliner.getInstance().chaseAABB((Object)"gauge_preview", previewBox) : Outliner.getInstance().showAABB((Object)"gauge_preview", previewBox);
            parameters.colored(11495621).lineWidth(0.0625f).disableLineNormals().withFaceTexture((BindableTexture)AllSpecialTextures.SELECTION);
            return;
        }
        boolean selectingSecond = posA != null && posB == null;
        MutableComponent statusText = null;
        boolean isTooLarge = false;
        AABB selectionBox = null;
        if (selectingSecond && lookingAtPos != null) {
            selectionBox = new AABB(posA, lookingAtPos);
            isTooLarge = AssemblyUtility.isAABBLarger(selectionBox, 32);
        }
        if (selectingSecond) {
            if (isTooLarge) {
                statusText = selectionBox != null && AssemblyUtility.isAABBLarger(selectionBox, 1024) ? Component.m_237115_((String)"createpropulsion.gauge.selection.same_structure").m_130938_(s -> s.m_178520_(0xFF5555)) : Component.m_237115_((String)"createpropulsion.gauge.selection.too_big").m_130938_(s -> s.m_178520_(0xFF5555));
            } else if (lastPosA == null) {
                lastPosA = posA;
            } else {
                statusText = Component.m_237115_((String)"createpropulsion.gauge.selection.confirm").m_130938_(s -> s.m_178520_(14325744));
            }
        }
        if (statusText != null) {
            gui.m_93063_(statusText, false);
        }
        AABB currentSelectionBox = null;
        if (posA != null && posB != null) {
            currentSelectionBox = AssemblyUtility.fromBlockVolumes(posA, posB);
        } else if (selectingSecond && lookingAtPos != null) {
            currentSelectionBox = AssemblyUtility.fromBlockVolumes(posA, lookingAtPos);
        }
        if (currentSelectionBox == null) {
            return;
        }
        if (flashStartGameTime > 0.0 && currentSelectionBox.equals((Object)lastSelectionAABB)) {
            int color;
            float flashLineWidth;
            double elapsedTime = currentTimeInSeconds - flashStartGameTime;
            if (elapsedTime < 0.3) {
                float progress = (float)(elapsedTime / 0.3);
                flashLineWidth = Mth.m_14179_((float)progress, (float)0.0625f, (float)0.015625f);
                color = AssemblyUtility.lerpColor(progress, 14325744, 11495621);
            } else {
                flashLineWidth = 0.015625f;
                color = 11495621;
            }
            AssemblyUtility.renderOutline("gauge_flash", lastSelectionAABB, color, flashLineWidth, true);
        } else if (posB != null) {
            boolean isHovering = AssemblyUtility.isPlayerLookingAtAABB((Player)player, currentSelectionBox, partialTicks, 1.0, 0.0);
            float lineWidth = isHovering ? 0.0625f : 0.015625f;
            AssemblyUtility.renderOutline("gauge_selection", currentSelectionBox, 11495621, lineWidth, isHovering);
        } else {
            int color = isTooLarge ? 0xFF5555 : 11495621;
            AssemblyUtility.renderOutline("gauge_selection", currentSelectionBox, color, 0.0625f, true);
        }
    }

    static {
        flashStartGameTime = 0.0;
        flashQueued = false;
    }
}

