/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.physics_assembler;

import com.deltasf.createpropulsion.network.PropulsionPackets;
import com.deltasf.createpropulsion.physics_assembler.AssemblyGaugeItem;
import com.deltasf.createpropulsion.physics_assembler.PhysicsAssemblerBlockEntity;
import com.deltasf.createpropulsion.physics_assembler.packets.GaugeInsertionErrorPacket;
import com.deltasf.createpropulsion.registries.PropulsionBlockEntities;
import com.deltasf.createpropulsion.registries.PropulsionShapes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class PhysicsAssemblerBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");

    public PhysicsAssemblerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new PhysicsAssemblerBlockEntity((BlockEntityType)PropulsionBlockEntities.PHYSICAL_ASSEMBLER_BLOCK_ENTITY.get(), pos, state);
    }

    public VoxelShape m_5940_(@Nullable BlockState pState, @Nullable BlockGetter pLevel, @Nullable BlockPos pPos, @Nullable CollisionContext pContext) {
        return PropulsionShapes.PHYSICS_ASSEMBLER.get(Direction.NORTH);
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND || hit.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof PhysicsAssemblerBlockEntity)) {
            return InteractionResult.PASS;
        }
        PhysicsAssemblerBlockEntity assembler = (PhysicsAssemblerBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        boolean assemblerHasGauge = assembler.hasGauge();
        if (heldItem.m_41720_() instanceof AssemblyGaugeItem && !assemblerHasGauge) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            PhysicsAssemblerBlockEntity.GaugeValidationResult result = assembler.canInsertGauge(heldItem);
            if (result.isValid()) {
                assembler.insertGauge(player, hand);
            } else {
                result.reason().ifPresent(reason -> PropulsionPackets.sendToPlayer(new GaugeInsertionErrorPacket((Component)reason), (ServerPlayer)player));
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41619_() && assemblerHasGauge) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            ItemStack removedGauge = assembler.removeGauge();
            player.m_150109_().m_150079_(removedGauge);
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, isMoving);
            return;
        }
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof PhysicsAssemblerBlockEntity) {
            PhysicsAssemblerBlockEntity assemblerEntity = (PhysicsAssemblerBlockEntity)blockEntity;
            assemblerEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                ItemStack stackInSlot = handler.getStackInSlot(0);
                if (!stackInSlot.m_41619_()) {
                    NonNullList itemsToDrop = NonNullList.m_122780_((int)1, (Object)stackInSlot);
                    Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)itemsToDrop);
                }
            });
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        this.doRedstoneCheck(level, state, pos);
    }

    private void doRedstoneCheck(Level level, BlockState state, BlockPos pos) {
        boolean newPowered;
        boolean oldPowered = (Boolean)state.m_61143_((Property)POWERED);
        boolean bl = newPowered = level.m_277086_(pos) > 0;
        if (oldPowered == newPowered) {
            return;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(newPowered));
        level.m_7731_(pos, newState, 3);
        if (!newPowered) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PhysicsAssemblerBlockEntity) {
            PhysicsAssemblerBlockEntity physicsAssemblerBlockEntity = (PhysicsAssemblerBlockEntity)blockEntity;
            physicsAssemblerBlockEntity.shipify();
        }
    }
}

