/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.physics_assembler;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.compat.PropulsionCompatibility;
import com.deltasf.createpropulsion.compat.computercraft.ComputerBehaviour;
import com.deltasf.createpropulsion.physics_assembler.AssemblyGaugeItem;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.impl.networking.simple.SimplePacket;
import org.valkyrienskies.core.impl.networking.simple.SimplePackets;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.networking.PacketRestartChunkUpdates;
import org.valkyrienskies.mod.common.networking.PacketStopChunkUpdates;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class PhysicsAssemblerBlockEntity
extends SmartBlockEntity {
    private final BlockState AIR = Blocks.f_50016_.m_49966_();
    public AbstractComputerBehaviour computerBehaviour;
    private List<Vector2i> chunkPoses = new ArrayList<Vector2i>();
    private List<Vector2i> destchunkPoses = new ArrayList<Vector2i>();
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);

    public PhysicsAssemblerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void shipify() {
        BlockPos shipPos;
        BlockPos relative;
        Level world = this.m_58904_();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        ItemStack gaugeStack = this.itemHandler.getStackInSlot(0);
        if (gaugeStack == null) {
            return;
        }
        if (!(gaugeStack.m_41720_() instanceof AssemblyGaugeItem)) {
            return;
        }
        BlockPos posA = AssemblyGaugeItem.getPosA(gaugeStack);
        BlockPos posB = AssemblyGaugeItem.getPosB(gaugeStack);
        if (posA == null || posB == null) {
            return;
        }
        SelectedRegion region = this.getGeometricCenterOfBlocksInRegion((Level)level, posA, posB);
        if (!region.hasBlocks) {
            return;
        }
        ServerShip parentShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)this.f_58858_);
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)level);
        Vector3d gc = region.geometricCenter;
        BlockPos creationAnchorPos = new BlockPos((int)Math.floor(gc.x), (int)Math.floor(gc.y), (int)Math.floor(gc.z));
        ServerShip ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createNewShipAtBlock((Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)creationAnchorPos), false, 1.0, dimensionId);
        ChunkClaim claim = ship.getChunkClaim();
        BlockPos newShipInternalCenterPos = VectorConversionsMCKt.toBlockPos((Vector3ic)claim.getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)level), new Vector3i()));
        this.chunkPoses.clear();
        for (ChunkPos pos : region.chunkPosSet) {
            this.chunkPoses.add(new Vector2i(pos.f_45578_, pos.f_45579_));
        }
        this.destchunkPoses.clear();
        HashSet<ChunkPos> destSet = new HashSet<ChunkPos>();
        for (BlockPos blockPos : region.blockPositions) {
            BlockPos relative2 = blockPos.m_121996_((Vec3i)creationAnchorPos);
            BlockPos shipPos2 = newShipInternalCenterPos.m_121955_((Vec3i)relative2);
            destSet.add(level.m_46865_(shipPos2).m_7697_());
        }
        for (ChunkPos chunkPos : destSet) {
            this.destchunkPoses.add(new Vector2i(chunkPos.f_45578_, chunkPos.f_45579_));
        }
        SimplePackets.sendToAllClients((SimplePacket)new PacketStopChunkUpdates(this.chunkPoses));
        for (BlockPos pos : region.blockPositions) {
            relative = pos.m_121996_((Vec3i)creationAnchorPos);
            shipPos = newShipInternalCenterPos.m_121955_((Vec3i)relative);
            this.copyBlock((Level)level, pos, shipPos);
        }
        for (BlockPos pos : region.blockPositions) {
            this.removeBlock((Level)level, pos);
        }
        for (BlockPos pos : region.blockPositions) {
            relative = pos.m_121996_((Vec3i)creationAnchorPos);
            shipPos = newShipInternalCenterPos.m_121955_((Vec3i)relative);
            this.updateBlock((Level)level, pos, shipPos, level.m_8055_(shipPos));
        }
        Vector3dc vector3dc = ship.getInertiaData().getCenterOfMassInShip();
        Vector3d finalShipPosInShipyard = new Vector3d(vector3dc).add(0.5, 0.5, 0.5);
        Vector3d newShipInternalCenterPosVec = VectorConversionsMCKt.toJOMLD((Vec3i)newShipInternalCenterPos);
        Vector3d creationAnchorPosVec = VectorConversionsMCKt.toJOMLD((Vec3i)creationAnchorPos);
        Vector3d shipComInWorld = new Vector3d(vector3dc).sub((Vector3dc)newShipInternalCenterPosVec).add((Vector3dc)creationAnchorPosVec);
        Vector3d finalShipPosInWorld = shipComInWorld.add(0.5, 0.5, 0.5);
        Quaterniond finalShipRotation = new Quaterniond();
        Vector3d finalShipScale = new Vector3d(1.0, 1.0, 1.0);
        if (parentShip != null) {
            finalShipPosInWorld = parentShip.getShipToWorld().transformPosition((Vector3dc)shipComInWorld, new Vector3d());
            finalShipRotation = parentShip.getTransform().getShipToWorldRotation();
            finalShipScale.mul(parentShip.getTransform().getShipToWorldScaling());
        }
        ShipTransformImpl newShipTransform = new ShipTransformImpl((Vector3dc)finalShipPosInWorld, (Vector3dc)finalShipPosInShipyard, (Quaterniondc)finalShipRotation, (Vector3dc)finalShipScale);
        if (ship instanceof ShipDataCommon) {
            ShipDataCommon shipData = (ShipDataCommon)ship;
            shipData.setTransform((ShipTransform)newShipTransform);
        }
        VSGameUtilsKt.executeIf((MinecraftServer)level.m_7654_(), () -> this.destchunkPoses.stream().allMatch(chunkPos -> VSGameUtilsKt.isTickingChunk((Level)level, (int)chunkPos.x, (int)chunkPos.y)), () -> {
            SimplePackets.sendToAllClients((SimplePacket)new PacketRestartChunkUpdates(this.chunkPoses));
            this.chunkPoses.clear();
        });
    }

    private void copyBlock(Level level, BlockPos from, BlockPos to) {
        BlockState state = level.m_8055_(from);
        BlockEntity blockEntity = level.m_7702_(from);
        level.m_46865_(to).m_6978_(to, state, false);
        if (level.m_183326_().m_183582_(from, (Object)state.m_60734_())) {
            level.m_183326_().m_183393_(new ScheduledTick((Object)state.m_60734_(), to, 0L, 0L));
        }
        if (state.m_155947_() && blockEntity != null) {
            CompoundTag tdata = blockEntity.m_187480_();
            level.m_151523_(BlockEntity.m_155241_((BlockPos)to, (BlockState)state, (CompoundTag)tdata));
        }
    }

    private void removeBlock(Level level, BlockPos pos) {
        level.m_46747_(pos);
        level.m_46865_(pos).m_6978_(pos, this.AIR, false);
    }

    private void updateBlock(Level level, BlockPos from, BlockPos to, BlockState toState) {
        int flags = 107;
        int recursionLeft = 511;
        level.m_6550_(from, toState, this.AIR);
        level.m_7260_(from, toState, this.AIR, flags);
        level.m_6289_(from, this.AIR.m_60734_());
        this.AIR.m_60762_((LevelAccessor)level, from, flags, recursionLeft - 1);
        this.AIR.m_60705_((LevelAccessor)level, from, flags, recursionLeft);
        this.AIR.m_60762_((LevelAccessor)level, from, flags, recursionLeft);
        level.m_7726_().m_7827_().m_7174_(from);
        level.m_6550_(to, this.AIR, toState);
        level.m_7260_(to, this.AIR, toState, flags);
        level.m_6289_(to, toState.m_60734_());
        if (!level.f_46443_ && toState.m_60807_()) {
            level.m_46717_(to, toState.m_60734_());
        }
        level.m_7726_().m_7827_().m_7174_(to);
    }

    private SelectedRegion getGeometricCenterOfBlocksInRegion(Level level, BlockPos posA, BlockPos posB) {
        int minActualX = Integer.MAX_VALUE;
        int minActualY = Integer.MAX_VALUE;
        int minActualZ = Integer.MAX_VALUE;
        int maxActualX = Integer.MIN_VALUE;
        int maxActualY = Integer.MIN_VALUE;
        int maxActualZ = Integer.MIN_VALUE;
        int regionMinX = Math.min(posA.m_123341_(), posB.m_123341_());
        int regionMinY = Math.min(posA.m_123342_(), posB.m_123342_());
        int regionMinZ = Math.min(posA.m_123343_(), posB.m_123343_());
        int regionMaxX = Math.max(posA.m_123341_(), posB.m_123341_());
        int regionMaxY = Math.max(posA.m_123342_(), posB.m_123342_());
        int regionMaxZ = Math.max(posA.m_123343_(), posB.m_123343_());
        boolean blocksFound = false;
        ArrayList<BlockPos> blocksList = new ArrayList<BlockPos>();
        HashSet<ChunkPos> chunkPosSet = new HashSet<ChunkPos>();
        for (int x = regionMinX; x <= regionMaxX; ++x) {
            for (int y = regionMinY; y <= regionMaxY; ++y) {
                for (int z = regionMinZ; z <= regionMaxZ; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockState blockState = level.m_8055_(currentPos);
                    if (blockState.m_60795_()) continue;
                    blocksFound = true;
                    blocksList.add(currentPos);
                    chunkPosSet.add(level.m_46865_(currentPos).m_7697_());
                    minActualX = Math.min(minActualX, x);
                    minActualY = Math.min(minActualY, y);
                    minActualZ = Math.min(minActualZ, z);
                    maxActualX = Math.max(maxActualX, x);
                    maxActualY = Math.max(maxActualY, y);
                    maxActualZ = Math.max(maxActualZ, z);
                }
            }
        }
        double actualCenterX = (double)(minActualX + maxActualX) / 2.0;
        double actualCenterY = (double)(minActualY + maxActualY) / 2.0;
        double actualCenterZ = (double)(minActualZ + maxActualZ) / 2.0;
        return new SelectedRegion(new Vector3d(actualCenterX, actualCenterY, actualCenterZ), blocksFound, blocksList, chunkPosSet);
    }

    public GaugeValidationResult canInsertGauge(ItemStack gauge) {
        BlockPos posA = AssemblyGaugeItem.getPosA(gauge);
        BlockPos posB = AssemblyGaugeItem.getPosB(gauge);
        if (posA == null || posB == null) {
            MutableComponent reason = Component.m_237113_((String)"Gauge is not fully configured").m_130938_(s -> s.m_178520_(0xFF5555));
            return new GaugeValidationResult(false, Optional.of(reason));
        }
        BlockPos selfPos = this.f_58858_;
        int minX = Math.min(posA.m_123341_(), posB.m_123341_());
        int maxX = Math.max(posA.m_123341_(), posB.m_123341_());
        int minY = Math.min(posA.m_123342_(), posB.m_123342_());
        int maxY = Math.max(posA.m_123342_(), posB.m_123342_());
        int minZ = Math.min(posA.m_123343_(), posB.m_123343_());
        int maxZ = Math.max(posA.m_123343_(), posB.m_123343_());
        if (selfPos.m_123341_() >= minX && selfPos.m_123341_() <= maxX && selfPos.m_123342_() >= minY && selfPos.m_123342_() <= maxY && selfPos.m_123343_() >= minZ && selfPos.m_123343_() <= maxZ) {
            MutableComponent reason = Component.m_237115_((String)"createpropulsion.assembler.selection.cannot_be_inside").m_130938_(s -> s.m_178520_(0xFF5555));
            return new GaugeValidationResult(false, Optional.of(reason));
        }
        int manhattanDistance = this.getManhattanDistanceToRegion(this.f_58858_, posA, posB);
        if (manhattanDistance > (Integer)PropulsionConfig.PHYSICS_ASSEMBLER_MAX_MINK_DISTANCE.get()) {
            MutableComponent reason = Component.m_237115_((String)"createpropulsion.assembler.selection.too_far").m_130938_(s -> s.m_178520_(0xFF5555));
            return new GaugeValidationResult(false, Optional.of(reason));
        }
        return new GaugeValidationResult(true, Optional.empty());
    }

    public boolean hasGauge() {
        return !this.itemHandler.getStackInSlot(0).m_41619_();
    }

    public void insertGauge(Player player, InteractionHand hand) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ItemStack gaugeInHand = player.m_21120_(hand);
        if (!(gaugeInHand.m_41720_() instanceof AssemblyGaugeItem) || !this.itemHandler.getStackInSlot(0).m_41619_()) {
            return;
        }
        ItemStack gaugeToInsert = gaugeInHand.m_41777_();
        gaugeToInsert.m_41764_(1);
        this.itemHandler.setStackInSlot(0, gaugeToInsert);
        gaugeInHand.m_41774_(1);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public ItemStack removeGauge() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return ItemStack.f_41583_;
        }
        ItemStack extracted = this.itemHandler.getStackInSlot(0).m_41777_();
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return extracted;
    }

    private int getManhattanDistanceToRegion(BlockPos point, BlockPos corner1, BlockPos corner2) {
        int minX = Math.min(corner1.m_123341_(), corner2.m_123341_());
        int maxX = Math.max(corner1.m_123341_(), corner2.m_123341_());
        int minY = Math.min(corner1.m_123342_(), corner2.m_123342_());
        int maxY = Math.max(corner1.m_123342_(), corner2.m_123342_());
        int minZ = Math.min(corner1.m_123343_(), corner2.m_123343_());
        int maxZ = Math.max(corner1.m_123343_(), corner2.m_123343_());
        int distX = Math.max(0, minX - point.m_123341_()) + Math.max(0, point.m_123341_() - maxX);
        int distY = Math.max(0, minY - point.m_123342_()) + Math.max(0, point.m_123342_() - maxY);
        int distZ = Math.max(0, minZ - point.m_123343_()) + Math.max(0, point.m_123343_() - maxZ);
        return distX + distY + distZ;
    }

    public ItemStack getGaugeStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public float getGaugeRotation() {
        ItemStack gauge = this.getGaugeStack();
        if (gauge.m_41619_()) {
            return 0.0f;
        }
        BlockPos posA = AssemblyGaugeItem.getPosA(gauge);
        BlockPos posB = AssemblyGaugeItem.getPosB(gauge);
        if (posA == null || posB == null) {
            return 0.0f;
        }
        int minX = Math.min(posA.m_123341_(), posB.m_123341_());
        int maxX = Math.max(posA.m_123341_(), posB.m_123341_());
        int minZ = Math.min(posA.m_123343_(), posB.m_123343_());
        int maxZ = Math.max(posA.m_123343_(), posB.m_123343_());
        BlockPos point = this.f_58858_;
        int distX = Math.max(0, minX - point.m_123341_()) + Math.max(0, point.m_123341_() - maxX);
        int distZ = Math.max(0, minZ - point.m_123343_()) + Math.max(0, point.m_123343_() - maxZ);
        if (distZ >= distX) {
            return 0.0f;
        }
        return 90.0f;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        if (PropulsionCompatibility.CC_ACTIVE) {
            this.computerBehaviour = new ComputerBehaviour(this);
            behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128425_("inventory", 10)) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (PropulsionCompatibility.CC_ACTIVE && this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                PhysicsAssemblerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof AssemblyGaugeItem && super.isItemValid(slot, stack);
            }
        };
    }

    private record SelectedRegion(Vector3d geometricCenter, boolean hasBlocks, List<BlockPos> blockPositions, Set<ChunkPos> chunkPosSet) {
    }

    public record GaugeValidationResult(boolean isValid, Optional<Component> reason) {
    }
}

