/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.registries;

import java.util.function.BiFunction;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PropulsionShapes {
    public static final VoxelShaper THRUSTER = ShapeBuilder.shape().add(Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0)).add(Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)14.0)).add(Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0)).forDirectional(Direction.NORTH);
    public static final VoxelShaper INLINE_OPTICAL_SENSOR = ShapeBuilder.shape().add(Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0)).forDirectional(Direction.NORTH);
    public static final VoxelShaper OPTICAL_SENSOR = ShapeBuilder.shape().add(Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0)).add(Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0)).forDirectional(Direction.NORTH);
    public static final VoxelShaper LODESTONE_TRACKER = ShapeBuilder.shape().add(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0)).add(Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0)).add(Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)).forDirectional(Direction.NORTH);
    public static final VoxelShaper PHYSICS_ASSEMBLER = ShapeBuilder.shape().add(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)).add(Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)).forDirectional(Direction.NORTH);
    public static final VoxelShaper WING = PropulsionShapes.getWingShape(4);
    public static final VoxelShaper WING_8 = PropulsionShapes.getWingShape(8);
    public static final VoxelShaper WING_12 = PropulsionShapes.getWingShape(12);

    public static VoxelShaper getWingShape(int width) {
        if (width % 2 != 0) {
            throw new IllegalArgumentException("Humble odd width exception");
        }
        int halfWidth = width / 2;
        return ShapeBuilder.shape().add(Block.m_49796_((double)0.0, (double)(8 - halfWidth), (double)0.0, (double)16.0, (double)(8 + halfWidth), (double)16.0)).forDirectional(Direction.UP);
    }

    public static class ShapeBuilder {
        private VoxelShape shape;

        public static ShapeBuilder shapeBuilder(VoxelShape shape) {
            return new ShapeBuilder(shape);
        }

        public static ShapeBuilder shape() {
            return new ShapeBuilder(Shapes.m_83040_());
        }

        private static VoxelShape cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
            return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }

        public ShapeBuilder(VoxelShape shape) {
            this.shape = shape;
        }

        public ShapeBuilder add(VoxelShape shape) {
            this.shape = Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)shape);
            return this;
        }

        public ShapeBuilder add(double x1, double y1, double z1, double x2, double y2, double z2) {
            return this.add(ShapeBuilder.cuboid(x1, y1, z1, x2, y2, z2));
        }

        public ShapeBuilder erase(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)ShapeBuilder.cuboid(x1, y1, z1, x2, y2, z2), (BooleanOp)BooleanOp.f_82685_);
            return this;
        }

        public VoxelShape build() {
            return this.shape;
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction, VoxelShaper> factory, Direction direction) {
            return factory.apply(this.shape, direction);
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction.Axis, VoxelShaper> factory, Direction.Axis axis) {
            return factory.apply(this.shape, axis);
        }

        public VoxelShaper forDirectional(Direction direction) {
            return this.build(VoxelShaper::forDirectional, direction);
        }

        public VoxelShaper forAxis() {
            return this.build(VoxelShaper::forAxis, Direction.Axis.Y);
        }

        public VoxelShaper forHorizontalAxis() {
            return this.build(VoxelShaper::forHorizontalAxis, Direction.Axis.Z);
        }

        public VoxelShaper forHorizontal(Direction direction) {
            return this.build(VoxelShaper::forHorizontal, direction);
        }

        public VoxelShaper forDirectional() {
            return this.forDirectional(Direction.UP);
        }
    }
}

