/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.CreatePropulsion;
import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.debug.DebugRenderer;
import com.deltasf.createpropulsion.thruster.AbstractThrusterBlock;
import com.deltasf.createpropulsion.thruster.AbstractThrusterBlockEntity;
import com.deltasf.createpropulsion.utility.MathUtility;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OrientedBB;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ThrusterDamager {
    private static final int TICKS_PER_ENTITY_CHECK = 5;
    private static final int LOWEST_POWER_THRSHOLD = 5;
    private final AbstractThrusterBlockEntity thruster;

    public ThrusterDamager(AbstractThrusterBlockEntity thruster) {
        this.thruster = thruster;
    }

    public void tick(int currentTick) {
        if (!this.shouldDamageEntities()) {
            return;
        }
        if (currentTick % 5 == 0) {
            this.doEntityDamageCheck();
        }
    }

    private boolean shouldDamageEntities() {
        return (Boolean)PropulsionConfig.THRUSTER_DAMAGE_ENTITIES.get() != false && this.thruster.isPowered() && this.thruster.isWorking();
    }

    private void doEntityDamageCheck() {
        double potentialPlumeLength;
        float visualPowerPercent = ((float)Math.max((int)this.thruster.getOverriddenPowerOrState(this.thruster.m_58900_()), (int)5) - 5.0f) / 15.0f;
        float distanceByPower = Math.lerp((float)0.55f, (float)1.5f, (float)visualPowerPercent);
        Direction plumeDirection = ((Direction)this.thruster.m_58900_().m_61143_((Property)AbstractThrusterBlock.FACING)).m_122424_();
        AABB plumeAABB = this.calculateAabb(plumeDirection, distanceByPower);
        List damageCandidates = this.thruster.m_58904_().m_45933_(null, plumeAABB);
        if (CreatePropulsion.debug) {
            this.debugObb(plumeDirection, distanceByPower);
        }
        if (damageCandidates.isEmpty()) {
            return;
        }
        NozzleInfo nozzleInfo = this.calculateNozzleInfo(plumeDirection);
        Vector3d localPlumeVec = new Vector3d(0.0, 0.0, 1.0);
        nozzleInfo.obbRotationWorldJOML().transform(localPlumeVec);
        Vec3 worldPlumeDirection = VectorConversionsMCKt.toMinecraft((Vector3dc)localPlumeVec);
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.thruster.m_58904_(), (BlockPos)this.thruster.m_58899_());
        if (ship != null) {
            double plumeLengthShip = (float)this.thruster.getEmptyBlocks() * distanceByPower;
            Vec3i normal = plumeDirection.m_122436_();
            Vector3d plumeDisplacementShip = new Vector3d((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_()).mul(plumeLengthShip);
            Vector3d plumeDisplacementWorld = ship.getShipToWorld().transformDirection((Vector3dc)plumeDisplacementShip, new Vector3d());
            potentialPlumeLength = plumeDisplacementWorld.length();
        } else {
            potentialPlumeLength = (float)this.thruster.getEmptyBlocks() * distanceByPower;
        }
        double correctedPlumeLength = this.performRaycastCheck(nozzleInfo.thrusterNozzleWorldPosMC(), worldPlumeDirection, potentialPlumeLength);
        if (correctedPlumeLength <= 0.01) {
            return;
        }
        ObbCalculationResult obbResult = this.calculateObb(plumeDirection, correctedPlumeLength, nozzleInfo);
        this.applyDamageToEntities(this.thruster.m_58904_(), damageCandidates, obbResult, visualPowerPercent);
    }

    private NozzleInfo calculateNozzleInfo(Direction plumeDirection) {
        Vector3d nozzleOffsetWorld;
        Quaterniond obbRotationWorldJOML;
        Vector3d thrusterCenterBlockWorldJOML;
        Quaterniond relativeRotationJOML = new Quaterniond().rotateTo((Vector3dc)new Vector3d(0.0, 0.0, 1.0), (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)plumeDirection.m_122436_()));
        BlockPos worldPosition = this.thruster.m_58899_();
        Level level = this.thruster.m_58904_();
        Vector3d thrusterCenterBlockShipCoordsJOMLD = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)worldPosition));
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)worldPosition);
        if (ship != null) {
            thrusterCenterBlockWorldJOML = ship.getShipToWorld().transformPosition((Vector3dc)thrusterCenterBlockShipCoordsJOMLD, new Vector3d());
            obbRotationWorldJOML = ship.getTransform().getShipToWorldRotation().mul((Quaterniondc)relativeRotationJOML, new Quaterniond());
            nozzleOffsetLocal = new Vector3d(0.0, 0.0, 0.5);
            Vector3d nozzleOffsetShip = relativeRotationJOML.transform((Vector3dc)nozzleOffsetLocal, new Vector3d());
            nozzleOffsetWorld = ship.getShipToWorld().transformDirection((Vector3dc)nozzleOffsetShip, new Vector3d());
        } else {
            thrusterCenterBlockWorldJOML = thrusterCenterBlockShipCoordsJOMLD;
            obbRotationWorldJOML = relativeRotationJOML;
            nozzleOffsetLocal = new Vector3d(0.0, 0.0, 0.5);
            nozzleOffsetWorld = obbRotationWorldJOML.transform((Vector3dc)nozzleOffsetLocal, new Vector3d());
        }
        Vector3d thrusterNozzleWorldPos = thrusterCenterBlockWorldJOML.add((Vector3dc)nozzleOffsetWorld, new Vector3d());
        Vec3 thrusterNozzleWorldPosMC = VectorConversionsMCKt.toMinecraft((Vector3dc)thrusterNozzleWorldPos);
        return new NozzleInfo(thrusterNozzleWorldPosMC, obbRotationWorldJOML, thrusterCenterBlockWorldJOML);
    }

    private double performRaycastCheck(Vec3 nozzlePos, Vec3 worldPlumeDirection, double maxDistance) {
        Vec3 endPos;
        ClipContext clipContext;
        Level level = this.thruster.m_58904_();
        BlockHitResult hitResult = level.m_45547_(clipContext = new ClipContext(nozzlePos, endPos = nozzlePos.m_82549_(worldPlumeDirection.m_82490_(maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return nozzlePos.m_82554_(hitResult.m_82450_());
        }
        return maxDistance;
    }

    private ObbCalculationResult calculateObb(Direction plumeDirection, double plumeLength, NozzleInfo nozzleInfo) {
        Vector3d plumeHalfExtentsJOML;
        Vector3d plumeWorldDir = new Vector3d(0.0, 0.0, 1.0);
        nozzleInfo.obbRotationWorldJOML().transform(plumeWorldDir);
        Vector3d nozzlePosWorld = VectorConversionsMCKt.toJOML((Vec3)nozzleInfo.thrusterNozzleWorldPosMC());
        Vector3d obbCenterWorldJOML = nozzlePosWorld.add((Vector3dc)plumeWorldDir.mul(plumeLength / 2.0), new Vector3d());
        Level level = this.thruster.m_58904_();
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)this.thruster.m_58899_());
        if (ship != null) {
            Vector3d temp;
            Vector3d plumeDirShip = VectorConversionsMCKt.toJOMLD((Vec3i)plumeDirection.m_122436_());
            if (java.lang.Math.abs(plumeDirShip.dot((Vector3dc)(temp = new Vector3d(1.0, 0.0, 0.0)))) > 0.99) {
                temp.set(0.0, 1.0, 0.0);
            }
            Vector3d rightVecShip = plumeDirShip.cross((Vector3dc)temp, new Vector3d()).normalize();
            Vector3d upVecShip = plumeDirShip.cross((Vector3dc)rightVecShip, new Vector3d()).normalize();
            Vector3d halfExtentX_ship = rightVecShip.mul(0.7);
            Vector3d halfExtentY_ship = upVecShip.mul(0.7);
            Vector3d halfExtentX_world = ship.getShipToWorld().transformDirection((Vector3dc)halfExtentX_ship, new Vector3d());
            Vector3d halfExtentY_world = ship.getShipToWorld().transformDirection((Vector3dc)halfExtentY_ship, new Vector3d());
            plumeHalfExtentsJOML = new Vector3d(halfExtentX_world.length(), halfExtentY_world.length(), plumeLength / 2.0);
        } else {
            plumeHalfExtentsJOML = new Vector3d(0.7, 0.7, plumeLength / 2.0);
        }
        Vec3 plumeCenterMC = VectorConversionsMCKt.toMinecraft((Vector3dc)obbCenterWorldJOML);
        Vec3 plumeHalfExtentsMC = VectorConversionsMCKt.toMinecraft((Vector3dc)plumeHalfExtentsJOML);
        Matrix3d plumeRotationMatrix = MathUtility.createMatrixFromQuaternion(nozzleInfo.obbRotationWorldJOML());
        OrientedBB plumeOBB = new OrientedBB(plumeCenterMC, plumeHalfExtentsMC, plumeRotationMatrix);
        return new ObbCalculationResult(plumeLength, nozzleInfo.thrusterNozzleWorldPosMC(), plumeOBB, obbCenterWorldJOML, plumeHalfExtentsJOML, nozzleInfo.obbRotationWorldJOML());
    }

    private AABB calculateAabb(Direction plumeDirection, float distanceByPower) {
        BlockPos worldPosition;
        Level level = this.thruster.m_58904_();
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)(worldPosition = this.thruster.m_58899_()));
        if (ship == null) {
            BlockPos blockBehind = worldPosition.m_121945_(plumeDirection);
            int aabbEndOffset = (int)Math.floor((float)((float)this.thruster.getEmptyBlocks() * distanceByPower)) + 1;
            BlockPos blockEnd = worldPosition.m_5484_(plumeDirection, aabbEndOffset);
            return new AABB(blockBehind).m_82367_(new AABB(blockEnd)).m_82400_(1.0);
        }
        double plumeLengthShipSpace = (double)((float)this.thruster.getEmptyBlocks() * distanceByPower) + 1.0;
        Vector3d startPosShip = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)worldPosition.m_121945_(plumeDirection)));
        Vec3i normal = plumeDirection.m_122436_();
        Vector3d plumeDisplacementShip = new Vector3d((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_()).mul(plumeLengthShipSpace);
        Vector3d endPosShip = startPosShip.add((Vector3dc)plumeDisplacementShip, new Vector3d());
        Vector3d startPosWorld = ship.getShipToWorld().transformPosition((Vector3dc)startPosShip, new Vector3d());
        Vector3d endPosWorld = ship.getShipToWorld().transformPosition((Vector3dc)endPosShip, new Vector3d());
        AABB plumeAABB = new AABB(VectorConversionsMCKt.toMinecraft((Vector3dc)startPosWorld), VectorConversionsMCKt.toMinecraft((Vector3dc)endPosWorld));
        Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
        double maxScale = java.lang.Math.max(scaling.x(), java.lang.Math.max(scaling.y(), scaling.z()));
        return plumeAABB.m_82400_(1.5 * maxScale);
    }

    private void applyDamageToEntities(Level level, List<Entity> damageCandidates, ObbCalculationResult obbResult, float visualPowerPercent) {
        DamageSource fireDamageSource = level.m_269111_().m_269549_();
        for (Entity entity : damageCandidates) {
            AABB entityAABB;
            if (entity.m_213877_() || entity.m_5825_() || obbResult.plumeOBB.intersect(entityAABB = entity.m_20191_()) == null) continue;
            float invSqrDistance = visualPowerPercent * 8.0f / (float)Math.max((double)1.0, (double)entity.m_20182_().m_82557_(obbResult.thrusterNozzleWorldPosMC));
            float damageAmount = 3.0f + invSqrDistance;
            entity.m_6469_(fireDamageSource, damageAmount);
            entity.m_20254_(3);
        }
    }

    private void debugObb(Direction plumeDirection, float distanceByPower) {
        double potentialPlumeLength;
        NozzleInfo nozzleInfo = this.calculateNozzleInfo(plumeDirection);
        Vector3d localPlumeVec = new Vector3d(0.0, 0.0, 1.0);
        nozzleInfo.obbRotationWorldJOML().transform(localPlumeVec);
        Vec3 worldPlumeDirection = VectorConversionsMCKt.toMinecraft((Vector3dc)localPlumeVec);
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.thruster.m_58904_(), (BlockPos)this.thruster.m_58899_());
        if (ship != null) {
            double plumeLengthShip = (float)this.thruster.getEmptyBlocks() * distanceByPower;
            Vec3i normal = plumeDirection.m_122436_();
            Vector3d plumeDisplacementShip = new Vector3d((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_()).mul(plumeLengthShip);
            Vector3d plumeDisplacementWorld = ship.getShipToWorld().transformDirection((Vector3dc)plumeDisplacementShip, new Vector3d());
            potentialPlumeLength = plumeDisplacementWorld.length();
        } else {
            potentialPlumeLength = (float)this.thruster.getEmptyBlocks() * distanceByPower;
        }
        double correctedPlumeLength = this.performRaycastCheck(nozzleInfo.thrusterNozzleWorldPosMC(), worldPlumeDirection, potentialPlumeLength);
        if (correctedPlumeLength <= 0.01) {
            return;
        }
        ObbCalculationResult obbResult = this.calculateObb(plumeDirection, correctedPlumeLength, nozzleInfo);
        String identifier = "thruster_" + ((Object)((Object)this.thruster)).hashCode() + "_obb";
        Quaternionf debugRotation = new Quaternionf((float)obbResult.obbRotationWorldJOML.x, (float)obbResult.obbRotationWorldJOML.y, (float)obbResult.obbRotationWorldJOML.z, (float)obbResult.obbRotationWorldJOML.w);
        Vec3 debugSize = new Vec3(obbResult.plumeHalfExtentsJOML.x * 2.0, obbResult.plumeHalfExtentsJOML.y * 2.0, obbResult.plumeHalfExtentsJOML.z * 2.0);
        Vec3 debugCenter = VectorConversionsMCKt.toMinecraft((Vector3dc)obbResult.obbCenterWorldJOML);
        DebugRenderer.drawBox(identifier, debugCenter, debugSize, debugRotation, Color.ORANGE, false, 6);
    }

    private record NozzleInfo(Vec3 thrusterNozzleWorldPosMC, Quaterniond obbRotationWorldJOML, Vector3d thrusterCenterBlockWorldJOML) {
    }

    private record ObbCalculationResult(double plumeLength, Vec3 thrusterNozzleWorldPosMC, OrientedBB plumeOBB, Vector3d obbCenterWorldJOML, Vector3d plumeHalfExtentsJOML, Quaterniond obbRotationWorldJOML) {
    }
}

