/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.PropulsionConfig;
import com.deltasf.createpropulsion.thruster.ThrusterData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.VSPipeline;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ThrusterForceApplier {
    private ThrusterData data;
    private Vector3d relativePos = new Vector3d();
    private final Vector3d worldForceDirection = new Vector3d();
    private final Vector3d worldForce = new Vector3d();
    private final Vector3d parallelForce = new Vector3d();
    private final Vector3d perpendicularForce = new Vector3d();
    private Vector3d velocityDirection = new Vector3d();
    private static final Vector3d scaledForce_temp1 = new Vector3d();
    private static final Vector3d scaledForce_temp2 = new Vector3d();
    private static final Vector3d scaledForce_temp3 = new Vector3d();

    public ThrusterForceApplier(ThrusterData data) {
        this.data = data;
    }

    public void applyForces(BlockPos pos, PhysShipImpl ship) {
        double dot;
        float thrust = this.data.getThrust();
        if (thrust == 0.0f) {
            return;
        }
        int maxSpeed = (Integer)PropulsionConfig.THRUSTER_MAX_SPEED.get();
        ShipTransform transform = ship.getTransform();
        Vector3dc scaling = transform.getShipToWorldScaling();
        double massScalingFactor = scaling.x() * scaling.y() * scaling.z();
        Vector3dc shipCenterOfMass = transform.getPositionInShip();
        this.relativePos = VectorConversionsMCKt.toJOMLD((Vec3i)pos).add(0.5, 0.5, 0.5).sub(shipCenterOfMass);
        transform.getShipToWorld().transformDirection((Vector3dc)this.data.getDirection(), this.worldForceDirection);
        this.worldForceDirection.normalize();
        this.worldForce.set((Vector3dc)this.worldForceDirection).mul((double)thrust * massScalingFactor);
        Vector3dc linearVelocity = ship.getPoseVel().getVel();
        if (linearVelocity.lengthSquared() >= (double)(maxSpeed * maxSpeed) && (dot = this.worldForce.dot(linearVelocity)) > 0.0) {
            double forceLengthSq = this.worldForce.lengthSquared();
            if (forceLengthSq > 1.0E-9) {
                this.velocityDirection = this.velocityDirection.set(linearVelocity).normalize();
                double parallelMagnitude = this.worldForce.dot((Vector3dc)this.velocityDirection);
                this.parallelForce.set((Vector3dc)this.velocityDirection).mul(parallelMagnitude);
                this.perpendicularForce.set((Vector3dc)this.worldForce).sub((Vector3dc)this.parallelForce);
                ship.applyInvariantForceToPos((Vector3dc)this.perpendicularForce, (Vector3dc)this.relativePos);
                ThrusterForceApplier.applyScaledForce(ship, linearVelocity, this.parallelForce, maxSpeed);
            }
            return;
        }
        ship.applyInvariantForceToPos((Vector3dc)this.worldForce, (Vector3dc)this.relativePos);
    }

    private static void applyScaledForce(PhysShipImpl ship, Vector3dc linearVelocity, Vector3d forceToScale, float maxSpeed) {
        MinecraftServer currentServer = ValkyrienSkiesMod.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        VSPipeline pipeline = VSGameUtilsKt.getVsPipeline((MinecraftServer)currentServer);
        double physTps = pipeline.computePhysTps();
        if (physTps <= 0.0) {
            return;
        }
        double deltaTime = 1.0 / physTps;
        double mass = ship.getInertia().getShipMass();
        if (mass <= 0.0) {
            return;
        }
        forceToScale.mul(deltaTime / mass, scaledForce_temp1);
        linearVelocity.add((Vector3dc)scaledForce_temp1, scaledForce_temp2);
        scaledForce_temp2.normalize((double)maxSpeed, scaledForce_temp3);
        scaledForce_temp3.sub(linearVelocity, scaledForce_temp1);
        scaledForce_temp1.mul(mass / deltaTime, scaledForce_temp2);
        ship.applyInvariantForce((Vector3dc)scaledForce_temp2);
    }
}

