/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.thruster;

import com.deltasf.createpropulsion.network.PropulsionPackets;
import com.deltasf.createpropulsion.network.SyncThrusterFuelsPacket;
import com.deltasf.createpropulsion.thruster.FluidThrusterProperties;
import com.deltasf.createpropulsion.thruster.ThrusterFuelDefinition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

public class ThrusterFuelManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "thruster_fuels";
    private static Map<Fluid, FluidThrusterProperties> fuelPropertiesMap = new HashMap<Fluid, FluidThrusterProperties>();
    public static final TagKey<Fluid> FORGE_FUEL_TAG = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", "fuel"));

    public static Map<Fluid, FluidThrusterProperties> getFuelPropertiesMap() {
        return fuelPropertiesMap;
    }

    public ThrusterFuelManager() {
        super(GSON, DIRECTORY);
    }

    @Nullable
    public static FluidThrusterProperties getProperties(Fluid fluid) {
        if (fluid == null || fluid == Fluids.f_76191_) {
            return null;
        }
        FluidThrusterProperties props = fuelPropertiesMap.get(fluid);
        if (props != null) {
            return props;
        }
        if (fluid.m_205067_(FORGE_FUEL_TAG)) {
            return FluidThrusterProperties.DEFAULT;
        }
        return null;
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> pObject, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        profiler.m_6180_("createpropulsion:Loading_thruster_fuels");
        fuelPropertiesMap = this.parseFuelProperties(pObject);
        profiler.m_7238_();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.m_130010_()) {
            PropulsionPackets.sendToAll(SyncThrusterFuelsPacket.create(fuelPropertiesMap));
        }
    }

    public static void updateClient(Map<ResourceLocation, FluidThrusterProperties> fuelMap) {
        HashMap<Fluid, FluidThrusterProperties> newClientMap = new HashMap<Fluid, FluidThrusterProperties>();
        fuelMap.forEach((rl, props) -> {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
            if (fluid != null) {
                newClientMap.put(fluid, (FluidThrusterProperties)props);
            }
        });
        fuelPropertiesMap = newClientMap;
    }

    private Map<Fluid, FluidThrusterProperties> parseFuelProperties(@Nonnull Map<ResourceLocation, JsonElement> pObject) {
        HashMap<Fluid, FluidThrusterProperties> newMap = new HashMap<Fluid, FluidThrusterProperties>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation file = entry.getKey();
            JsonElement json = entry.getValue();
            ThrusterFuelDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(error -> LOGGER.error("[{}] Failed to parse thruster fuel definition from {}: {}", new Object[]{"createpropulsion", file, error})).ifPresent(definition -> {
                if (definition.requiredMod().isPresent() && !ModList.get().isLoaded(definition.requiredMod().get())) {
                    return;
                }
                Fluid fluid = definition.getFluid();
                if (fluid == Fluids.f_76191_) {
                    return;
                }
                FluidThrusterProperties properties = new FluidThrusterProperties(definition.thrustMultiplier(), definition.consumptionMultiplier());
                newMap.put(fluid, properties);
            });
        }
        return newMap;
    }
}

