/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.utility;

import com.deltasf.createpropulsion.optical_sensors.rendering.BeamRenderData;
import com.deltasf.createpropulsion.optical_sensors.rendering.OpticalSensorBeamRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Mod.EventBusSubscriber(modid="createpropulsion", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TranslucentBeamRenderer {
    private static final Queue<BeamRenderData> RENDER_QUEUE = new ConcurrentLinkedQueue<BeamRenderData>();

    public static void scheduleBeamRender(BeamRenderData data) {
        RENDER_QUEUE.offer(data);
    }

    @SubscribeEvent
    public static void onRenderLevelStageEnd(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            TranslucentBeamRenderer.renderAllBeams(event.getPoseStack());
            RENDER_QUEUE.clear();
        }
    }

    private static void renderAllBeams(PoseStack poseStack) {
        if (RENDER_QUEUE.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.f_91063_ == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VertexConsumer buffer = bufferSource.m_6299_(OpticalSensorBeamRenderType.SOLID_TRANSLUCENT_BEAM);
        for (BeamRenderData data : RENDER_QUEUE) {
            poseStack.m_85836_();
            TranslucentBeamRenderer.drawBeam(buffer, data);
            poseStack.m_85849_();
        }
        bufferSource.m_109912_(OpticalSensorBeamRenderType.SOLID_TRANSLUCENT_BEAM);
    }

    public static void drawBeam(VertexConsumer buffer, BeamRenderData data) {
        Matrix4f pose = data.poseSnapshot.m_252922_();
        if (TranslucentBeamRenderer.isCameraInside(data)) {
            TranslucentBeamRenderer.drawQuadReversed(buffer, pose, data.sBottomLeft, data.sBottomRight, data.eBottomRight, data.eBottomLeft, data.startColor, data.endColor, data.normalBottom);
            TranslucentBeamRenderer.drawQuadReversed(buffer, pose, data.sBottomRight, data.sTopRight, data.eTopRight, data.eBottomRight, data.startColor, data.endColor, data.normalRight);
            TranslucentBeamRenderer.drawQuadReversed(buffer, pose, data.sTopRight, data.sTopLeft, data.eTopLeft, data.eTopRight, data.startColor, data.endColor, data.normalTop);
            TranslucentBeamRenderer.drawQuadReversed(buffer, pose, data.sTopLeft, data.sBottomLeft, data.eBottomLeft, data.eTopLeft, data.startColor, data.endColor, data.normalLeft);
        } else {
            TranslucentBeamRenderer.drawQuad(buffer, pose, data.sBottomLeft, data.sBottomRight, data.eBottomRight, data.eBottomLeft, data.startColor, data.endColor, data.normalBottom);
            TranslucentBeamRenderer.drawQuad(buffer, pose, data.sBottomRight, data.sTopRight, data.eTopRight, data.eBottomRight, data.startColor, data.endColor, data.normalRight);
            TranslucentBeamRenderer.drawQuad(buffer, pose, data.sTopRight, data.sTopLeft, data.eTopLeft, data.eTopRight, data.startColor, data.endColor, data.normalTop);
            TranslucentBeamRenderer.drawQuad(buffer, pose, data.sTopLeft, data.sBottomLeft, data.eBottomLeft, data.eTopLeft, data.startColor, data.endColor, data.normalLeft);
        }
    }

    private static void drawQuad(VertexConsumer buffer, Matrix4f pose, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector4f startColor, Vector4f endColor, Vector3f normal) {
        buffer.m_252986_(pose, v1.x(), v1.y(), v1.z()).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        buffer.m_252986_(pose, v2.x(), v2.y(), v2.z()).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        buffer.m_252986_(pose, v3.x(), v3.y(), v3.z()).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        buffer.m_252986_(pose, v4.x(), v4.y(), v4.z()).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    private static void drawQuadReversed(VertexConsumer buffer, Matrix4f pose, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector4f startColor, Vector4f endColor, Vector3f normal) {
        Vector3f flippedNormal = new Vector3f(-normal.x(), -normal.y(), -normal.z());
        buffer.m_252986_(pose, v4.x(), v4.y(), v4.z()).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5601_(flippedNormal.x(), flippedNormal.y(), flippedNormal.z()).m_5752_();
        buffer.m_252986_(pose, v3.x(), v3.y(), v3.z()).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5601_(flippedNormal.x(), flippedNormal.y(), flippedNormal.z()).m_5752_();
        buffer.m_252986_(pose, v2.x(), v2.y(), v2.z()).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5601_(flippedNormal.x(), flippedNormal.y(), flippedNormal.z()).m_5752_();
        buffer.m_252986_(pose, v1.x(), v1.y(), v1.z()).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5601_(flippedNormal.x(), flippedNormal.y(), flippedNormal.z()).m_5752_();
    }

    private static boolean isCameraInside(BeamRenderData data) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || data.worldToLocalTransform == null) {
            return false;
        }
        Vector4f cameraInLocalSpace4 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        cameraInLocalSpace4.mul((Matrix4fc)data.worldToLocalTransform);
        Vector3f cameraInLocalSpace = new Vector3f(cameraInLocalSpace4.x, cameraInLocalSpace4.y, cameraInLocalSpace4.z);
        Vector3f beamOrigin = data.sBottomLeft;
        Vector3f relativePos = cameraInLocalSpace.sub((Vector3fc)beamOrigin, new Vector3f());
        Vector3f axisAlong = data.eBottomLeft.sub((Vector3fc)data.sBottomLeft, new Vector3f());
        Vector3f axisUp = data.sTopLeft.sub((Vector3fc)data.sBottomLeft, new Vector3f());
        Vector3f axisSide = data.sBottomRight.sub((Vector3fc)data.sBottomLeft, new Vector3f());
        float axisAlongLenSqr = axisAlong.lengthSquared();
        float axisUpLenSqr = axisUp.lengthSquared();
        float axisSideLenSqr = axisSide.lengthSquared();
        if ((double)axisAlongLenSqr < 1.0E-6 || (double)axisUpLenSqr < 1.0E-6 || (double)axisSideLenSqr < 1.0E-6) {
            return false;
        }
        float projAlong = relativePos.dot((Vector3fc)axisAlong) / axisAlongLenSqr;
        float projUp = relativePos.dot((Vector3fc)axisUp) / axisUpLenSqr;
        float projSide = relativePos.dot((Vector3fc)axisSide) / axisSideLenSqr;
        return projAlong >= 0.0f && projAlong <= 1.0f && projUp >= 0.0f && projUp <= 1.0f && projSide >= 0.0f && projSide <= 1.0f;
    }
}

