/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.wing;

import com.deltasf.createpropulsion.wing.CopycatWingBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class CopycatWingModel
extends CopycatModel {
    private final int width;
    private static final float PIXELS_PER_BLOCK = 16.0f;

    public CopycatWingModel(BakedModel originalModel, int width) {
        super(originalModel);
        this.width = width;
    }

    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        Direction facing = (Direction)state.m_61143_((Property)CopycatWingBlock.FACING);
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            facing = facing.m_122424_();
        }
        Direction.Axis axis = facing.m_122434_();
        BakedModel model = CopycatWingModel.getModelOf((BlockState)material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData, renderType);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float halfWidth = (float)this.width / 2.0f;
        float offsetDistance = (16.0f - (float)this.width) / 32.0f;
        for (boolean isPositiveSide : Iterate.trueAndFalse) {
            Direction culledFace = isPositiveSide ? facing.m_122424_() : facing;
            Vec3i placementNormal = culledFace.m_122436_();
            Vec3 placementOffset = new Vec3((double)((float)placementNormal.m_123341_() * offsetDistance), (double)((float)placementNormal.m_123342_() * offsetDistance), (double)((float)placementNormal.m_123343_() * offsetDistance));
            float cropExtent = halfWidth / 16.0f;
            float minX = 0.0f;
            float minY = 0.0f;
            float minZ = 0.0f;
            float maxX = 1.0f;
            float maxY = 1.0f;
            float maxZ = 1.0f;
            switch (axis) {
                case X: {
                    if (!isPositiveSide) {
                        minX = 1.0f - cropExtent;
                        break;
                    }
                    maxX = cropExtent;
                    break;
                }
                case Y: {
                    if (!isPositiveSide) {
                        minY = 1.0f - cropExtent;
                        break;
                    }
                    maxY = cropExtent;
                    break;
                }
                case Z: {
                    if (!isPositiveSide) {
                        minZ = 1.0f - cropExtent;
                        break;
                    }
                    maxZ = cropExtent;
                }
            }
            AABB croppingBox = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            for (BakedQuad quad : templateQuads) {
                if (quad.m_111306_() == culledFace) continue;
                quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])BakedModelHelper.cropAndMove((int[])quad.m_111303_(), (TextureAtlasSprite)quad.m_173410_(), (AABB)croppingBox, (Vec3)placementOffset)));
            }
        }
        return quads;
    }
}

