/*
 * Decompiled with CFR 0.152.
 */
package com.deltasf.createpropulsion.wing;

import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class WingPlacementHelper
implements IPlacementHelper {
    private List<BlockEntry<?>> blockEntries;

    public WingPlacementHelper(List<BlockEntry<?>> blockEntries) {
        this.blockEntries = blockEntries;
    }

    public Predicate<ItemStack> getItemPredicate() {
        return stack -> this.blockEntries.stream().anyMatch(be -> be.isIn(stack));
    }

    public Predicate<BlockState> getStatePredicate() {
        return state -> this.blockEntries.stream().anyMatch(be -> be.has(state));
    }

    public PlacementOffset getOffset(@Nonnull Player player, @Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull BlockHitResult ray) {
        List directions;
        Vec3 result = ray.m_82450_();
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)world, (BlockPos)ray.m_82425_());
        if (ship != null && !VSGameUtilsKt.isBlockInShipyard((Level)world, (double)result.f_82479_, (double)result.f_82480_, (double)result.f_82481_)) {
            Vector3d tempVec = VectorConversionsMCKt.toJOML((Vec3)result);
            ship.getWorldToShip().transformPosition((Vector3dc)tempVec, tempVec);
            result = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        if ((directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)result, (Direction.Axis)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_(), dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_())).isEmpty()) {
            return PlacementOffset.fail();
        }
        return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)s.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_))));
    }
}

