/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class TubeModelBuilder {
    private static final Map<String, CCModel> TUBE_MODELS = TubeModelBuilder.loadModels("tube", (k, v) -> v.apply((Transformation)new Translation(Vector3.CENTER)));
    private int modelKey = 0;
    private boolean isWire = false;
    private boolean modelBuilt = false;
    @Nullable
    private CCModel model = null;

    public TubeModelBuilder setModelKey(int key) {
        this.modelKey = key;
        return this;
    }

    public TubeModelBuilder setWireMode(boolean isWire) {
        this.isWire = isWire;
        return this;
    }

    public CCModel build() {
        if (!this.modelBuilt) {
            this.buildModel();
            this.modelBuilt = true;
            assert (this.model != null);
            return this.model;
        }
        assert (this.model != null);
        return this.model.copy();
    }

    private String axisName(int i) {
        return (this.isWire ? "wire_a" : "a") + i;
    }

    private String centerName() {
        return this.isWire ? "wire_center" : "center";
    }

    private String sideName(int s) {
        return (this.isWire ? "wire_s" : "s") + s;
    }

    private void buildModel() {
        int connMap = this.modelKey & 0x3F;
        int connCount = TubeModelBuilder.countConnections(this.modelKey);
        int axisCount = TubeModelBuilder.countAxis(this.modelKey);
        if (connCount == 2 && axisCount == 1) {
            int axis = (connMap & 3) != 0 ? 0 : ((connMap & 0xC) != 0 ? 1 : 2);
            String mKey = this.axisName(axis);
            this.model = TUBE_MODELS.get(mKey).copy();
            return;
        }
        LinkedList<CCModel> modelList = new LinkedList<CCModel>();
        modelList.add(TUBE_MODELS.get(this.centerName()));
        for (int s = 0; s < 6; ++s) {
            if ((connMap & 1 << s) == 0) continue;
            String mKey = this.sideName(s);
            modelList.add(TUBE_MODELS.get(mKey));
        }
        this.model = CCModel.combine(modelList);
    }

    public static int countConnections(int connMask) {
        int count = 0;
        for (int s = 0; s < 6; ++s) {
            if ((connMask & 1 << s) == 0) continue;
            ++count;
        }
        return count;
    }

    public static int countAxis(int connMask) {
        int count = 0;
        for (int a = 0; a < 3; ++a) {
            if ((connMask & 3 << a * 2) == 0) continue;
            ++count;
        }
        return count;
    }

    public static Map<String, CCModel> loadModels(String path) {
        return TubeModelBuilder.loadModels(path, (k, v) -> {});
    }

    public static Map<String, CCModel> loadModels(String path, BiConsumer<String, CCModel> operation) {
        Map models = new OBJParser(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)("obj/" + path + ".obj"))).ignoreMtl().quads().parse();
        models.replaceAll((k, v) -> v.backfacedCopy());
        for (Map.Entry m : models.entrySet()) {
            operation.accept((String)m.getKey(), (CCModel)m.getValue());
            ((CCModel)m.getValue()).computeNormals();
            ((CCModel)m.getValue()).shrinkUVs(5.0E-4);
            ((CCModel)m.getValue()).computeLighting(LightModel.standardLightModel);
        }
        return models;
    }
}

