/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.graphs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import mrtjp.projectred.expansion.graphs.GraphLink;
import mrtjp.projectred.expansion.graphs.GraphNode;

public class GraphNodePathfinder {
    private final Queue<GraphNode> open = new LinkedList<GraphNode>();
    private final HashSet<GraphNode> openSet = new HashSet();
    private final HashSet<GraphNode> closedSet = new LinkedHashSet<GraphNode>();

    public GraphNodePathfinder(Collection<GraphNode> startNodes) {
        this.openInitial(startNodes);
    }

    private void openInitial(Collection<GraphNode> startNodes) {
        for (GraphNode node : startNodes) {
            if (this.openSet.contains(node)) continue;
            this.open.add(node);
            this.openSet.add(node);
        }
    }

    private void openNext(GraphNode prev) {
        List nextLinks = prev.getLinksIfPresent().orElse(Collections.emptyList());
        for (GraphLink link : nextLinks) {
            GraphNode next = link.to().getNode();
            if (this.openSet.contains(next) || this.closedSet.contains(next)) continue;
            this.open.add(next);
            this.openSet.add(next);
        }
    }

    public void step() {
        if (this.open.isEmpty()) {
            return;
        }
        GraphNode next = this.open.poll();
        this.openSet.remove(next);
        this.openNext(next);
        this.closedSet.add(next);
    }

    public boolean isFinished() {
        return this.open.isEmpty();
    }

    public Collection<GraphNode> result() {
        while (!this.isFinished()) {
            this.step();
        }
        return Collections.unmodifiableCollection(this.closedSet);
    }
}

