/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.CCLMenuType;
import java.util.Objects;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.tile.DeployerBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DeployerMenu
extends AbstractContainerMenu {
    public static final CCLMenuType<DeployerMenu> FACTORY = (windowId, playerInv, packet) -> {
        BlockEntity tile = playerInv.player.level().getBlockEntity(Objects.requireNonNull(packet).readPos());
        if (!(tile instanceof DeployerBlockEntity)) {
            return null;
        }
        DeployerBlockEntity dbe = (DeployerBlockEntity)tile;
        return new DeployerMenu(playerInv, dbe, windowId);
    };
    private final DeployerBlockEntity tile;
    private final Inventory playerInventory;

    public DeployerMenu(Inventory playerInventory, DeployerBlockEntity tile, int windowId) {
        super(ExpansionMenus.DEPLOYER_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)86, arg_0 -> ((DeployerMenu)this).addSlot(arg_0));
        this.addDeployerInventory();
    }

    private void addDeployerInventory() {
        InventoryLib.addInventory((Container)this.tile.getInventory(), (int)0, (int)62, (int)18, (int)3, (int)3, arg_0 -> ((DeployerMenu)this).addSlot(arg_0));
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this.tile, (Player)player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isStorage(slotIndex) ? !this.moveToEntireInventory(stack, true) : !this.moveToStorage(stack, false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 45;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 45, reverse);
    }
}

