/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.pneumatics;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.graphs.GraphContainer;
import mrtjp.projectred.expansion.graphs.GraphRoute;
import mrtjp.projectred.expansion.graphs.GraphRouteTable;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportContainer;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportMode;

public class PneumaticExitPathfinder {
    private final PneumaticTransportContainer startContainer;
    private final GraphRouteTable routeTable;
    private final PneumaticTubePayload payload;
    private final int dirMask;
    private final List<PneumaticTransportMode> searchModes;
    boolean searched = false;
    private int exitDirMask = 0;
    private int exitWeight = Integer.MAX_VALUE;
    @Nullable
    private PneumaticTransportMode exitMode = null;

    public PneumaticExitPathfinder(PneumaticTransportContainer startContainer, GraphRouteTable routeTable, PneumaticTubePayload payload, int dirMask) {
        this(startContainer, routeTable, payload, dirMask, List.of(PneumaticTransportMode.values()));
    }

    public PneumaticExitPathfinder(PneumaticTransportContainer startContainer, GraphRouteTable routeTable, PneumaticTubePayload payload, int dirMask, List<PneumaticTransportMode> modes) {
        this.startContainer = startContainer;
        this.routeTable = routeTable;
        this.payload = payload;
        this.dirMask = dirMask;
        this.searchModes = modes;
    }

    private void search(PneumaticTransportContainer startContainer, int dirMask) {
        for (PneumaticTransportMode mode : this.searchModes) {
            this.exitDirMask = 0;
            this.exitWeight = Integer.MAX_VALUE;
            this.exitMode = null;
            if (!this.searchMode(startContainer, dirMask, mode)) continue;
            this.exitMode = mode;
            break;
        }
        this.searched = true;
    }

    private boolean searchMode(PneumaticTransportContainer startContainer, int dirMask, PneumaticTransportMode mode) {
        int s;
        for (s = 0; s < 6; ++s) {
            if ((dirMask & 1 << s) == 0 || !startContainer.canItemExitTube(this.payload, s, mode)) continue;
            this.exitDirMask |= 1 << s;
            this.exitWeight = 0;
        }
        if (this.exitDirMask != 0) {
            return true;
        }
        block1: for (s = 0; s < 6; ++s) {
            if ((dirMask & 1 << s) == 0) continue;
            Iterator<GraphRoute> routeIt = this.routeTable.routeIteratorInDirection(s);
            block2: while (routeIt.hasNext()) {
                GraphRoute route = routeIt.next();
                GraphContainer graphContainer = route.end().container;
                if (!(graphContainer instanceof PneumaticTransportContainer)) continue;
                PneumaticTransportContainer ptc = (PneumaticTransportContainer)((Object)graphContainer);
                if (route.weight() > this.exitWeight) continue block1;
                for (int s1 = 0; s1 < 6; ++s1) {
                    if (!ptc.canItemExitTube(this.payload, s1, mode)) continue;
                    if (route.weight() < this.exitWeight) {
                        this.exitWeight = route.weight();
                        this.exitDirMask = 0;
                    }
                    this.exitDirMask |= 1 << s;
                    continue block2;
                }
            }
        }
        return this.exitDirMask != 0;
    }

    public PneumaticExits result() {
        if (!this.searched) {
            this.search(this.startContainer, this.dirMask);
        }
        return new PneumaticExits(this.exitDirMask, this.exitWeight, this.exitMode);
    }

    public record PneumaticExits(int exitDirMask, int weight, @Nullable PneumaticTransportMode mode) {
    }
}

