/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.pneumatics;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportContainer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PneumaticTransport {
    private final PneumaticTransportContainer container;
    private final HashMap<Integer, PneumaticTubePayload> payloads = new HashMap();
    private int nextId = 0;

    public PneumaticTransport(PneumaticTransportContainer container) {
        this.container = container;
    }

    public void save(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag payloadList = new ListTag();
        for (Map.Entry<Integer, PneumaticTubePayload> e : this.payloads.entrySet()) {
            CompoundTag payloadTag = new CompoundTag();
            payloadTag.putInt("id", e.getKey().intValue());
            e.getValue().save(payloadTag, lookupProvider);
            payloadList.add((Object)payloadTag);
        }
        tag.put("payloads", (Tag)payloadList);
        tag.putInt("nextId", this.nextId);
    }

    public void load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.payloads.clear();
        ListTag payloadList = tag.getList("payloads", 10);
        for (int i = 0; i < payloadList.size(); ++i) {
            CompoundTag payloadTag = payloadList.getCompound(i);
            int id = payloadTag.getInt("id");
            PneumaticTubePayload payload = new PneumaticTubePayload();
            payload.load(payloadTag, lookupProvider);
            this.payloads.put(id, payload);
        }
        this.nextId = tag.getInt("nextId");
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeVarInt(this.payloads.size());
        for (Map.Entry<Integer, PneumaticTubePayload> e : this.payloads.entrySet()) {
            packet.writeVarInt(e.getKey().intValue());
            e.getValue().writeDesc(packet);
        }
    }

    public void readDesc(MCDataInput packet) {
        this.payloads.clear();
        int size = packet.readVarInt();
        for (int i = 0; i < size; ++i) {
            int id = packet.readVarInt();
            PneumaticTubePayload payload = new PneumaticTubePayload();
            payload.readDesc(packet);
            this.payloads.put(id, payload);
        }
    }

    @Nullable
    public PneumaticTubePayload removePayload(int id) {
        return this.payloads.remove(id);
    }

    @Nullable
    public PneumaticTubePayload getPayload(int id) {
        return this.payloads.get(id);
    }

    public void addPayload(int id, PneumaticTubePayload payload) {
        assert (!this.payloads.containsValue(payload));
        this.payloads.put(id, payload);
    }

    public int addPayload(PneumaticTubePayload payload) {
        assert (!this.payloads.containsValue(payload));
        int id = this.getNextId();
        this.payloads.put(id, payload);
        return id;
    }

    public Collection<PneumaticTubePayload> getPayloads() {
        return this.payloads.values();
    }

    public Collection<Integer> removePayloadsConditionally(Predicate<PneumaticTubePayload> condition) {
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        for (Map.Entry<Integer, PneumaticTubePayload> e : this.payloads.entrySet()) {
            if (!condition.test(e.getValue())) continue;
            toRemove.add(e.getKey());
        }
        Iterator<Map.Entry<Integer, PneumaticTubePayload>> iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)((Object)iterator.next());
            this.payloads.remove(id);
        }
        return toRemove;
    }

    public void tick() {
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        for (Map.Entry<Integer, PneumaticTubePayload> e : this.payloads.entrySet()) {
            PneumaticTubePayload payload = e.getValue();
            int p1 = payload.getProgress();
            payload.incrementProgress();
            int p2 = payload.getProgress();
            int outputCalcBoundary = 127 - payload.getSpeed();
            if (p1 < outputCalcBoundary && p2 >= outputCalcBoundary) {
                this.container.setOutputDirection(payload);
                this.container.onPayloadChanged(e.getKey(), payload);
            }
            if (p1 < 255 && p2 >= 255 && this.container.onPayloadReachedOutput(e.getKey(), payload)) {
                toRemove.add(e.getKey());
            }
            if (p2 < 510) continue;
            toRemove.add(e.getKey());
        }
        Iterator<Map.Entry<Integer, PneumaticTubePayload>> iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)((Object)iterator.next());
            this.payloads.remove(id);
        }
    }

    private int getNextId() {
        int id = this.nextId++;
        while (this.payloads.containsKey(id)) {
            ++this.nextId;
        }
        return id;
    }
}

