/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.CCLMenuType;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.inventory.container.BaseMachineMenu;
import mrtjp.projectred.expansion.item.RecipePlanComponent;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.expansion.tile.AutoCrafterBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AutoCrafterMenu
extends BaseMachineMenu {
    public static final CCLMenuType<AutoCrafterMenu> FACTORY = (windowId, playerInv, packet) -> {
        BlockEntity tile = playerInv.player.level().getBlockEntity(packet.readPos());
        if (!(tile instanceof AutoCrafterBlockEntity)) {
            return null;
        }
        return new AutoCrafterMenu(playerInv, (AutoCrafterBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final AutoCrafterBlockEntity tile;
    private int planSlot;

    public AutoCrafterMenu(Inventory inventory, AutoCrafterBlockEntity tile, int windowId) {
        super(ExpansionMenus.AUTO_CRAFTER_MENU.get(), windowId, tile);
        this.playerInventory = inventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)inventory, (int)8, (int)130, x$0 -> this.addSlot((Slot)x$0));
        this.addAutoCrafterInventory();
        this.addDataSlot((DataSlot)new SimpleDataSlot(tile::getPlanSlot, value -> {
            this.planSlot = value;
        }));
    }

    private void addAutoCrafterInventory() {
        InventoryLib.addInventory((Container)this.tile.getStorageInventory(), (int)0, (int)8, (int)80, (int)9, (int)2, x$0 -> this.addSlot((Slot)x$0));
        InventoryLib.addInventory((Container)this.tile.getPlanInventory(), (int)0, (int)44, (int)22, (int)3, (int)3, PlanSlot::new, x$0 -> this.addSlot((Slot)x$0));
    }

    public AutoCrafterBlockEntity getAutoCrafterTile() {
        return this.tile;
    }

    public ItemStack getPlanOutput() {
        ItemStack planStack = this.tile.getPlanInventory().getItem(this.planSlot);
        RecipePlanComponent recipeData = RecipePlanComponent.getComponent(planStack);
        return recipeData != null ? recipeData.getOutput() : ItemStack.EMPTY;
    }

    public int getPlanSlot() {
        return this.planSlot;
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isPlanSlots(slotIndex) ? !this.moveToEntireInventory(stack, false) && !this.moveToStorage(stack, false) : (this.isStorage(slotIndex) ? (stack.getItem() instanceof RecipePlanItem ? !this.moveToPlanSlots(stack, false) && !this.moveToEntireInventory(stack, false) : !this.moveToEntireInventory(stack, false)) : (this.isPlayerInventory(slotIndex) || this.isHotbar(slotIndex)) && (stack.getItem() instanceof RecipePlanItem ? !this.moveToPlanSlots(stack, false) && !this.moveToStorage(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToStorage(stack, false) && !this.moveToHotbar(stack, false) : !this.moveToStorage(stack, false) && !this.moveToPlayerInventory(stack, false))))) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 54;
    }

    private boolean isPlanSlots(int slotIndex) {
        return slotIndex >= 54 && slotIndex < 63;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToStorage(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 54, reverse);
    }

    private boolean moveToPlanSlots(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 54, 63, reverse);
    }

    private static class PlanSlot
    extends Slot {
        public PlanSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            RecipePlanComponent recipeData = RecipePlanComponent.getComponent(stack);
            return recipeData != null && recipeData.isRecipeValid();
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

