/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.init.ExpansionDataComponents;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class RecipePlanComponent
implements TooltipProvider {
    private final List<ItemStack> inputs;
    private final ItemStack output;
    public static final Codec<RecipePlanComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ItemStack.CODEC).fieldOf("inputs").forGetter(c -> c.inputs), (App)ItemStack.CODEC.fieldOf("output").forGetter(c -> c.output)).apply((Applicative)instance, RecipePlanComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipePlanComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), c -> c.inputs, (StreamCodec)ItemStack.STREAM_CODEC, c -> c.output, RecipePlanComponent::new);

    private RecipePlanComponent(List<ItemStack> inputs, ItemStack output) {
        this.inputs = inputs;
        this.output = output;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RecipePlanComponent)) {
            return false;
        }
        RecipePlanComponent that = (RecipePlanComponent)o;
        return Objects.equals(this.inputs, that.inputs) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.inputs, this.output);
    }

    @Nullable
    public static RecipePlanComponent getComponent(ItemStack stack) {
        return (RecipePlanComponent)stack.get(ExpansionDataComponents.RECIPE_PLAN_COMPONENT_TYPE);
    }

    public static void setComponent(ItemStack stack, RecipePlanComponent component) {
        stack.set(ExpansionDataComponents.RECIPE_PLAN_COMPONENT_TYPE, (Object)component);
    }

    public ItemStack[] getInputs() {
        return (ItemStack[])FastStream.of(this.inputs).map(ItemStack::copy).toArray((Object[])new ItemStack[0]);
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean isRecipeValid() {
        return !this.output.isEmpty() && FastStream.of(this.inputs).anyMatch(i -> !i.isEmpty());
    }

    public boolean loadPlanInputsToGrid(Container craftingGrid) {
        ItemStack[] inputs = this.getInputs();
        if (inputs.length != craftingGrid.getContainerSize()) {
            return false;
        }
        for (int i = 0; i < inputs.length; ++i) {
            craftingGrid.setItem(i, inputs[i]);
        }
        return true;
    }

    public static void savePlan(ItemStack stack, ItemStack[] inputs, ItemStack output) {
        ArrayList inputsList = FastStream.of((Object[])inputs).map(inputStack -> {
            ItemStack copy = inputStack.copy();
            if (copy.isDamageableItem()) {
                copy.setDamageValue(0);
            }
            return copy;
        }).toList();
        RecipePlanComponent component = new RecipePlanComponent(inputsList, output.copy());
        RecipePlanComponent.setComponent(stack, component);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag flag) {
        if (!this.isRecipeValid()) {
            tooltip.accept((Component)Component.translatable((String)"Damaged recipe!").withStyle(ChatFormatting.RED));
            return;
        }
        tooltip.accept((Component)Component.translatable((String)"projectred-expansion.tooltip.plan_result").append(": " + this.output.getDisplayName().getString()).withStyle(ChatFormatting.GRAY));
    }
}

