/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.api.SlottedHollowConnect;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.util.MicroMaterialRegistry;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.SlottedPart;
import codechicken.multipart.util.MultipartPlaceContext;
import codechicken.multipart.util.PartRayTraceResult;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.part.IConnectableCenterPart;
import mrtjp.projectred.expansion.TubeType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class BaseTubePart
extends BaseMultipart
implements IConnectableCenterPart,
NormalOcclusionPart,
SlottedPart,
SlottedHollowConnect {
    public static final Cuboid6[] fOBounds = new Cuboid6[7];
    public static final VoxelShape[] fOShapes = new VoxelShape[7];
    public static final VoxelShape[] fOShapeStates = new VoxelShape[64];
    public static int expandBounds = -1;
    protected static final int KEY_UPDATE = 0;
    private static final int KEY_CONN_MAP = 1;
    private static final int KEY_MATERIAL = 2;
    private static final int KEY_REMOVE_MATERIAL = 3;
    private final TubeType pipeType;
    private int connMap = 0;
    @Nullable
    private MicroMaterial material = null;

    public BaseTubePart(TubeType pipeType) {
        this.pipeType = pipeType;
    }

    @Nullable
    public MicroMaterial getMaterial() {
        return this.material;
    }

    public TubeType getPipeType() {
        return this.pipeType;
    }

    public int getConnMap() {
        return this.connMap;
    }

    public void setConnMap(int map) {
        this.connMap = map;
    }

    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("connMap", this.connMap);
        if (this.material != null) {
            tag.putString("mat", Objects.requireNonNull(this.material.getRegistryName()).toString());
        }
    }

    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        this.connMap = tag.getInt("connMap");
        this.material = tag.contains("mat") ? MicroMaterialRegistry.getMaterial((String)tag.getString("mat")) : null;
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.packedConnMap());
        packet.writeBoolean(this.material != null);
        if (this.material != null) {
            packet.writeRegistryIdDirect(MicroMaterialRegistry.microMaterials(), (Object)this.material);
        }
    }

    public MultipartType<?> getType() {
        return this.getPipeType().getPartType();
    }

    protected ItemStack getItem() {
        return this.getPipeType().makeStack();
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return this.getItem();
    }

    public void readDesc(MCDataInput packet) {
        this.connMap = packet.readUByte();
        if (packet.readBoolean()) {
            this.material = (MicroMaterial)packet.readRegistryIdDirect(MicroMaterialRegistry.microMaterials());
        }
    }

    public final void sendUpdate(Consumer<MCDataOutput> func) {
        this.sendUpdate(0, func);
    }

    public final void readUpdate(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    protected final void sendUpdate(int key, Consumer<MCDataOutput> func) {
        super.sendUpdate(p -> {
            p.writeByte(key);
            func.accept((MCDataOutput)p);
        });
    }

    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 0: {
                this.readDesc(packet);
                break;
            }
            case 1: {
                this.connMap = packet.readUByte();
                if (!this.useStaticRenderer()) break;
                this.tile().markRender();
                break;
            }
            case 2: {
                this.material = (MicroMaterial)packet.readRegistryIdDirect(MicroMaterialRegistry.microMaterials());
                if (!this.useStaticRenderer()) break;
                this.tile().markRender();
                break;
            }
            case 3: {
                this.material = null;
                if (!this.useStaticRenderer()) break;
                this.tile().markRender();
                break;
            }
        }
    }

    protected void sendConnUpdate() {
        this.sendUpdate(1, p -> p.writeByte(this.packedConnMap()));
    }

    protected void sendMaterialUpdate() {
        if (this.material == null) {
            this.sendUpdate(3, p -> {});
        } else {
            this.sendUpdate(2, p -> p.writeRegistryIdDirect(MicroMaterialRegistry.microMaterials(), (Object)this.material));
        }
    }

    public int packedConnMap() {
        return this.connMap & 0x3F | this.connMap >> 6 & 0x3F;
    }

    public boolean useStaticRenderer() {
        return Configurator.staticWires;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon() {
        return this.getPipeType().getTextures().get(0);
    }

    public boolean preparePlacement(MultipartPlaceContext context) {
        return true;
    }

    public SoundType getPlacementSound(UseOnContext context) {
        return SoundType.GLASS;
    }

    public void onPartChanged(@Nullable MultiPart part) {
        super.onPartChanged(part);
        if (!this.level().isClientSide) {
            this.updateOutward();
        }
    }

    public void onNeighborBlockChanged(BlockPos from) {
        super.onNeighborBlockChanged(from);
        if (!this.level().isClientSide) {
            this.updateOutside();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.level().isClientSide) {
            this.updateInsideAndOutside();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.level().isClientSide) {
            this.notifyAllExternals();
        }
    }

    public float getStrength(Player player, PartRayTraceResult hit) {
        if (this.material != null) {
            return Math.min(0.041666668f, this.material.getStrength(player));
        }
        return 0.041666668f;
    }

    public Iterable<ItemStack> getDrops() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        list.add(this.getItem());
        if (this.material != null) {
            list.add(ItemMicroBlock.create((int)0, (int)1, (MicroMaterial)this.material));
        }
        return list;
    }

    public VoxelShape getShape(CollisionContext context) {
        int m = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.maskConnects(s)) continue;
            m |= 1 << s;
        }
        return fOShapeStates[m];
    }

    public VoxelShape getBlockSupportShape() {
        return Shapes.empty();
    }

    public VoxelShape getOcclusionShape() {
        return fOShapes[expandBounds >= 0 ? expandBounds : 6];
    }

    public int getHoleSize(int side) {
        return 8;
    }

    public int getSlotMask() {
        return 64;
    }

    public ItemInteractionResult useItemOn(ItemStack held, Player player, PartRayTraceResult hit, InteractionHand hand) {
        return super.useItemOn(held, player, hit, hand);
    }

    public boolean discoverOpen(int s) {
        IConnectable ic;
        MultiPart part = this.tile().getSlottedPart(s);
        if (part == null) {
            return true;
        }
        if (part instanceof IConnectable && this.canConnectPart(ic = (IConnectable)part, s)) {
            return true;
        }
        expandBounds = s;
        boolean fits = this.tile().canReplacePart((MultiPart)this, (MultiPart)this);
        expandBounds = -1;
        return fits;
    }

    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
        if (internalChange || externalChange) {
            this.sendConnUpdate();
        }
    }

    static {
        double w = 0.25;
        BaseTubePart.fOBounds[6] = new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w);
        BaseTubePart.fOShapes[6] = VoxelShapeCache.getShape((Cuboid6)fOBounds[6]);
        for (int s = 0; s < 6; ++s) {
            BaseTubePart.fOBounds[s] = new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w).apply(Rotation.sideRotations[s].at(Vector3.CENTER));
            BaseTubePart.fOShapes[s] = VoxelShapeCache.getShape((Cuboid6)fOBounds[s]);
        }
        for (int m = 0; m < 64; ++m) {
            LinkedList<VoxelShape> shapes = new LinkedList<VoxelShape>();
            shapes.add(VoxelShapeCache.getShape((Cuboid6)fOBounds[6]));
            for (int s = 0; s < 6; ++s) {
                if ((m & 1 << s) == 0) continue;
                shapes.add(VoxelShapeCache.getShape((Cuboid6)fOBounds[s]));
            }
            BaseTubePart.fOShapeStates[m] = VoxelShapeCache.merge((ImmutableSet)ImmutableSet.copyOf(shapes));
        }
    }
}

