/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.lib.InventoryLib;
import net.covers1624.quack.util.LazyValue;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;

public class CraftingHelper {
    private final CraftingContainer craftingInventory = new CraftingHelperContainer();
    private final ResultContainer craftResultInventory = new ResultContainer();
    private final InventorySource inputSource;
    @Nullable
    private RecipeHolder<CraftingRecipe> recipe = null;
    private CraftingInput craftingInput = CraftingInput.EMPTY;
    private CraftingResult result = CraftingResult.EMPTY;

    public CraftingHelper(InventorySource inputSource) {
        this.inputSource = inputSource;
    }

    public void clear() {
        this.recipe = null;
        this.craftingInventory.clearContent();
        this.craftingInput = CraftingInput.EMPTY;
    }

    public void onInventoryChanged() {
        this.loadInputs();
        this.loadRecipe();
        this.loadOutput();
    }

    public CraftingContainer getCraftingInventory() {
        return this.craftingInventory;
    }

    public ResultContainer getCraftResultInventory() {
        return this.craftResultInventory;
    }

    public void loadInputs() {
        Container craftingMatrix = this.inputSource.getCraftingMatrix();
        for (int i = 0; i < 9; ++i) {
            this.craftingInventory.setItem(i, craftingMatrix.getItem(i).copy());
        }
        this.craftingInput = this.craftingInventory.asCraftInput();
    }

    public void loadRecipe() {
        this.recipe = this.inputSource.getWorld().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftingInput, this.inputSource.getWorld()).orElse(null);
        this.craftResultInventory.setItem(0, this.recipe == null ? ItemStack.EMPTY : ((CraftingRecipe)this.recipe.value()).assemble((RecipeInput)this.craftingInput, (HolderLookup.Provider)this.inputSource.getWorld().registryAccess()));
    }

    public void loadOutput() {
        this.result = this.craftFromStorageOrMatrix(true);
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public ItemStack getRecipeOutout() {
        return this.craftResultInventory.getItem(0);
    }

    public boolean canTake() {
        return this.result.isCraftable();
    }

    public boolean canTakeIntoStorage() {
        return this.canTake() && this.result.canStorageAcceptResults();
    }

    public int getMissingIngredientMask() {
        return this.result.missingIngredientMask;
    }

    public boolean onCraftedByPlayer(Player player, boolean leaveRemainingInGrid) {
        if (this.recipe == null) {
            return false;
        }
        CraftingResult result = this.craftFromStorageOrMatrix(false);
        if (!result.isCraftable()) {
            return false;
        }
        CommonHooks.setCraftingPlayer((Player)player);
        NonNullList remainingStacks = ((CraftingRecipe)this.recipe.value()).getRemainingItems((RecipeInput)this.craftingInput);
        CommonHooks.setCraftingPlayer(null);
        Container craftingGird = this.inputSource.getCraftingMatrix();
        Container storage = this.inputSource.getStorage();
        for (int i = 0; i < 9; ++i) {
            ItemStack remaining = (ItemStack)remainingStacks.get(i);
            if (remaining.isEmpty()) continue;
            if (leaveRemainingInGrid && craftingGird.getItem(i).isEmpty()) {
                craftingGird.setItem(i, remaining.split(remaining.getCount()));
                continue;
            }
            InventoryLib.injectItemStack((Container)storage, (ItemStack)remaining, (boolean)true);
            if (!remaining.isEmpty()) {
                player.addItem(remaining);
            }
            if (remaining.isEmpty()) continue;
            player.drop(remaining, false);
        }
        return true;
    }

    public boolean onCraftedIntoStorage() {
        CraftingResult result = this.craftFromStorage(false);
        if (!result.isCraftable() || !result.canFitResultsIntoStorage()) {
            return false;
        }
        NonNullList<ItemStack> allResults = result.getCopyOfAllResults();
        InventoryLib.injectAllItemStacks((Container)this.inputSource.getStorage(), allResults, (boolean)true);
        return true;
    }

    private CraftingResult craftFromStorageOrMatrix(boolean simulate) {
        CraftingResult result = this.craftFromStorage(simulate);
        if (!result.isCraftable() && this.inputSource.canConsumeFromCraftingMatrix()) {
            result = this.craftFromSource(this.inputSource.getCraftingMatrix(), simulate);
        }
        return result;
    }

    private CraftingResult craftFromStorage(boolean simulate) {
        return this.craftFromSource(this.inputSource.getStorage(), simulate);
    }

    private CraftingResult craftFromSource(Container source, boolean simulate) {
        if (this.recipe == null) {
            return CraftingResult.EMPTY;
        }
        if (!((CraftingRecipe)this.recipe.value()).matches((RecipeInput)this.craftingInput, this.inputSource.getWorld())) {
            return CraftingResult.EMPTY;
        }
        ItemStack result = ((CraftingRecipe)this.recipe.value()).assemble((RecipeInput)this.craftingInput, (HolderLookup.Provider)this.inputSource.getWorld().registryAccess());
        if (result.isEmpty()) {
            return CraftingResult.EMPTY;
        }
        if (simulate) {
            source = CraftingHelper.copyInventory(source);
        }
        int missingIngredientMask = 0;
        for (int i = 0; i < 9; ++i) {
            boolean isPresent;
            int slot = i;
            ItemStack previousInput = this.craftingInventory.getItem(slot);
            if (previousInput.isEmpty() || (isPresent = this.consumeIngredient(source, 0, input -> {
                if (!ItemStack.isSameItem((ItemStack)input, (ItemStack)previousInput)) {
                    return false;
                }
                this.craftingInventory.setItem(slot, input);
                CraftingInput tmpCraftingInput = this.craftingInventory.asCraftInput();
                boolean canStillCraft = ((CraftingRecipe)this.recipe.value()).matches((RecipeInput)tmpCraftingInput, this.inputSource.getWorld()) && ItemStack.isSameItem((ItemStack)result, (ItemStack)((CraftingRecipe)this.recipe.value()).assemble((RecipeInput)tmpCraftingInput, (HolderLookup.Provider)this.inputSource.getWorld().registryAccess()));
                this.craftingInventory.setItem(slot, previousInput);
                return canStillCraft;
            }))) continue;
            missingIngredientMask |= 1 << i;
        }
        if (missingIngredientMask != 0) {
            return CraftingResult.missingIngredients(missingIngredientMask);
        }
        return new CraftingResult(result, (NonNullList<ItemStack>)((CraftingRecipe)this.recipe.value()).getRemainingItems((RecipeInput)this.craftingInput), 0, simulate ? source : CraftingHelper.copyInventory(source));
    }

    private boolean consumeIngredient(Container storage, int startIndex, Predicate<ItemStack> matchFunc) {
        int i = startIndex;
        do {
            ItemStack taken;
            ItemStack stack;
            if ((stack = storage.getItem(i)).isEmpty() || !matchFunc.test(stack) || (taken = storage.removeItem(i, 1)).isEmpty()) continue;
            return true;
        } while ((i = (i + 1) % storage.getContainerSize()) != startIndex);
        return false;
    }

    private static Container copyInventory(Container inventory) {
        SimpleContainer copy = new SimpleContainer(inventory.getContainerSize());
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            copy.setItem(i, inventory.getItem(i).copy());
        }
        return copy;
    }

    private static class CraftingHelperContainer
    extends BaseContainer
    implements CraftingContainer {
        public CraftingHelperContainer() {
            super(9);
        }

        public int getWidth() {
            return 3;
        }

        public int getHeight() {
            return 3;
        }

        public NonNullList<ItemStack> getItems() {
            return NonNullList.copyOf((Collection)this.items);
        }
    }

    private static final class CraftingResult {
        private static final CraftingResult EMPTY = new CraftingResult(ItemStack.EMPTY, (NonNullList<ItemStack>)NonNullList.create(), 0, null);
        public final ItemStack outputStack;
        public final NonNullList<ItemStack> remainingItems;
        public final int missingIngredientMask;
        @Nullable
        public final Container remainingStorage;
        private final LazyValue<Boolean> canStorageAcceptResults = new LazyValue(this::canFitResultsIntoStorage);

        public CraftingResult(ItemStack outputStack, NonNullList<ItemStack> remainingItems, int missingIngredientMask, @Nullable Container remainingStorage) {
            this.outputStack = outputStack;
            this.remainingItems = remainingItems;
            this.missingIngredientMask = missingIngredientMask;
            this.remainingStorage = remainingStorage;
        }

        public boolean isCraftable() {
            return !this.outputStack.isEmpty() && this.missingIngredientMask == 0;
        }

        public boolean canStorageAcceptResults() {
            return (Boolean)this.canStorageAcceptResults.get();
        }

        public NonNullList<ItemStack> getCopyOfAllResults() {
            NonNullList allResults = NonNullList.withSize((int)(this.remainingItems.size() + 1), (Object)ItemStack.EMPTY);
            int i = 0;
            allResults.set(i++, (Object)this.outputStack.copy());
            for (ItemStack stack : this.remainingItems) {
                allResults.set(i++, (Object)stack.copy());
            }
            return allResults;
        }

        private boolean canFitResultsIntoStorage() {
            assert (this.remainingStorage != null);
            Container storage = CraftingHelper.copyInventory(this.remainingStorage);
            return InventoryLib.injectAllItemStacks((Container)storage, this.getCopyOfAllResults(), (boolean)true);
        }

        public static CraftingResult missingIngredients(int missingIngredientMask) {
            return new CraftingResult(ItemStack.EMPTY, (NonNullList<ItemStack>)NonNullList.create(), missingIngredientMask, null);
        }
    }

    public static interface InventorySource {
        public Container getCraftingMatrix();

        public Container getStorage();

        default public boolean canConsumeFromCraftingMatrix() {
            return false;
        }

        public Level getWorld();
    }
}

