/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mrtjp.projectred.api.BlockMover;
import mrtjp.projectred.api.MovementController;
import mrtjp.projectred.api.MovementDescriptor;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.expansion.ExpansionNetwork;
import mrtjp.projectred.expansion.MovementRegistry;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import mrtjp.projectred.expansion.client.MovingBlockSuppressorRenderer;
import mrtjp.projectred.lib.VecLib;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.LazyValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class MovementManager {
    private static final IdentityHashMap<ResourceKey<Level>, MovementManager> SERVER_INSTANCE = new IdentityHashMap();
    private static final IdentityHashMap<ResourceKey<Level>, MovementManager> CLIENT_INSTANCE = new IdentityHashMap();
    private static final int KEY_BULK_DESC = 0;
    private static final int KEY_NEW_STRUCT = 1;
    private static final int KEY_EXECUTE_MOVE = 2;
    private static final int KEY_CANCEL_MOVE = 3;
    private final ResourceKey<Level> dimension;
    private final Map<Integer, MovingStructure> structures = new HashMap<Integer, MovingStructure>();
    private final HashMap<ServerPlayer, Set<ChunkPos>> watchingPlayers = new HashMap();
    private final HashMap<ServerPlayer, Set<ChunkPos>> newWatchers = new HashMap();
    private int nextStructureId = 0;

    public static MovementManager getInstance(Level level) {
        IdentityHashMap<ResourceKey<Level>, MovementManager> map = level.isClientSide() ? CLIENT_INSTANCE : SERVER_INSTANCE;
        return map.computeIfAbsent((ResourceKey<Level>)level.dimension(), MovementManager::new);
    }

    @Nullable
    public static MovementManager getClientInstanceNullable() {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel == null) {
            return null;
        }
        return CLIENT_INSTANCE.get(clientLevel.dimension());
    }

    public MovementManager(ResourceKey<Level> dimension) {
        this.dimension = dimension;
        ProjectRedExpansion.LOGGER.debug("Created MovementManager for dimension {}", (Object)dimension.location());
    }

    private int getNextStructureId() {
        int next = this.nextStructureId;
        this.nextStructureId = (this.nextStructureId + 1) % Short.MAX_VALUE;
        return next;
    }

    public static void onChunkWatchEvent(ChunkWatchEvent.Watch event) {
        MovementManager.getInstance((Level)event.getLevel()).addChunkWatcher(event.getPos(), event.getPlayer());
    }

    public static void onChunkUnwatchEvent(ChunkWatchEvent.UnWatch event) {
        MovementManager.getInstance((Level)event.getLevel()).removeChunkWatcher(event.getPos(), event.getPlayer());
    }

    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            MovementManager.getInstance(level).cancelMovementsInChunk(level, event.getChunk().getPos());
        }
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        ProjectRedExpansion.LOGGER.debug("Level {} unloaded", (Object)event.getLevel());
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            MovementManager.getInstance(level).cancelMovementsOnUnload(level);
        }
    }

    public static void onLevelLoad(LevelEvent.Load event) {
        ProjectRedExpansion.LOGGER.debug("Level {} loaded", (Object)event.getLevel());
    }

    public static void onLevelTick(LevelTickEvent.Post event) {
        MovementManager.getInstance(event.getLevel()).tick(event.getLevel());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        MovementManager manager = MovementManager.getInstance((Level)level);
        if (manager.structures.isEmpty()) {
            return;
        }
        List<RenderType> renderTypes = List.of(RenderType.solid(), RenderType.cutout(), RenderType.cutoutMipped(), RenderType.translucent());
        RenderType renderType = null;
        for (RenderType type : renderTypes) {
            if (RenderLevelStageEvent.Stage.fromRenderType((RenderType)type) != event.getStage()) continue;
            renderType = type;
            break;
        }
        if (renderType == null) {
            return;
        }
        RandomSource random = RandomSource.create();
        Vec3 cam = event.getCamera().getPosition();
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        stack.mulPose(event.getModelViewMatrix());
        stack.translate(-cam.x, -cam.y, -cam.z);
        for (MovingStructure structure : manager.structures.values()) {
            Vector3 offset = structure.getRenderOffset(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            stack.pushPose();
            stack.translate(offset.x, offset.y, offset.z);
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            for (MovingRow row : structure.rows) {
                MovingRow.RowIterator it = row.iteratePreMove();
                while (it.hasNext()) {
                    BlockPos p = (BlockPos)it.next();
                    BlockState state = level.getBlockState(p);
                    if (!ItemBlockRenderTypes.getRenderLayers((BlockState)state).contains(renderType)) continue;
                    stack.pushPose();
                    stack.translate((float)p.getX(), (float)p.getY(), (float)p.getZ());
                    MovingBlockSuppressorRenderer.allowMovingRenderOnRenderThread = true;
                    Minecraft.getInstance().getBlockRenderer().renderBatched(state, p, (BlockAndTintGetter)level, stack, buffers.getBuffer(renderType), false, random, ModelData.EMPTY, renderType);
                    MovingBlockSuppressorRenderer.allowMovingRenderOnRenderThread = false;
                    stack.popPose();
                }
            }
            buffers.endBatch();
            stack.popPose();
        }
        stack.popPose();
    }

    private void addChunkWatcher(ChunkPos pos, ServerPlayer player) {
        this.newWatchers.computeIfAbsent(player, p -> new HashSet()).add(pos);
    }

    private void removeChunkWatcher(ChunkPos pos, ServerPlayer player) {
        Set<ChunkPos> watchingPlayersSet;
        Set<ChunkPos> newWatchersSet = this.newWatchers.get(player);
        if (newWatchersSet != null) {
            newWatchersSet.remove(pos);
        }
        if ((watchingPlayersSet = this.watchingPlayers.get(player)) != null) {
            watchingPlayersSet.remove(pos);
        }
    }

    private void cancelMovementsOnUnload(Level level) {
        ProjectRedExpansion.LOGGER.debug("Cancelling {} movements on level {} unload", (Object)this.structures.size(), (Object)level);
        for (MovingStructure structure : this.structures.values()) {
            structure.cancelMove(level);
        }
        this.structures.clear();
        this.nextStructureId = 0;
    }

    private void cancelMovementsInChunk(Level level, ChunkPos pos) {
        if (level.isClientSide) {
            return;
        }
        LinkedList<Integer> removed = new LinkedList<Integer>();
        for (MovingStructure structure : this.getStructuresIntersectingChunks(Collections.singletonList(pos))) {
            if (!structure.intersects(pos)) continue;
            ProjectRedExpansion.LOGGER.debug("Cancelling move {}", (Object)structure.toString());
            structure.cancelMove(level);
            this.sendCancelMove(structure, level);
            removed.add(structure.id);
        }
        for (Integer key : removed) {
            this.structures.remove(key);
        }
    }

    private void tick(Level level) {
        for (Map.Entry<Integer, MovingStructure> entry : this.structures.entrySet()) {
            entry.getValue().tickProgress(level);
        }
        if (level.isClientSide) {
            return;
        }
        for (Map.Entry<Integer, Object> entry : this.newWatchers.entrySet()) {
            ServerPlayer player = (ServerPlayer)entry.getKey();
            Set posSet = (Set)entry.getValue();
            this.sendDescriptionsOnWatch(player, posSet);
            this.watchingPlayers.computeIfAbsent(player, p -> new HashSet()).addAll(posSet);
        }
        this.newWatchers.clear();
        LinkedList<Integer> removed = new LinkedList<Integer>();
        for (Map.Entry<Integer, MovingStructure> e : this.structures.entrySet()) {
            MovingStructure structure = e.getValue();
            if (structure.getStatus() != MovementDescriptor.MovementStatus.PENDING_FINALIZATION) continue;
            ProjectRedExpansion.LOGGER.debug("Executing move {}", (Object)structure.toString());
            structure.executePreMove(level);
            this.sendExecuteMove(structure, level);
            structure.executePostMove(level);
            removed.add(e.getKey());
        }
        for (Integer key : removed) {
            this.structures.remove(key);
        }
    }

    public MovementDescriptor beginMove(Level level, Set<BlockPos> blocks, int dir, double speed) {
        if (blocks.size() > (Integer)Configurator.SERVER.frameMoveLimit.get()) {
            return InternalMovementInfo.failedMovement(blocks.size());
        }
        Set rows = VecLib.resolveRows(blocks, (int)(dir ^ 1));
        ArrayList<MovingRow> movingRows = new ArrayList<MovingRow>(rows.size());
        for (List row : rows) {
            movingRows.add(new MovingRow(row, dir));
        }
        MovingStructure structure = new MovingStructure(this.getNextStructureId(), speed, dir, movingRows);
        if (!structure.canMove(level)) {
            return structure;
        }
        this.structures.put(structure.id, structure);
        this.sendNewStructureDescription(structure, level);
        structure.beginMove(level);
        return structure;
    }

    public boolean hasNoMovingStructures() {
        return this.structures.isEmpty();
    }

    public InternalMovementInfo getMovementInfo(BlockPos pos) {
        for (MovingStructure structure : this.structures.values()) {
            if (!structure.contains(pos)) continue;
            return structure;
        }
        return InternalMovementInfo.NO_MOVEMENT_INFO;
    }

    private PacketCustom createPacket(int key, RegistryAccess registryAccess) {
        return new PacketCustom(ExpansionNetwork.NET_CHANNEL, 1, registryAccess).writeByte(key);
    }

    public void read(MCDataInput input, Level level) {
        short key = input.readUByte();
        switch (key) {
            case 0: {
                this.readStructureDescriptions(input, level);
                break;
            }
            case 1: {
                this.readNewStructure(input, level);
                break;
            }
            case 2: {
                this.readStructureExecution(input, level);
                break;
            }
            case 3: {
                this.readStructureCancellation(input, level);
                break;
            }
            default: {
                ProjectRedExpansion.LOGGER.warn("Movement manager received unknown key " + key);
            }
        }
    }

    private void readStructureDescriptions(MCDataInput input, Level level) {
        int count = input.readUShort();
        for (int i = 0; i < count; ++i) {
            MovingStructure structure = MovingStructure.fromDesc(input);
            if (this.structures.containsKey(structure.id)) {
                ProjectRedExpansion.LOGGER.debug("Client overwriting existing structure with id {}", (Object)structure.id);
            }
            this.structures.put(structure.id, structure);
        }
    }

    private void readNewStructure(MCDataInput input, Level level) {
        MovingStructure structure = MovingStructure.fromDesc(input);
        if (this.structures.containsKey(structure.id)) {
            ProjectRedExpansion.LOGGER.debug("Client overwriting existing structure with id {}", (Object)structure.id);
        }
        this.structures.put(structure.id, structure);
        structure.beginMove(level);
    }

    private void readStructureExecution(MCDataInput input, Level level) {
        int id = input.readUShort();
        MovingStructure structure = this.structures.get(id);
        if (structure == null) {
            ProjectRedExpansion.LOGGER.error("Pre-move executed for unknown structure id {}. Adding it for post-move.", (Object)id);
            return;
        }
        structure.executePreMove(level);
        structure.executePostMove(level);
        this.structures.remove(id);
    }

    private void readStructureCancellation(MCDataInput input, Level level) {
        int id = input.readUShort();
        MovingStructure structure = this.structures.get(id);
        if (structure == null) {
            ProjectRedExpansion.LOGGER.debug("Received cancellation for unknown structure id {}", (Object)id);
        } else {
            structure.cancelMove(level);
            this.structures.remove(id);
        }
    }

    private void sendDescriptionsOnWatch(ServerPlayer player, Set<ChunkPos> posSet) {
        Collection<MovingStructure> structs = this.getStructuresIntersectingChunks(posSet);
        if (structs.isEmpty()) {
            return;
        }
        PacketCustom packet = this.createPacket(0, player.registryAccess());
        packet.writeShort(structs.size());
        for (MovingStructure s : structs) {
            s.writeDesc((MCDataOutput)packet);
        }
        packet.sendToPlayer(player);
    }

    private void sendNewStructureDescription(MovingStructure structure, Level level) {
        PacketCustom packet = this.createPacket(1, level.registryAccess());
        structure.writeDesc((MCDataOutput)packet);
        for (ServerPlayer player : this.playersWatchingStructure(structure)) {
            packet.sendToPlayer(player);
        }
    }

    private void sendExecuteMove(MovingStructure structure, Level level) {
        PacketCustom packet = this.createPacket(2, level.registryAccess());
        packet.writeShort(structure.id);
        for (ServerPlayer player : this.playersWatchingStructure(structure)) {
            packet.sendToPlayer(player);
        }
    }

    private void sendCancelMove(MovingStructure structure, Level level) {
        PacketCustom packet = this.createPacket(3, level.registryAccess());
        packet.writeShort(structure.id);
        for (ServerPlayer player : this.playersWatchingStructure(structure)) {
            packet.sendToPlayer(player);
        }
    }

    private Collection<MovingStructure> getStructuresIntersectingChunks(Collection<ChunkPos> chunks) {
        LinkedList<MovingStructure> structures = new LinkedList<MovingStructure>();
        for (MovingStructure structure : this.structures.values()) {
            for (ChunkPos pos : chunks) {
                if (!structure.intersects(pos)) continue;
                structures.add(structure);
            }
        }
        return structures;
    }

    private Collection<ServerPlayer> playersWatchingStructure(MovingStructure structure) {
        LinkedList<ServerPlayer> players = new LinkedList<ServerPlayer>();
        HashSet<ChunkPos> chunks = structure.getChunkSet();
        block0: for (Map.Entry<ServerPlayer, Set<ChunkPos>> e : this.watchingPlayers.entrySet()) {
            for (ChunkPos pos : chunks) {
                if (!e.getValue().contains(pos)) continue;
                players.add(e.getKey());
                continue block0;
            }
        }
        return players;
    }

    private static class MovingStructure
    implements InternalMovementInfo {
        public final int id;
        private final double speed;
        private final int dir;
        private final List<MovingRow> rows;
        private final int totalSize;
        private final LazyValue<HashSet<ChunkPos>> intersectingChunks = new LazyValue(this::computeIntersectingChunks);
        private final LazyValue<HashSet<SectionPos>> renderChunks = new LazyValue(this::computeRenderChunks);
        private MovementDescriptor.MovementStatus status;
        private double progress;

        public MovingStructure(int id, double speed, int dir, List<MovingRow> rows, MovementDescriptor.MovementStatus status, double progress) {
            this.id = id;
            this.speed = speed;
            this.dir = dir;
            this.rows = Collections.unmodifiableList(rows);
            this.status = status;
            this.progress = progress;
            this.totalSize = FastStream.of(rows).intSum(r -> r.size);
        }

        public MovingStructure(int id, double speed, int dir, List<MovingRow> rows) {
            this(id, speed, dir, rows, MovementDescriptor.MovementStatus.PENDING_START, 0.0);
        }

        public void writeDesc(MCDataOutput output) {
            output.writeShort(this.id);
            output.writeDouble(this.speed);
            output.writeByte(this.dir);
            output.writeShort(this.rows.size());
            for (MovingRow row : this.rows) {
                output.writePos(row.pos);
                output.writeShort(row.size);
            }
            output.writeByte(this.status.ordinal());
            output.writeDouble(this.progress);
        }

        public static MovingStructure fromDesc(MCDataInput input) {
            int id = input.readUShort();
            double speed = input.readDouble();
            short dir = input.readUByte();
            int size = input.readUShort();
            ArrayList<MovingRow> rows = new ArrayList<MovingRow>(size);
            for (int i = 0; i < size; ++i) {
                rows.add(new MovingRow(input.readPos(), dir, input.readUShort()));
            }
            MovementDescriptor.MovementStatus status = MovementDescriptor.MovementStatus.values()[input.readUByte()];
            double progress = input.readDouble();
            return new MovingStructure(id, speed, dir, rows, status, progress);
        }

        public MovementDescriptor.MovementStatus getStatus() {
            return this.status;
        }

        public boolean isMoving() {
            return this.getStatus() == MovementDescriptor.MovementStatus.MOVING || this.getStatus() == MovementDescriptor.MovementStatus.PENDING_FINALIZATION;
        }

        public double getProgress() {
            return this.progress;
        }

        public int getSize() {
            return this.totalSize;
        }

        @Override
        public Vector3 getRenderOffset(float partialTicks) {
            double p = Math.min(this.progress + this.speed * (double)partialTicks, 1.0);
            return Vector3.fromBlockPos((BlockPos)BlockPos.ZERO.relative(Direction.values()[this.dir])).multiply(p);
        }

        public HashSet<ChunkPos> getChunkSet() {
            return (HashSet)this.intersectingChunks.get();
        }

        public boolean intersects(ChunkPos pos) {
            return ((HashSet)this.intersectingChunks.get()).contains(pos);
        }

        public boolean contains(BlockPos pos) {
            for (MovingRow row : this.rows) {
                if (!row.contains(pos)) continue;
                return true;
            }
            return false;
        }

        public void tickProgress(Level level) {
            assert (this.status == MovementDescriptor.MovementStatus.MOVING || this.status == MovementDescriptor.MovementStatus.PENDING_FINALIZATION);
            if (this.status == MovementDescriptor.MovementStatus.MOVING) {
                this.progress = Math.min(this.progress + this.speed, 1.0);
                FastStream.of(this.rows).forEach(r -> r.pushEntities(level, this.progress));
                if (this.progress >= 1.0) {
                    this.status = MovementDescriptor.MovementStatus.PENDING_FINALIZATION;
                }
            }
        }

        public boolean canMove(Level level) {
            for (MovingRow row : this.rows) {
                if (row.canMove(level)) continue;
                return false;
            }
            return true;
        }

        public void beginMove(Level level) {
            assert (this.status == MovementDescriptor.MovementStatus.PENDING_START);
            this.status = MovementDescriptor.MovementStatus.MOVING;
            FastStream.of(this.rows).forEach(r -> r.beginMove(level));
            if (level.isClientSide) {
                this.markChunksForRender();
            }
        }

        public void executePreMove(Level level) {
            FastStream.of(this.rows).forEach(r -> r.moveBlocks(level));
        }

        public void executePostMove(Level level) {
            FastStream.of(this.rows).forEach(r -> r.postMove(level));
            FastStream.of(this.rows).forEach(r -> r.endMove(level));
            HashSet changes = new HashSet();
            FastStream.of(this.rows).forEach(r -> r.addNeighborChanges(level, changes));
            for (BlockPos pos : changes) {
                BlockState state = level.getBlockState(pos);
                state.updateNeighbourShapes((LevelAccessor)level, pos, 0, 0);
                state.updateIndirectNeighbourShapes((LevelAccessor)level, pos, 0, 0);
                level.neighborChanged(pos, Blocks.AIR, pos);
            }
            this.markBlocksForLightUpdate(level);
            if (level.isClientSide) {
                this.markChunksForRender();
            }
            for (ChunkPos p : this.getChunkSet()) {
                level.getChunk(p.x, p.z).setUnsaved(true);
            }
            this.status = MovementDescriptor.MovementStatus.FINISHED;
        }

        public void cancelMove(Level level) {
            assert (this.status == MovementDescriptor.MovementStatus.MOVING || this.status == MovementDescriptor.MovementStatus.PENDING_FINALIZATION);
            this.status = MovementDescriptor.MovementStatus.CANCELLED;
        }

        @OnlyIn(value=Dist.CLIENT)
        private void markChunksForRender() {
            FastStream.of((Iterable)((Iterable)this.renderChunks.get())).forEach(p -> Minecraft.getInstance().levelRenderer.setSectionDirty(p.x(), p.y(), p.z(), true));
        }

        private void markBlocksForLightUpdate(Level level) {
            FastStream.of(this.rows).forEach(r -> r.forEachAll(p -> level.getLightEngine().checkBlock(p)));
        }

        private HashSet<ChunkPos> computeIntersectingChunks() {
            HashSet<ChunkPos> chunks = new HashSet<ChunkPos>();
            FastStream.of(this.rows).forEach(r -> r.forEachAll(p -> chunks.add(new ChunkPos(p))));
            return chunks;
        }

        private HashSet<SectionPos> computeRenderChunks() {
            HashSet<SectionPos> chunks = new HashSet<SectionPos>();
            FastStream.of(this.rows).forEach(r -> r.forEachAll(p -> {
                for (int s = 0; s < 6; ++s) {
                    chunks.add(SectionPos.of((BlockPos)p.relative(Direction.values()[s])));
                }
            }));
            return chunks;
        }

        public String toString() {
            return "MovingStructure{id=" + this.id + ", speed=" + this.speed + ", dir=" + this.dir + ", progress=" + this.progress + ", rows=" + String.valueOf(this.rows) + "}";
        }
    }

    private static final class MovingRow {
        public final BlockPos pos;
        public final int dir;
        public final int size;

        private MovingRow(BlockPos pos, int dir, int size) {
            this.pos = pos;
            this.dir = dir;
            this.size = size;
        }

        private MovingRow(List<BlockPos> row, int dir) {
            this.pos = row.get(0).relative(Direction.values()[dir]);
            this.dir = dir;
            this.size = row.size() + 1;
        }

        public boolean contains(BlockPos pos) {
            BlockPos p2;
            BlockPos p1 = VecLib.projectDir((BlockPos)this.pos, (int)this.dir);
            if (!p1.equals((Object)(p2 = VecLib.projectDir((BlockPos)pos, (int)this.dir)))) {
                return false;
            }
            int a1 = VecLib.rejectComponent((BlockPos)this.pos, (int)this.dir);
            int a2 = VecLib.rejectComponent((BlockPos)this.pos.relative(Direction.values()[this.dir ^ 1], this.size - 1), (int)this.dir);
            int b = VecLib.rejectComponent((BlockPos)pos, (int)this.dir);
            return Math.min(a1, a2) <= b && b <= Math.max(a1, a2);
        }

        public boolean canMove(Level level) {
            if (!level.isLoaded(this.pos)) {
                return false;
            }
            BlockState state = level.getBlockState(this.pos);
            if (!state.isAir() && !state.canBeReplaced()) {
                return false;
            }
            RowIterator it = this.iteratePreMove();
            while (it.hasNext()) {
                BlockPos pos = (BlockPos)it.next();
                BlockMover mover = MovementRegistry.getMover(level, pos);
                if (!mover.canMove(level, pos)) {
                    return false;
                }
                MovementController controller = MovementRegistry.getMovementController(level, pos);
                if (controller == null || controller.isMovable(level, pos, Direction.values()[this.dir])) continue;
                return false;
            }
            return true;
        }

        public void beginMove(Level level) {
            if (!level.isClientSide) {
                this.forEachPreMove(p -> {
                    MovementController controller = MovementRegistry.getMovementController(level, p);
                    if (controller != null) {
                        controller.onMovementStarted(level, p, Direction.values()[this.dir]);
                    }
                });
            }
        }

        public void pushEntities(Level level, double progress) {
        }

        public void moveBlocks(Level level) {
            this.forEachPreMove(p -> {
                BlockMover mover = MovementRegistry.getMover(level, p);
                mover.move(level, p, Direction.values()[this.dir]);
            });
        }

        public void postMove(Level level) {
            this.forEachPostMove(p -> {
                BlockMover mover = MovementRegistry.getMover(level, p);
                mover.postMove(level, p);
            });
        }

        public void endMove(Level level) {
            if (!level.isClientSide) {
                this.forEachPostMove(p -> {
                    MovementController controller = MovementRegistry.getMovementController(level, this.pos);
                    if (controller != null) {
                        controller.onMovementFinished(level, this.pos);
                    }
                });
            }
        }

        public void addNeighborChanges(Level level, Set<BlockPos> changes) {
            this.forEachAll(p -> {
                changes.add((BlockPos)p);
                for (int s = 0; s < 6; ++s) {
                    changes.add(p.relative(Direction.values()[s]));
                }
            });
        }

        private RowIterator iteratePreMove() {
            return new RowIterator(1, this.size);
        }

        private RowIterator iteratePostMove() {
            return new RowIterator(0, this.size - 1);
        }

        private RowIterator iterateAll() {
            return new RowIterator(0, this.size);
        }

        private void forEachPreMove(Consumer<BlockPos> action) {
            RowIterator it = this.iteratePreMove();
            while (it.hasNext()) {
                action.accept((BlockPos)it.next());
            }
        }

        private void forEachPostMove(Consumer<BlockPos> action) {
            RowIterator it = this.iteratePostMove();
            while (it.hasNext()) {
                action.accept((BlockPos)it.next());
            }
        }

        private void forEachAll(Consumer<BlockPos> action) {
            RowIterator it = this.iterateAll();
            while (it.hasNext()) {
                action.accept((BlockPos)it.next());
            }
        }

        public String toString() {
            return "MovingRow[pos={" + this.pos.getX() + ", " + this.pos.getY() + ", " + this.pos.getZ() + "}, size=" + this.size + "]";
        }

        private class RowIterator
        implements Iterator<BlockPos> {
            private final int size;
            private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
            private int i;

            public RowIterator(int start, int size) {
                this.size = size;
                this.i = start;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            @Override
            public BlockPos next() {
                return this.mpos.set((Vec3i)MovingRow.this.pos).move(Direction.values()[MovingRow.this.dir].getOpposite(), this.i++);
            }
        }
    }

    public static interface InternalMovementInfo
    extends MovementDescriptor {
        public static final InternalMovementInfo NO_MOVEMENT_INFO = new InternalMovementInfo(){

            @Override
            public Vector3 getRenderOffset(float partialTicks) {
                return Vector3.ZERO;
            }

            public MovementDescriptor.MovementStatus getStatus() {
                return MovementDescriptor.MovementStatus.UNKNOWN;
            }

            public boolean isMoving() {
                return false;
            }

            public double getProgress() {
                return 0.0;
            }

            public int getSize() {
                return 0;
            }
        };

        private static InternalMovementInfo failedMovement(final int size) {
            return new InternalMovementInfo(){

                @Override
                public Vector3 getRenderOffset(float partialTicks) {
                    return Vector3.ZERO;
                }

                public MovementDescriptor.MovementStatus getStatus() {
                    return MovementDescriptor.MovementStatus.FAILED;
                }

                public boolean isMoving() {
                    return false;
                }

                public double getProgress() {
                    return 0.0;
                }

                public int getSize() {
                    return size;
                }
            };
        }

        public Vector3 getRenderOffset(float var1);
    }
}

