/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.client.particle.BaseActionParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;

public class PneumaticSmokeParticle
extends BaseActionParticle {
    public static ResourceLocation SMOKE_PARTICLE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"textures/particle/smoke.png");
    public static TextureAtlasSprite SMOKE_PARTICLE_SPRITE;
    private static ParticleRenderType PARTICLE_TYPE_SMOKE;
    private final List<Vector3> points = new LinkedList<Vector3>();

    public PneumaticSmokeParticle(ClientLevel pLevel, List<Vector3> points) {
        super(pLevel, points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
        this.points.addAll(points);
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.setColor(EnumColour.LIGHT_GRAY.rF(), EnumColour.LIGHT_GRAY.gF(), EnumColour.LIGHT_GRAY.bF());
        this.setAlpha(1.0f);
        this.setLifetime(100);
        this.gravity = 0.0f;
        Cuboid6 bounds = new Cuboid6(this.x, this.y, this.z, this.x, this.y, this.z);
        for (Vector3 point : points) {
            bounds.enclose(point);
        }
        this.setBoundingBox(bounds.aabb());
    }

    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.runActions(pPartialTicks);
        Translation t = new Translation(-pRenderInfo.getPosition().x, -pRenderInfo.getPosition().y, -pRenderInfo.getPosition().z);
        TransformingVertexConsumer vc = new TransformingVertexConsumer(pBuffer, (Transformation)t);
        Vector3 lastPoint = null;
        for (Vector3 point : this.points) {
            if (lastPoint != null) {
                this.drawSmokeLine((VertexConsumer)vc, lastPoint, point, pPartialTicks);
            }
            lastPoint = point;
        }
    }

    private void drawSmokeLine(VertexConsumer buffer, Vector3 p1, Vector3 p2, float f) {
        Transformation[] transforms;
        Vector3 dp = p2.copy().subtract(p1);
        double width = 0.25;
        double length = dp.mag();
        Vector3 quadPoint = new Vector3(0.0, length, 0.0);
        double angle = quadPoint.angle(dp);
        Vector3 axis = quadPoint.copy().crossProduct(dp).normalize();
        Rotation t = new Rotation(angle, axis);
        float slideProg = ((float)this.age + f) / (float)this.lifetime * 8.0f;
        float u1 = 0.0f;
        float v1 = slideProg;
        float u2 = 1.0f;
        float v2 = v1 + (float)length;
        int j = this.getLightColor(f);
        for (Transformation tf : transforms = new Transformation[]{new TransformationList(new Transformation[]{t, p1.translation()}), new TransformationList(new Transformation[]{Rotation.quarterRotations[1], t, p1.translation()})}) {
            TransformingVertexConsumer bc = new TransformingVertexConsumer(buffer, tf);
            bc.addVertex((float)(-width), 0.0f, 0.0f).setUv(u1, v2).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
            bc.addVertex((float)(-width), (float)length, 0.0f).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
            bc.addVertex((float)width, (float)length, 0.0f).setUv(u2, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
            bc.addVertex((float)width, 0.0f, 0.0f).setUv(u2, v2).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        }
    }

    public ParticleRenderType getRenderType() {
        return PARTICLE_TYPE_SMOKE;
    }

    public static void onTextureStitchEvent(TextureAtlasStitchedEvent event) {
        if (!event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        SMOKE_PARTICLE_SPRITE = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)"particle/smoke"));
    }

    static {
        PARTICLE_TYPE_SMOKE = new ParticleRenderType(){

            public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SMOKE_PARTICLE_LOCATION);
                RenderSystem.enableBlend();
                RenderSystem.disableCull();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            }

            public String toString() {
                return "PARTICLE_TYPE_SMOKE";
            }
        };
    }
}

