/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.inventory.container.CCLMenuType;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.expansion.tile.LowLoadPoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BaseMachineBlockEntity
extends LowLoadPoweredBlockEntity {
    private boolean isWorking = false;
    private boolean isCharged = false;
    private int remainingWork = 0;
    private int totalWork = 0;

    public BaseMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        tag.putInt("remaining_work", this.remainingWork);
        tag.putInt("total_work", this.totalWork);
        tag.putBoolean("working", this.isWorking);
        tag.putBoolean("charging", this.isCharged);
    }

    @Override
    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.remainingWork = tag.getInt("remaining_work");
        this.totalWork = tag.getInt("total_work");
        this.isWorking = tag.getBoolean("working");
        this.isCharged = tag.getBoolean("charging");
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).setValue((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.isCharged))).setValue((Property)ProjectRedBlock.WORKING, (Comparable)Boolean.valueOf(this.isWorking));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getLevel().isClientSide) {
            return;
        }
        this.isCharged = this.canConductorWork();
        if (!this.isWorking && this.canStartOrContinueWork()) {
            this.isWorking = true;
            this.remainingWork = this.totalWork = this.startWork();
        }
        if (!this.canStartOrContinueWork()) {
            this.isWorking = false;
            this.remainingWork = 0;
            this.totalWork = 0;
        } else {
            int workDone = this.tickWork(this.remainingWork);
            this.remainingWork -= workDone;
            if (this.remainingWork <= 0) {
                this.isWorking = false;
                this.remainingWork = 0;
                this.totalWork = 0;
                this.finishWork();
            }
        }
        BlockState state = this.getBlockState();
        if (this.isCharged != (Boolean)state.getValue((Property)ProjectRedBlock.CHARGED) || this.isWorking != (Boolean)state.getValue((Property)ProjectRedBlock.WORKING)) {
            this.pushBlockState();
        }
    }

    public ItemInteractionResult useItemOn(ItemStack held, Player player, InteractionHand hand, BlockHitResult hit) {
        IScrewdriver screwdriver;
        Item item = held.getItem();
        if (item instanceof IScrewdriver && (screwdriver = (IScrewdriver)item).canUse(player, hand)) {
            if (!this.level.isClientSide) {
                this.rotateBlock();
                screwdriver.damageScrewdriver(player, hand);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (!this.level.isClientSide) {
            this.openGui(player);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
    }

    private void rotateBlock() {
        BlockState state = this.getLevel().getBlockState(this.getBlockPos());
        int r = (Integer)state.getValue((Property)ProjectRedBlock.ROTATION);
        int newRotation = (r + 1) % 4;
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)ProjectRedBlock.ROTATION, (Comparable)Integer.valueOf(newRotation)));
    }

    private void openGui(Player player) {
        CCLMenuType.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider(this::createMenu, (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2, Player var3);

    public int getRemainingWork() {
        return this.remainingWork;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    protected abstract boolean canStartOrContinueWork();

    protected abstract int startWork();

    protected abstract int tickWork(int var1);

    protected abstract void finishWork();
}

