/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks;

import com.google.common.collect.Sets;
import com.kyanite.deeperdarker.DeeperDarker;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.portal.frame.VanillaPortalAreaHelper;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class OthersidePortalFrameTester
extends VanillaPortalAreaHelper {
    public PortalFrameTester init(class_1936 world, class_2338 blockPos, class_2350.class_2351 axis, class_2248 ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.world = world;
        this.axis = axis;
        this.lowerCorner = this.getLowerCorner(blockPos, axis, class_2350.class_2351.field_11052);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.height = 1;
            this.width = 1;
        } else {
            this.width = this.getSize(axis, DeeperDarker.CONFIG.server.portalMinWidth(), DeeperDarker.CONFIG.server.portalMaxWidth());
            if (this.width > 0) {
                this.height = this.getSize(class_2350.class_2351.field_11052, DeeperDarker.CONFIG.server.portalMinHeight(), DeeperDarker.CONFIG.server.portalMaxHeight());
                if (this.checkForValidFrame(axis, class_2350.class_2351.field_11052, this.width, this.height)) {
                    this.countExistingPortalBlocks(axis, class_2350.class_2351.field_11052, this.width, this.height);
                } else {
                    this.lowerCorner = null;
                    this.height = 1;
                    this.width = 1;
                }
            }
        }
        return this;
    }

    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return this.width >= DeeperDarker.CONFIG.server.portalMinWidth() && this.height >= DeeperDarker.CONFIG.server.portalMinHeight();
    }

    public Optional<PortalFrameTester> getOrEmpty(class_1936 worldAccess, class_2338 blockPos, Predicate<PortalFrameTester> predicate, class_2350.class_2351 axis, class_2248 ... foundations) {
        Optional<PortalFrameTester> optional = Optional.of(new OthersidePortalFrameTester().init(worldAccess, blockPos, axis, foundations)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(new OthersidePortalFrameTester().init(worldAccess, blockPos, axis2, foundations)).filter(predicate);
    }

    public void createPortal(class_1937 world, class_2338 pos, class_2680 frameBlock, class_2350.class_2351 axis) {
        int i;
        class_2350.class_2351 rotatedAxis = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        for (i = -1; i < DeeperDarker.CONFIG.server.generatedPortalHeight() + 1; ++i) {
            world.method_8501(pos.method_10086(i).method_30513(axis, -1), frameBlock);
            world.method_8501(pos.method_10086(i).method_30513(axis, DeeperDarker.CONFIG.server.generatedPortalWidth()), frameBlock);
            if (i < 0) continue;
            for (int j = 0; j < DeeperDarker.CONFIG.server.generatedPortalWidth(); ++j) {
                this.fillAirAroundPortal(world, pos.method_10086(i).method_30513(axis, -1).method_30513(rotatedAxis, -1));
                this.fillAirAroundPortal(world, pos.method_10086(i).method_30513(axis, -1).method_30513(rotatedAxis, 1));
            }
        }
        for (i = -1; i < DeeperDarker.CONFIG.server.generatedPortalWidth() + 1; ++i) {
            world.method_8501(pos.method_10086(-1).method_30513(axis, i), frameBlock);
            world.method_8501(pos.method_10086(DeeperDarker.CONFIG.server.generatedPortalHeight()).method_30513(axis, i), frameBlock);
        }
        for (i = 0; i < DeeperDarker.CONFIG.server.generatedPortalWidth(); ++i) {
            this.placeLandingPad(world, pos.method_10086(-1).method_30513(axis, i).method_30513(rotatedAxis, -1), frameBlock);
            this.placeLandingPad(world, pos.method_10086(-1).method_30513(axis, i).method_30513(rotatedAxis, 1), frameBlock);
        }
        this.lowerCorner = pos;
        this.width = DeeperDarker.CONFIG.server.generatedPortalWidth();
        this.height = DeeperDarker.CONFIG.server.generatedPortalHeight();
        this.axis = axis;
        this.world = world;
        this.foundPortalBlocks = this.width * this.height;
        this.lightPortal(frameBlock.method_26204());
    }

    public boolean isValidFrame() {
        return this.lowerCorner != null && this.width >= DeeperDarker.CONFIG.server.portalMinWidth() && this.width <= DeeperDarker.CONFIG.server.portalMaxWidth() && this.height >= DeeperDarker.CONFIG.server.portalMinHeight() && this.height <= DeeperDarker.CONFIG.server.portalMaxHeight();
    }

    protected class_2338 getLowerCorner(class_2338 blockPos, class_2350.class_2351 axis1, class_2350.class_2351 axis2) {
        if (!OthersidePortalFrameTester.validStateInsidePortal(this.world.method_8320(blockPos), this.VALID_FRAME)) {
            return null;
        }
        return this.getLimitForAxis(this.getLimitForAxis(blockPos, axis1), axis2);
    }

    protected class_2338 getLimitForAxis(class_2338 blockPos, class_2350.class_2351 axis) {
        if (blockPos == null || axis == null) {
            return null;
        }
        int offset = 1;
        while (OthersidePortalFrameTester.validStateInsidePortal(this.world.method_8320(blockPos.method_30513(axis, -offset)), this.VALID_FRAME)) {
            if (++offset > 20) {
                return null;
            }
            if ((!axis.equals((Object)class_2350.class_2351.field_11052) || blockPos.method_10264() - offset >= this.world.method_31607()) && (axis.equals((Object)class_2350.class_2351.field_11052) || this.world.method_8621().method_11952(blockPos.method_30513(axis, -offset)))) continue;
            return null;
        }
        return blockPos.method_30513(axis, -(offset - 1));
    }

    protected int getSize(class_2350.class_2351 axis, int minSize, int maxSize) {
        for (int i = 1; i <= maxSize; ++i) {
            class_2680 blockState = this.world.method_8320(this.lowerCorner.method_30513(axis, i));
            if (OthersidePortalFrameTester.validStateInsidePortal(blockState, this.VALID_FRAME)) continue;
            if (!this.VALID_FRAME.contains(blockState.method_26204())) break;
            return i >= minSize ? i : 0;
        }
        return 0;
    }

    public static boolean validStateInsidePortal(class_2680 blockState, HashSet<class_2248> foundations) {
        return PortalFrameTester.validStateInsidePortal((class_2680)blockState, foundations) || blockState.method_27852(class_2246.field_37569);
    }
}

