/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.items;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.network.LinkTransmitterPacket;
import com.kyanite.deeperdarker.network.UnlinkTransmitterPacket;
import com.kyanite.deeperdarker.util.DDTags;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SculkTransmitterItem
extends class_1792 {
    public static final Map<class_1799, Pair<CooldownType, Long>> COOLDOWNS = new HashMap<class_1799, Pair<CooldownType, Long>>();

    public SculkTransmitterItem(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1937 level = pContext.method_8045();
        class_1657 player = pContext.method_8036();
        class_1799 stack = pContext.method_8041();
        class_2338 clickedPos = pContext.method_8037();
        return SculkTransmitterItem.transmit(level, player, stack, clickedPos, pContext.method_20287());
    }

    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pUsedHand) {
        if (SculkTransmitterItem.isLinked(pPlayer.method_5998(pUsedHand))) {
            SculkTransmitterItem.transmit(pLevel, pPlayer, pPlayer.method_5998(pUsedHand), null, pUsedHand);
        }
        return super.method_7836(pLevel, pPlayer, pUsedHand);
    }

    public static class_1269 transmit(class_1937 level, class_1657 player, class_1799 transmitter, @Nullable class_2338 clickedPos, @Nullable class_1268 pUsedHand) {
        class_2338 linkedPos;
        if (player.method_18276()) {
            return SculkTransmitterItem.handleLink(level, player, transmitter, clickedPos, pUsedHand);
        }
        if (level.method_8608()) {
            return class_1269.method_29236((boolean)false);
        }
        Optional<class_4208> globalLinkedPos = SculkTransmitterItem.readGlobalPosition(transmitter.method_7948());
        if (globalLinkedPos.isEmpty()) {
            return class_1269.field_5814;
        }
        class_3218 serverLevel = level.method_8503().method_3847(globalLinkedPos.get().method_19442());
        if (!serverLevel.method_8477(linkedPos = globalLinkedPos.get().method_19446())) {
            class_1923 chunkPos = new class_1923(linkedPos);
            serverLevel.method_14178().method_17297(class_3230.field_14032, chunkPos, 1, (Object)chunkPos);
        }
        if (!SculkTransmitterItem.canConnect((class_1937)serverLevel, linkedPos)) {
            SculkTransmitterItem.actionBarMessage(level, player, "not_found", DDSounds.TRANSMITTER_ERROR);
            SculkTransmitterItem.formConnection((class_1937)serverLevel, transmitter, null);
            return class_1269.field_5814;
        }
        serverLevel.method_43276(class_5712.field_28725, player.method_24515(), class_5712.class_7397.method_43285((class_1297)player));
        serverLevel.method_8320(linkedPos).method_26174((class_1937)serverLevel, player, pUsedHand == null ? class_1268.field_5808 : pUsedHand, new class_3965(linkedPos.method_46558(), class_2350.field_11035, linkedPos, false));
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.field_13987.method_14364((class_2596)new class_2767((class_6880)new class_6880.class_6881((Object)DDSounds.TRANSMITTER_OPEN), class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f, level.method_8409().method_43055()));
        }
        return class_1269.method_29236((boolean)false);
    }

    protected static class_1269 handleLink(class_1937 level, class_1657 player, class_1799 transmitter, @Nullable class_2338 clickedPos, @Nullable class_1268 pUsedHand) {
        boolean connect;
        boolean bl = connect = clickedPos != null && SculkTransmitterItem.canConnect(level, clickedPos);
        if (!level.method_8608()) {
            return connect ? class_1269.field_5812 : class_1269.field_5814;
        }
        if (!SculkTransmitterItem.isLinked(transmitter) && clickedPos != null && !SculkTransmitterItem.canConnect(level, clickedPos)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"block.deeperdarker.not_transmittable"), true);
            player.method_5783(DDSounds.TRANSMITTER_ERROR, 1.0f, 1.0f);
            return class_1269.field_5814;
        }
        int slot = SculkTransmitterItem.getSlot(player, transmitter);
        int seconds = DeeperDarker.CONFIG.client.sculkTransmitterLinkCooldownSeconds();
        if (connect) {
            if (!SculkTransmitterItem.isLinked(transmitter) || SculkTransmitterItem.checkCooldown(transmitter, CooldownType.LINK, seconds)) {
                ClientPlayNetworking.send((FabricPacket)new LinkTransmitterPacket(slot, clickedPos));
                COOLDOWNS.remove(transmitter);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)(DDItems.SCULK_TRANSMITTER.method_7876() + ".link_confirm"), (Object[])new Object[]{class_310.method_1551().field_1690.field_1904.method_16007()}), true);
                COOLDOWNS.put(transmitter, (Pair<CooldownType, Long>)Pair.of((Object)((Object)CooldownType.LINK), (Object)System.nanoTime()));
            }
            return class_1269.field_5812;
        }
        if (SculkTransmitterItem.checkCooldown(transmitter, CooldownType.UNLINK, seconds)) {
            ClientPlayNetworking.send((FabricPacket)new UnlinkTransmitterPacket(slot));
            COOLDOWNS.remove(transmitter);
        } else {
            player.method_7353((class_2561)class_2561.method_43469((String)(DDItems.SCULK_TRANSMITTER.method_7876() + ".unlink_confirm"), (Object[])new Object[]{class_310.method_1551().field_1690.field_1904.method_16007()}), true);
            COOLDOWNS.put(transmitter, (Pair<CooldownType, Long>)Pair.of((Object)((Object)CooldownType.UNLINK), (Object)System.nanoTime()));
        }
        return class_1269.field_5814;
    }

    private static boolean checkCooldown(class_1799 stack, CooldownType cooldownType, int maxSeconds) {
        if (maxSeconds == 0) {
            return true;
        }
        if (!COOLDOWNS.containsKey(stack)) {
            return false;
        }
        Pair<CooldownType, Long> pair = COOLDOWNS.get(stack);
        return pair.getFirst() == cooldownType && System.nanoTime() - (Long)pair.getSecond() < (long)maxSeconds * 1000000000L;
    }

    private static int getSlot(class_1657 player, class_1799 stack) {
        if (player.method_6079() == stack) {
            return player.method_31548().field_7547.size() + player.method_31548().field_7548.size();
        }
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            if (player.method_31548().field_7547.get(i) != stack) continue;
            return i;
        }
        return -1;
    }

    public static boolean isLinked(class_1799 stack) {
        return SculkTransmitterItem.readGlobalPosition(stack.method_7948()).isPresent();
    }

    private static boolean canConnect(class_1937 level, class_2338 target) {
        return level.method_8320(target).method_26164(DDTags.Blocks.TRANSMITTABLE);
    }

    public static void formConnection(class_1937 level, class_1799 stack, class_2338 pos) {
        class_2487 tag = stack.method_7948();
        if (pos == null) {
            stack.method_7983("block");
            SculkTransmitterItem.removeGlobalPosition(stack.method_7948());
            return;
        }
        tag.method_10582("block", level.method_8320(pos).method_26204().method_9539());
        SculkTransmitterItem.writeGlobalPosition(tag, class_4208.method_19443((class_5321)level.method_27983(), (class_2338)pos));
    }

    private static Optional<class_5321<class_1937>> getDimension(class_2487 tag) {
        if (!tag.method_10545("dimension")) {
            return Optional.empty();
        }
        return class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("dimension")).result();
    }

    public static Optional<class_4208> readGlobalPosition(class_2487 tag) {
        Optional<class_5321<class_1937>> dimension = SculkTransmitterItem.getDimension(tag);
        if (tag.method_10545("block_pos") && dimension.isPresent()) {
            class_2338 blockPos = class_2512.method_10691((class_2487)tag.method_10562("block_pos"));
            return Optional.of(class_4208.method_19443(dimension.get(), (class_2338)blockPos));
        }
        return Optional.empty();
    }

    public static void writeGlobalPosition(class_2487 tag, class_4208 pos) {
        tag.method_10566("block_pos", (class_2520)class_2512.method_10692((class_2338)pos.method_19446()));
        class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, (Object)pos.method_19442()).resultOrPartial(arg_0 -> ((Logger)DeeperDarker.LOGGER).error(arg_0)).ifPresent(dimensionTag -> tag.method_10566("dimension", dimensionTag));
    }

    public static void removeGlobalPosition(class_2487 tag) {
        tag.method_10551("block_pos");
        tag.method_10551("dimension");
    }

    public static void actionBarMessage(class_1937 level, class_1657 player, String key, class_3414 sound) {
        if (level.method_8608()) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)("block.deeperdarker." + key)), true);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (sound != null) {
                serverPlayer.field_13987.method_14364((class_2596)new class_2767((class_6880)new class_6880.class_6881((Object)sound), class_3419.field_15248, player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f, level.method_8409().method_43055()));
            }
        }
    }

    public void method_7851(class_1799 pStack, class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
        if (SculkTransmitterItem.isLinked(pStack)) {
            class_4208 pos = SculkTransmitterItem.readGlobalPosition(pStack.method_7948()).get();
            pTooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltips.deeperdarker.sculk_transmitter.linked", (Object[])new Object[]{class_2561.method_43471((String)pStack.method_7969().method_10558("block"))}).method_27692(class_124.field_1080));
            pTooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltips.deeperdarker.sculk_transmitter.location", (Object[])new Object[]{pos.method_19446().method_10263(), pos.method_19446().method_10264(), pos.method_19446().method_10260()}).method_27692(class_124.field_1080));
            if (pIsAdvanced.method_8035()) {
                pTooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltips.deeperdarker.sculk_transmitter.location_advanced", (Object[])new Object[]{pos.method_19442().method_29177().toString()}).method_27692(class_124.field_1063));
            }
        } else {
            pTooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltips.deeperdarker.sculk_transmitter.not_linked").method_27692(class_124.field_1080));
        }
        super.method_7851(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public static boolean stillValid(class_1657 player, class_3218 level, @Nullable class_2338 pos) {
        return player.method_31548().method_43256(stack -> {
            if (stack.method_7960() || !(stack.method_7909() instanceof SculkTransmitterItem) || !SculkTransmitterItem.isLinked(stack)) {
                return false;
            }
            String block = stack.method_7969().method_10558("block");
            class_4208 globalPos = SculkTransmitterItem.readGlobalPosition(stack.method_7948()).get();
            if (level.method_27983().equals(globalPos.method_19442()) && (pos == null || globalPos.method_19446().method_10262((class_2382)pos) < 64.0) && level.method_8320(globalPos.method_19446()).method_26204().method_9539().equals(block)) {
                class_1923 chunkPos = new class_1923(globalPos.method_19446());
                level.method_14178().method_17297(class_3230.field_14032, chunkPos, 1, (Object)chunkPos);
                return true;
            }
            return false;
        });
    }

    public static boolean stillValid(class_1657 player, class_3914 containerLevelAccess) {
        return (Boolean)containerLevelAccess.method_17396((level, pos) -> {
            if (!(level instanceof class_3218)) {
                return false;
            }
            class_3218 serverLevel = (class_3218)level;
            return SculkTransmitterItem.stillValid(player, serverLevel, pos);
        }, (Object)true);
    }

    public static class_1792 fromColor(class_1767 color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case class_1767.field_7952 -> DDItems.WHITE_SCULK_TRANSMITTER;
            case class_1767.field_7946 -> DDItems.ORANGE_SCULK_TRANSMITTER;
            case class_1767.field_7958 -> DDItems.MAGENTA_SCULK_TRANSMITTER;
            case class_1767.field_7951 -> DDItems.LIGHT_BLUE_SCULK_TRANSMITTER;
            case class_1767.field_7947 -> DDItems.YELLOW_SCULK_TRANSMITTER;
            case class_1767.field_7961 -> DDItems.LIME_SCULK_TRANSMITTER;
            case class_1767.field_7954 -> DDItems.PINK_SCULK_TRANSMITTER;
            case class_1767.field_7944 -> DDItems.GRAY_SCULK_TRANSMITTER;
            case class_1767.field_7967 -> DDItems.LIGHT_GRAY_SCULK_TRANSMITTER;
            case class_1767.field_7955 -> DDItems.CYAN_SCULK_TRANSMITTER;
            case class_1767.field_7945 -> DDItems.PURPLE_SCULK_TRANSMITTER;
            case class_1767.field_7966 -> DDItems.BLUE_SCULK_TRANSMITTER;
            case class_1767.field_7957 -> DDItems.BROWN_SCULK_TRANSMITTER;
            case class_1767.field_7942 -> DDItems.GREEN_SCULK_TRANSMITTER;
            case class_1767.field_7964 -> DDItems.RED_SCULK_TRANSMITTER;
            case class_1767.field_7963 -> DDItems.BLACK_SCULK_TRANSMITTER;
        };
    }

    public static enum CooldownType {
        LINK,
        UNLINK;

    }
}

