/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.potions;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModPotions {
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((ResourceKey)Registries.POTION, (String)"rusticdelight");
    public static final Holder<Potion> HASTE_POTION = ModPotions.register("haste", (Holder<MobEffect>)MobEffects.DIG_SPEED, 3600);
    public static final Holder<Potion> LONG_HASTE_POTION = ModPotions.register("long_haste", "haste", (Holder<MobEffect>)MobEffects.DIG_SPEED, 9600, 0);
    public static final Holder<Potion> STRONG_HASTE_POTION = ModPotions.register("strong_haste", "haste", (Holder<MobEffect>)MobEffects.DIG_SPEED, 1800, 1);

    private static Holder<Potion> register(String name, Holder<MobEffect> effect, int duration) {
        return POTIONS.register(name, () -> new Potion(name, new MobEffectInstance[]{new MobEffectInstance(effect, duration, 0)}));
    }

    private static Holder<Potion> register(String name, String potionName, Holder<MobEffect> effect, int duration, int amplifier) {
        return POTIONS.register(name, () -> new Potion(potionName, new MobEffectInstance[]{new MobEffectInstance(effect, duration, amplifier)}));
    }

    public static void register(IEventBus eventBus) {
        POTIONS.register(eventBus);
    }
}

