/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.blocks;

import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.init.MPItems;
import com.stevekung.moreplanets.planets.nibiru.tileentity.TileEntityNuclearWasteTank;
import com.stevekung.moreplanets.tileentity.TileEntityDarkEnergyReceiver;
import com.stevekung.moreplanets.tileentity.TileEntityDummy;
import com.stevekung.moreplanets.utils.blocks.BlockContainerMP;
import java.util.Collection;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDummy
extends BlockContainerMP
implements IPartialSealableBlock {
    private static final AxisAlignedBB AABB_WARP_PAD = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    private static final AxisAlignedBB AABB_DER_SOLAR1 = new AxisAlignedBB(-0.25, 0.3, 0.3, 0.5, 0.6, 0.7);
    private static final AxisAlignedBB AABB_DER_SOLAR2 = new AxisAlignedBB(0.5, 0.3, 0.3, 1.25, 0.6, 0.7);
    private static final AxisAlignedBB AABB_DER_SOLAR3 = new AxisAlignedBB(0.3, 0.3, -0.25, 0.7, 0.6, 0.5);
    private static final AxisAlignedBB AABB_DER_SOLAR4 = new AxisAlignedBB(0.3, 0.3, 0.5, 0.7, 0.6, 1.25);
    private final BlockType type;

    public BlockDummy(String name, BlockType type) {
        super(name, Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.type = type;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.type == BlockType.WARP_PAD) {
            return AABB_WARP_PAD;
        }
        if (this.type == BlockType.DARK_ENERGY_SOLAR1) {
            return AABB_DER_SOLAR1;
        }
        if (this.type == BlockType.DARK_ENERGY_SOLAR2) {
            return AABB_DER_SOLAR2;
        }
        if (this.type == BlockType.DARK_ENERGY_SOLAR3) {
            return AABB_DER_SOLAR3;
        }
        if (this.type == BlockType.DARK_ENERGY_SOLAR4) {
            return AABB_DER_SOLAR4;
        }
        return Block.field_185505_j;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDummy && (mainBlockPosition = ((TileEntityDummy)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            TileEntity tileOther = world.func_175625_s(mainBlockPosition);
            if (tileOther instanceof TileEntityDarkEnergyReceiver) {
                TileEntityDarkEnergyReceiver dark = (TileEntityDarkEnergyReceiver)tileOther;
                if ((dark.activated || dark.failed) && !dark.successful) {
                    return -1.0f;
                }
            }
            return world.func_180495_p(mainBlockPosition).func_185887_b(world, mainBlockPosition);
        }
        return this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDummy && (mainBlockPosition = ((TileEntityDummy)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            return world.func_180495_p(mainBlockPosition).func_177230_c().getExplosionResistance(world, mainBlockPosition, exploder, explosion);
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing facing) {
        if (this.type == BlockType.WARP_PAD) {
            return facing == EnumFacing.DOWN;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDummy) {
            ((TileEntityDummy)tileEntity).onBlockRemoval();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityDummy tileEntity = (TileEntityDummy)world.func_175625_s(pos);
        ItemStack heldStack = player.func_184586_b(hand);
        if (tileEntity == null) {
            return false;
        }
        return this.onNuclearTankActivated(world, pos, this.type == BlockType.NUCLEAR_WASTE_TANK_MIDDLE ? pos.func_177977_b() : pos.func_177979_c(2), player, heldStack) || tileEntity.onBlockActivated(player);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDummy();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Block mainBlock;
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityDummy && (mainBlockPosition = ((TileEntityDummy)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos) && Blocks.field_150350_a != (mainBlock = world.func_180495_p(mainBlockPosition).func_177230_c())) {
            return mainBlock.getPickBlock(state, target, world, mainBlockPosition, player);
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(target.func_178782_a());
        if (tileEntity instanceof TileEntityDummy && (mainBlockPosition = ((TileEntityDummy)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)target.func_178782_a())) {
            manager.addBlockHitEffects(mainBlockPosition, target);
        }
        return super.addHitEffects(state, world, target, manager);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return this.type == BlockType.NUCLEAR_WASTE_TANK_TOP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public void makeFakeBlock(World world, Collection<BlockPos> posList, BlockPos mainBlock) {
        for (BlockPos pos : posList) {
            world.func_180501_a(pos, this.func_176223_P(), 3);
            world.func_175690_a(pos, (TileEntity)new TileEntityDummy(mainBlock));
        }
    }

    public void makeFakeBlock(World world, BlockPos pos, BlockPos mainBlock) {
        world.func_180501_a(pos, this.func_176223_P(), 3);
        world.func_175690_a(pos, (TileEntity)new TileEntityDummy(mainBlock));
    }

    private boolean onNuclearTankActivated(World world, BlockPos pos, BlockPos detectPos, EntityPlayer player, ItemStack heldStack) {
        if (world.func_175625_s(detectPos) instanceof TileEntityNuclearWasteTank && world.func_180495_p(detectPos) == MPBlocks.NUCLEAR_WASTE_TANK.func_176223_P()) {
            TileEntityNuclearWasteTank tank = (TileEntityNuclearWasteTank)world.func_175625_s(detectPos);
            if (!heldStack.func_190926_b()) {
                if (tank.hasRod && !tank.createRod) {
                    if (heldStack.func_77973_b() == MPItems.WASTE_ROD_PICKER) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldStack.func_77972_a(1, (EntityLivingBase)player);
                        }
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MPItems.NUCLEAR_WASTE_ROD));
                        tank.hasRod = false;
                        return true;
                    }
                } else {
                    int slot = player.field_71071_by.field_70461_c;
                    FluidActionResult result = FluidUtil.interactWithFluidHandler((ItemStack)player.field_71071_by.func_70448_g(), (IFluidHandler)((IFluidHandler)tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)), (EntityPlayer)player);
                    if (result.isSuccess()) {
                        tank.createRod = true;
                        tank.setTime();
                        player.field_71071_by.func_70299_a(slot, result.result);
                        if (player.field_71069_bz != null) {
                            player.field_71069_bz.func_75142_b();
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static enum BlockType {
        WARP_PAD,
        DARK_ENERGY_SOLAR1,
        DARK_ENERGY_SOLAR2,
        DARK_ENERGY_SOLAR3,
        DARK_ENERGY_SOLAR4,
        NUCLEAR_WASTE_TANK_MIDDLE,
        NUCLEAR_WASTE_TANK_TOP,
        SHIELD_GENERATOR_TOP;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

