/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.blocks;

import com.stevekung.lib.utils.ColorUtils;
import com.stevekung.lib.utils.JsonUtils;
import com.stevekung.lib.utils.LangUtils;
import com.stevekung.lib.utils.client.ClientUtils;
import com.stevekung.moreplanets.init.MPBlocks;
import com.stevekung.moreplanets.tileentity.TileEntitySpaceWarpPad;
import com.stevekung.moreplanets.utils.BlocksItemsRegistry;
import com.stevekung.moreplanets.utils.IDescription;
import com.stevekung.moreplanets.utils.ItemDescription;
import com.stevekung.moreplanets.utils.blocks.BlockAdvancedTileMP;
import com.stevekung.moreplanets.utils.blocks.MPBlockCategory;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSpaceWarpPad
extends BlockAdvancedTileMP
implements IPartialSealableBlock,
IDescription {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockSpaceWarpPad(String name) {
        super(name, Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (GCCoreUtil.getDimensionID((World)world) != 0 && !(world.field_73011_w instanceof IGalacticraftWorldProvider)) {
            if (world.field_72995_K) {
                ClientUtils.printClientMessage((ITextComponent)JsonUtils.create((String)LangUtils.translate((String)"gui.place_only_space.message")).func_150255_a(JsonUtils.red()));
            }
            return false;
        }
        if (!(this.checkAxis(world, pos, EnumFacing.EAST) && this.checkAxis(world, pos, EnumFacing.WEST) && this.checkAxis(world, pos, EnumFacing.NORTH) && this.checkAxis(world, pos, EnumFacing.SOUTH))) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() == MPBlocks.SPACE_WARP_PAD && side == EnumFacing.UP) {
            return false;
        }
        return this.func_176196_c(world, pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySpaceWarpPad();
    }

    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return direction == EnumFacing.UP;
    }

    @Override
    public MPBlockCategory getBlockCategory() {
        return MPBlockCategory.MACHINE_NON_BLOCK;
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(BlocksItemsRegistry.getDescription(this.func_149739_a() + ".description"));
    }

    @Override
    public ColorUtils.RGB getRarityColor() {
        return ColorUtils.stringToRGB((String)"124, 124, 124");
    }

    private boolean checkAxis(World world, BlockPos pos, EnumFacing facing) {
        int sameCount = 0;
        for (int i = 1; i <= 3; ++i) {
            if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != MPBlocks.SPACE_WARP_PAD) continue;
            ++sameCount;
        }
        return sameCount < 3;
    }
}

