/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.moreplanets.client.gui;

import com.stevekung.lib.utils.LangUtils;
import com.stevekung.moreplanets.inventory.ContainerBlackHoleStorage;
import com.stevekung.moreplanets.network.PacketSimpleMP;
import com.stevekung.moreplanets.tileentity.TileEntityBlackHoleStorage;
import com.stevekung.moreplanets.utils.client.gui.GuiContainerMP;
import com.stevekung.moreplanets.utils.client.gui.GuiElementCheckboxMP;
import com.stevekung.moreplanets.utils.client.gui.GuiElementInfoRegionMP;
import java.util.Collections;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBlackHoleStorage
extends GuiContainerMP
implements GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/gui/black_hole_storage.png");
    private static final ResourceLocation XP_TEXTURE = new ResourceLocation("moreplanets:textures/gui/black_hole_storage_xp.png");
    private GuiElementCheckbox disableBlackHoleCheckbox;
    private GuiElementCheckbox useHopperCheckbox;
    private GuiElementCheckboxMP collectModeCheckbox;
    private GuiElementInfoRegionMP xpValueInfo;
    private final TileEntityBlackHoleStorage tile;

    public GuiBlackHoleStorage(IInventory player, TileEntityBlackHoleStorage tile) {
        super(new ContainerBlackHoleStorage(player, (IInventory)tile));
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.tile = tile;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 178, y + 192, 13, 13, Collections.singletonList(LangUtils.translate((String)"gui.disable_black_hole.desc")), this.field_146294_l, this));
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 198, y + 192, 13, 13, Collections.singletonList(LangUtils.translate((String)"gui.use_hopper.desc")), this.field_146294_l, this));
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 218, y + 192, 13, 13, Collections.singletonList(LangUtils.translate((String)"gui.collect_mode.desc")), this.field_146294_l, this));
        this.xpValueInfo = new GuiElementInfoRegionMP(x + 238, y + 170, 5, 37, null, this.field_146294_l, this);
        this.infoRegions.add(this.xpValueInfo);
        this.disableBlackHoleCheckbox = new GuiElementCheckbox(0, (GuiElementCheckbox.ICheckBoxCallback)this, x + 178, y + 192, "");
        this.useHopperCheckbox = new GuiElementCheckbox(1, (GuiElementCheckbox.ICheckBoxCallback)this, x + 198, y + 192, "");
        this.collectModeCheckbox = new GuiElementCheckboxMP(2, this, x + 218, y + 192, "");
        this.field_146292_n.add(this.disableBlackHoleCheckbox);
        this.field_146292_n.add(this.useHopperCheckbox);
        this.field_146292_n.add(this.collectModeCheckbox);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tile.func_145831_w().func_152378_a(UUID.fromString(this.tile.ownerUUID)).func_70005_c_() + "'s", this.field_146999_f - 92 + 8, this.field_147000_g - 97 + 12, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.translate((String)"container.black_hole_storage_short.name"), this.field_146999_f - 92 + 8, this.field_147000_g - 87 + 12, 0x404040);
        String bhStatus = this.tile.disableBlackHole ? TextFormatting.RED + LangUtils.translate((String)"gui.button.disable.name") : TextFormatting.GREEN + LangUtils.translate((String)"gui.button.enable.name");
        this.field_146289_q.func_78276_b(LangUtils.translate((String)"gui.message.status.name") + ": " + bhStatus, this.field_146999_f - 91 + 8, this.field_147000_g - 86 + 44, 2536735);
        String hopperStatus = !this.tile.useHopper ? TextFormatting.RED + LangUtils.translate((String)"gui.button.disable.name") : TextFormatting.GREEN + LangUtils.translate((String)"gui.button.enable.name");
        this.field_146289_q.func_78276_b(LangUtils.translate((String)"gui.status.use_hopper.name") + ": " + hopperStatus, this.field_146999_f - 91 + 8, this.field_147000_g - 86 + 54, 2536735);
        String collectMode = this.tile.collectMode.equals("item") ? TextFormatting.AQUA + LangUtils.translate((String)"gui.status.collect_item.name") : (this.tile.collectMode.equals("item_and_xp") ? TextFormatting.AQUA + LangUtils.translate((String)"gui.status.collect_item_and_xp.name") : TextFormatting.AQUA + LangUtils.translate((String)"gui.status.collect_xp.name"));
        this.field_146289_q.func_78276_b(LangUtils.translate((String)"gui.status.collect_mode.name") + ": " + collectMode, this.field_146999_f - 91 + 8, this.field_147000_g - 86 + 64, 2536735);
        this.xpValueInfo.tooltipStrings = Collections.singletonList(LangUtils.translate((String)"gui.xp_value.desc") + ": " + this.tile.xpTemp + "/" + this.tile.getMaxXP());
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(XP_TEXTURE);
        int level = Math.min((int)Math.floor((double)this.tile.fluidTank.getFluidAmount() * 37.0 / (double)this.tile.getMaxXP()), 37);
        this.func_73729_b(x + 238, y + 170 + 37 - level, 238, 170 - level + 37, 5, level);
        this.disableBlackHoleCheckbox.isSelected = this.tile.disableBlackHole;
        this.useHopperCheckbox.isSelected = this.tile.useHopper;
    }

    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        if (checkbox.equals(this.disableBlackHoleCheckbox)) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_BLACK_HOLE_STORAGE_OPTION, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), this.tile.func_174877_v(), "disable"));
        } else if (checkbox.equals((Object)this.collectModeCheckbox)) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_BLACK_HOLE_STORAGE_OPTION, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), this.tile.func_174877_v(), "collect_mode"));
        } else {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_BLACK_HOLE_STORAGE_OPTION, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), this.tile.func_174877_v(), "use_hopper"));
        }
    }

    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return player.func_146103_bH().getId().toString().equals(this.tile.ownerUUID);
    }

    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        if (checkbox.equals(this.disableBlackHoleCheckbox)) {
            return this.tile.disableBlackHole;
        }
        return this.tile.useHopper;
    }

    public void onIntruderInteraction() {
    }
}

